/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.volume.snapshot;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.vmservice.cmd.AbstractCommand;
import com.sap.cloud.vmservice.cmd.TimestampFormatter;
import com.sap.cloud.vmservice.cmd.validator.UUIDValidator;
import com.sap.cloud.vmservice.cmd.volume.VolumeDTO;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotClient;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotModel;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Parameters(commandDescription="Lists volume snapshots in the specified subaccount. Use display-volume-snapshot to get information about a specific volume snapshot.")
public class ListVolumeSnapshotsCommand
extends AbstractCommand {
    @Parameter(names={"-v", "--volume-id"}, description="Unique identifier of the volume", validateWith=UUIDValidator.class)
    protected String volumeId;
    private TimestampFormatter formatter = new TimestampFormatter();

    public String getName() {
        return "list-volume-snapshots";
    }

    public void run() throws CommandException {
        this.dumpParameters("Listing available volume snapshots");
        List<VolumeSnapshotModel> volumeSnapshots = this.getVolumeSnapshots();
        this.printOutput(volumeSnapshots);
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        if (!this.isMissing(this.volumeId)) {
            Collections.addAll(parameters, "volume id", this.volumeId);
        }
        return parameters;
    }

    public List<VolumeDTO> runForStructuredOutput() {
        List<VolumeSnapshotModel> rawResult = this.getVolumeSnapshots();
        ArrayList<VolumeDTO> result = new ArrayList<VolumeDTO>();
        for (VolumeSnapshotModel model : rawResult) {
            result.add(new VolumeDTO(model));
        }
        return result;
    }

    private List<VolumeSnapshotModel> getVolumeSnapshots() {
        return this.getClient(VolumeSnapshotClient.class).getAll(this.volumeId);
    }

    private void printOutput(List<VolumeSnapshotModel> volumeSnapshots) {
        if (!volumeSnapshots.isEmpty()) {
            DumpHelper.dump((String)"Volume snapshots:");
            for (VolumeSnapshotModel volumeSnapshot : volumeSnapshots) {
                String formattedTime = this.formatter.formatTimestamp(volumeSnapshot.getCreatedAt());
                DumpHelper.dumpOperationList((String)volumeSnapshot.getName(), (Object[])new Object[]{"id", volumeSnapshot.getId(), "status", volumeSnapshot.getStatus(), "size", volumeSnapshot.getSize() + "GB", "volume id", volumeSnapshot.getVolumeId(), "created at", formattedTime});
            }
        } else {
            DumpHelper.dump((String)String.format("No volume snapshots exist in subaccount %s", this.account));
        }
    }
}

