/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.vmservice.cmd.volume.snapshot;

import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotClient;
import com.sap.cloud.vmservice.cmd.volume.snapshot.VolumeSnapshotModel;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.util.ArrayList;
import java.util.List;

public class VolumeSnapshotUtil {
    public VolumeSnapshotModel getVolumeSnapshotFromName(VolumeSnapshotClient volumeSnapshotClient, String snapshotName, String account, String action) {
        List<VolumeSnapshotModel> volumeSnapshotModels = volumeSnapshotClient.getAll(null);
        List<VolumeSnapshotModel> volumeSnapshotsByName = this.filterSnapshotsByName(volumeSnapshotModels, snapshotName);
        if (volumeSnapshotsByName.isEmpty()) {
            throw new CommandException(String.format("Volume snapshot with name %s does not exist in subaccount %s.", snapshotName, account));
        }
        if (volumeSnapshotsByName.size() > 1) {
            String message = "There are more than one volume snapshots with name %s in subaccount %s. To %s this specific volume snapshot, use its snapshot ID instead.";
            throw new CommandException(String.format(message, snapshotName, account, action));
        }
        return volumeSnapshotsByName.get(0);
    }

    private List<VolumeSnapshotModel> filterSnapshotsByName(List<VolumeSnapshotModel> volumeSnapshotModels, String snapshotName) {
        ArrayList<VolumeSnapshotModel> snapshotsByName = new ArrayList<VolumeSnapshotModel>();
        for (VolumeSnapshotModel volumeSnapshotModel : volumeSnapshotModels) {
            if (!snapshotName.equals(volumeSnapshotModel.getName())) continue;
            snapshotsByName.add(volumeSnapshotModel);
        }
        return snapshotsByName;
    }
}

