/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.commons;

import com.sap.cloud.security.oauth2.commons.exception.OAuthProblemException;
import com.sap.cloud.security.oauth2.commons.logging.CommonLogger;
import com.sap.cloud.security.oauth2.commons.logging.CommonLoggerFactory;
import com.sap.engine.lib.security.login.SubjectWrapper;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;

public class PrincipalExtractor {
    private static final String ERROR_MESSAGE_PREFIX = "Cannot extract Principal.";
    static final String SECURITY_AUTH_LOGIN_SUBJECT = "com.sap.security.auth.login.Subject";
    protected static final CommonLogger logger = CommonLoggerFactory.getLogger(PrincipalExtractor.class);
    private HttpServletRequest request;

    public PrincipalExtractor(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        this.request = request;
    }

    public Principal getPrincipal() throws OAuthProblemException {
        if (this.request.getSession(false) == null) {
            throw new OAuthProblemException("Cannot extract Principal. Session is null.");
        }
        Object attribute = this.request.getSession().getAttribute(SECURITY_AUTH_LOGIN_SUBJECT);
        if (attribute == null || !SubjectWrapper.class.isAssignableFrom(attribute.getClass())) {
            throw new OAuthProblemException("Cannot extract Principal. No attribute [com.sap.security.auth.login.Subject] in the session");
        }
        SubjectWrapper subjectWrapper = (SubjectWrapper)attribute;
        Principal principal = subjectWrapper.getPrincipal();
        if (principal == null) {
            throw new OAuthProblemException("Cannot extract Principal. Principal is null");
        }
        return principal;
    }
}

