/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.commons.logging;

import com.sap.cloud.security.oauth2.commons.logging.CommonLogger;
import com.sap.cloud.security.oauth2.commons.logging.imp.CommonLoggerWrapper;
import com.sap.cloud.security.oauth2.commons.logging.imp.OAuthCloudLoggingImpl;

public class CommonLoggerFactory {
    private static CommonLoggerWrapper mLogger = null;
    private static boolean isRunningInOnDemand = true;
    private static CommonLogger factoryLogger = null;

    static {
        try {
            String isOnPremiseServer = System.getProperty("server");
            String onPremiseServerNodeID = System.getProperty("SAP.GUID.UniqueNodeID");
            if (isOnPremiseServer != null && isOnPremiseServer.equalsIgnoreCase("true") && onPremiseServerNodeID != null && onPremiseServerNodeID.length() > 0) {
                isRunningInOnDemand = false;
                mLogger = new CommonLoggerWrapper();
            }
        }
        catch (SecurityException se) {
            if (factoryLogger == null) {
                factoryLogger = new OAuthCloudLoggingImpl(CommonLoggerFactory.class);
            }
            factoryLogger.debug("Failed to load system properties", se);
        }
    }

    private CommonLoggerFactory() {
    }

    public static CommonLogger getLogger(Class<?> classLoggingLocation) {
        if (isRunningInOnDemand) {
            OAuthCloudLoggingImpl defaultLoggingImplementation = new OAuthCloudLoggingImpl(classLoggingLocation);
            return defaultLoggingImplementation;
        }
        return mLogger;
    }

    public static void setLoggingImplementation(CommonLogger loggingImplementation) throws IllegalArgumentException {
        if (loggingImplementation == null) {
            throw new IllegalArgumentException("Logging impelementation can't be set.");
        }
        mLogger.setLogger(loggingImplementation);
    }
}

