/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.commons.token;

import com.google.gson.GsonBuilder;
import com.sap.cloud.security.oauth2.commons.LoggerHelper;
import com.sap.cloud.security.oauth2.commons.token.AccessTokenInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformAPITokenInfo {
    private static final Logger logger = LoggerFactory.getLogger(PlatformAPITokenInfo.class);
    private String jti;
    private String sub;
    private List<String> authorities;
    private List<String> scopes;
    private String client_id;
    private String grant_type;
    private long iat;
    private long exp;
    private List<String> aud;

    public PlatformAPITokenInfo() {
        this.authorities = new ArrayList<String>();
        this.scopes = new ArrayList<String>();
        this.aud = new ArrayList<String>();
    }

    public PlatformAPITokenInfo(String jti, String sub, List<String> authorities, List<String> scopes, String client_id, String grant_type, long iat, long exp, List<String> aud) {
        this.jti = jti;
        this.sub = sub;
        this.authorities = authorities;
        this.scopes = scopes;
        this.client_id = client_id;
        this.grant_type = grant_type;
        this.iat = iat;
        this.exp = exp;
        this.aud = aud;
    }

    public PlatformAPITokenInfo(String accessTokenId, AccessTokenInfo info) {
        this.jti = accessTokenId;
        this.sub = info.getClientid();
        this.authorities = Arrays.asList(info.getAuthorities().split(","));
        this.scopes = new ArrayList<String>(info.getScopes());
        this.client_id = info.getClientid();
        this.grant_type = info.getGrantType().getGrantString();
        this.iat = info.getIssuedat();
        this.exp = info.getIssuedat() + (long)(info.getExpiresin() * 1000);
        HashSet<String> audienceSet = new HashSet<String>();
        for (String scopeString : this.scopes) {
            int index = scopeString.indexOf(".");
            if (index <= 0) continue;
            audienceSet.add(scopeString.substring(0, index));
        }
        if (audienceSet.isEmpty()) {
            logger.debug("Can't determine audience for scopes string {}. Adding default audience hcp for token {}", this.scopes, (Object)LoggerHelper.getTokenForLog(info.getAccessToken()));
            audienceSet.add("hcp");
        }
        this.aud = new ArrayList<String>(audienceSet);
    }

    public String getJti() {
        return this.jti;
    }

    public void setJti(String jti) {
        this.jti = jti;
    }

    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public List<String> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(List<String> authorities) {
        this.authorities = authorities;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getClient_id() {
        return this.client_id;
    }

    public void setClient_id(String client_id) {
        this.client_id = client_id;
    }

    public String getGrant_type() {
        return this.grant_type;
    }

    public void setGrant_type(String grant_type) {
        this.grant_type = grant_type;
    }

    public long getIat() {
        return this.iat;
    }

    public void setIat(long iat) {
        this.iat = iat;
    }

    public long getExp() {
        return this.exp;
    }

    public void setExp(long exp) {
        this.exp = exp;
    }

    public List<String> getAud() {
        return this.aud;
    }

    public void setAud(List<String> aud) {
        this.aud = aud;
    }

    public String toJson() {
        return new GsonBuilder().create().toJson((Object)this);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.client_id == null ? 0 : this.client_id.hashCode());
        result = 31 * result + (this.jti == null ? 0 : this.jti.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlatformAPITokenInfo other = (PlatformAPITokenInfo)obj;
        if (this.client_id == null ? other.client_id != null : !this.client_id.equals(other.client_id)) {
            return false;
        }
        return !(this.jti == null ? other.jti != null : !this.jti.equals(other.jti));
    }

    public String toString() {
        return "PlatformAPITokenInfo [jti=" + this.jti + ", sub=" + this.sub + ", authorities=" + this.authorities + ", scopes=" + this.scopes + ", client_id=" + this.client_id + ", grant_type=" + this.grant_type + ", iat=" + this.iat + ", exp=" + this.exp + ", aud=" + this.aud + "]";
    }
}

