/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons;

import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.interfaces.SAML2Config;
import com.sap.security.saml2.cfg.interfaces.SAML2SPConfiguration;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedProvider;
import com.sap.security.saml2.cfg.util.SAML2CfgServicesManager;
import com.sap.security.saml2.commons.SAML2CommonServicesManager;
import com.sap.security.saml2.commons.interfaces.services.ArtifactRecord;
import com.sap.security.saml2.commons.interfaces.services.ArtifactService;
import com.sap.security.saml2.commons.interfaces.services.ArtifactStorage;
import com.sap.security.saml2.lib.bindings.SOAPHTTPBinding;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ProtocolFactory;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.common.exceptions.SAML2ArtifactExpiredException;
import com.sap.security.saml2.lib.common.exceptions.SAML2ArtifactInvalidProviderException;
import com.sap.security.saml2.lib.common.exceptions.SAML2ArtifactMissingException;
import com.sap.security.saml2.lib.interfaces.SAML2SignableToken;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Artifact;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ArtifactResolve;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ArtifactResponse;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ProtocolToken;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ResponseBase;
import com.sap.tc.logging.Location;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

public class ArtifactServiceImpl
implements ArtifactService {
    private static final Location LOCATION = Location.getLocation(ArtifactServiceImpl.class);
    private ArtifactStorage artifactStorage;

    ArtifactServiceImpl(ArtifactStorage artifactStorage) {
        if (artifactStorage == null) {
            throw new IllegalArgumentException("Artifact storage cannot be null");
        }
        this.artifactStorage = artifactStorage;
    }

    @Override
    public SAML2Artifact issueArtifact(int endpointIndex, int validityPeriodInSeconds, String issuer, String recipient, String protocolToken) throws SAML2Exception {
        boolean stored;
        if (LOCATION.bePath()) {
            LOCATION.entering("issueArtifact(int, int, String, String, String)", new Object[]{endpointIndex, validityPeriodInSeconds, issuer, recipient, protocolToken});
        }
        if (issuer == null || issuer.length() < 0 || recipient == null || recipient.length() < 0 || protocolToken == null || protocolToken.length() < 0) {
            throw new SAML2Exception("Missing or empty arguments. issuer: \"" + issuer + "\" recipient: \"" + recipient + "\" protocolToken: \"" + protocolToken + "\".");
        }
        if (validityPeriodInSeconds < 1) {
            throw new SAML2Exception("Invalid validity period: \"" + validityPeriodInSeconds + "\". Should be positive.");
        }
        byte[] messageHandle = SAML2Utils.generateUUID((int)20);
        SAML2Artifact artifact = SAML2DataFactory.getInstance().createSAML2Artifact(endpointIndex, issuer, messageHandle);
        String artifactValue = artifact.getValue();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Generated artifact is: " + artifact);
        }
        long currentTime = System.currentTimeMillis();
        long notAfter = currentTime + 1000L * (long)validityPeriodInSeconds;
        try {
            stored = this.artifactStorage.issueArtifact(artifactValue, protocolToken, issuer, recipient, notAfter);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to store the artifact mapping into DB storage", (Throwable)e);
        }
        if (!stored) {
            throw new SAML2Exception("Failed to store the artifact there is already existing record");
        }
        if (LOCATION.bePath()) {
            LOCATION.exiting("issueArtifact(int, int, String, String, String)", (Object)artifact);
        }
        return artifact;
    }

    @Override
    public String resolveArtifact(SAML2Artifact artifact, String issuer, String recipient) throws SAML2Exception {
        ArtifactRecord record;
        if (LOCATION.bePath()) {
            LOCATION.entering("resolveArtifact(SAML2Artifact, String, String)", new Object[]{artifact, issuer, recipient});
        }
        if (artifact == null || issuer == null || issuer.length() < 0 || recipient == null || recipient.length() < 0) {
            throw new SAML2Exception("Missing or empty arguments. artifact: \"" + artifact + "\" issuer: \"" + issuer + "\" recipient: \"" + recipient + "\".");
        }
        try {
            record = this.artifactStorage.resolveArtifact(artifact.getValue(), issuer, recipient);
        }
        catch (Exception e) {
            throw new SAML2Exception("Failed to resolve the artifact mapping from the DB storage", (Throwable)e);
        }
        if (record.resolveStatus != 0) {
            if (1 == record.resolveStatus) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("The artifact: " + artifact + " was not resolved from the storage.");
                }
                throw new SAML2ArtifactMissingException("There isn't stored mapping for the artifact: " + artifact);
            }
            if (2 == record.resolveStatus) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("The artifact: " + artifact + " was issued from provider: " + record.issuer + ", but attempt to be resolved from provider: " + issuer);
                }
                throw new SAML2ArtifactInvalidProviderException("The artifact: " + artifact + " was issued from provider different from the provider which performs the resolving: " + issuer);
            }
            if (4 == record.resolveStatus) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("The artifact: " + artifact + " was issued for provider: " + record.recipient + ", but attempt to be resolved for provider: " + recipient);
                }
                throw new SAML2ArtifactInvalidProviderException("The artifact: " + artifact + " was issued for provider different from the provider for which the resolving is performed: " + recipient);
            }
            throw new SAML2Exception("Failed to resolve the artifact mapping from the DB storage. Resolve failure reason: " + record.resolveStatus);
        }
        long notAfter = record.validity;
        long currentTime = System.currentTimeMillis();
        if (currentTime > notAfter) {
            throw new SAML2ArtifactExpiredException("The artifact mapping is expired. Current time: " + currentTime + " artifact is valid not after: " + notAfter);
        }
        String result = record.saml2Token;
        if (LOCATION.bePath()) {
            LOCATION.exiting("resolveArtifact(SAML2Artifact, String, String)", (Object)result);
        }
        return result;
    }

    @Override
    public SAML2ProtocolToken resolveArtifact(SAML2Config config, SAML2Artifact artifact) throws SAML2Exception {
        return this.resolveArtifact(config, artifact, null);
    }

    @Override
    public SAML2ProtocolToken resolveArtifact(SAML2Config config, SAML2Artifact artifact, Map<String, String> signedInfo) throws SAML2Exception {
        byte[] sourceID = artifact.getSourceID();
        SAML2TrustedProvider issuerConfig = config.getTrustedProviderByID(sourceID);
        if (issuerConfig == null) {
            String text = "Cannot find trusted provider by ID (hex): " + SAML2Utils.byteArrayToHEXString((byte[])sourceID);
            if (LOCATION.beDebug()) {
                LOCATION.debugT(text);
            }
            throw new SAML2Exception(text);
        }
        return this.resolveArtifact(config.getLocalProvidersConfiguration().getLocalProvider(), issuerConfig, artifact, signedInfo, null, null);
    }

    @Override
    public SAML2ProtocolToken resolveArtifact(SAML2SPConfiguration spConfig, SAML2Artifact artifact, String userName, char[] password) throws SAML2Exception {
        byte[] sourceID = artifact.getSourceID();
        SAML2TrustedIdP issuerConfig = spConfig.getTrustedIdP(sourceID);
        if (issuerConfig == null) {
            String text = "Cannot find trusted provider by ID (hex): " + SAML2Utils.byteArrayToHEXString((byte[])sourceID);
            if (LOCATION.beDebug()) {
                LOCATION.debugT(text);
            }
            throw new SAML2Exception(text);
        }
        return this.resolveArtifact((SAML2LocalProvider)spConfig.getLocalSP(), (SAML2TrustedProvider)issuerConfig, artifact, null, userName, password);
    }

    public SAML2ProtocolToken resolveArtifact(SAML2LocalProvider localProviderConfig, SAML2TrustedProvider issuerConfig, SAML2Artifact artifact, Map<String, String> signedInfo, String userName, char[] password) throws SAML2Exception {
        try {
            SAML2ResponseBase response;
            SAML2Endpoint endPoint = issuerConfig.getArtifactResolutionEndpoint(artifact.getEndpointIndex());
            if (endPoint == null) {
                String text = "The referenced end point with index " + artifact.getEndpointIndex() + " does not exist in the configuration for trusted provider " + issuerConfig.getName() + ".";
                if (LOCATION.beDebug()) {
                    LOCATION.debugT(text);
                }
                throw new SAML2Exception(text);
            }
            SAML2ArtifactResolve artifactResolve = SAML2ProtocolFactory.getInstance().createArtifactResolve("R-ART-" + UUID.randomUUID().toString(), new Date(), artifact);
            SAML2NameID localProviderNameID = SAML2DataFactory.getInstance().createSAML2NameID(localProviderConfig.getName());
            artifactResolve.setIssuer(localProviderNameID);
            artifactResolve.setDestination(endPoint.getResponseLocation());
            boolean signArtifactResolve = issuerConfig.isToSignArtifactResolutionMessages().equals((Object)SignatureOption.ALWAYS);
            if (signArtifactResolve) {
                artifactResolve.setDigestAlgorithm(issuerConfig.getDigestAlgorithm().toString());
                if (localProviderConfig.isToIncludeCertInSignature()) {
                    artifactResolve.sign(localProviderConfig.getPrivateKeyForSignature(), localProviderConfig.getCertificateForSignature());
                } else {
                    artifactResolve.sign(localProviderConfig.getPrivateKeyForSignature());
                }
                if (signedInfo != null) {
                    signedInfo.put("ArtifactResolveSigned", "true");
                }
            }
            HttpURLConnection connection = null;
            String destName = endPoint.getDestinationName();
            if (destName != null && destName.length() > 0) {
                connection = SAML2CfgServicesManager.getInstance().getHTTPDestinationServiceInstance().getHttpURLConnection(destName);
                if (connection == null) {
                    throw new SAML2Exception("Could not found URL connection specified with the destination name: " + destName);
                }
            } else {
                String location = endPoint.getLocation();
                if (location == null || location.length() < 1) {
                    throw new SAML2Exception("ARS endpoint with index: " + artifact.getEndpointIndex() + " has no destionation or location configured.");
                }
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Destination is not configured. Artifact resolution will be performed using the configured location URL: " + location);
                }
                URL url = new URL(endPoint.getLocation());
                connection = (HttpURLConnection)url.openConnection();
            }
            if (userName != null && userName.length() > 0 && password != null && password.length > 0) {
                String auth = SAML2Utils.encodeBase64AsString((String)(String.valueOf(userName) + ':' + new String(password)));
                connection.setRequestProperty("Authorization", "Basic " + auth);
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Basic Authentication header specified in the HTTP URL connection for user: {0}", new Object[]{userName});
                }
            }
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Artifact resolve token created: {0} ", new Object[]{artifactResolve});
            }
            String SAMLMessage = artifactResolve.generate();
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Sending ArtifactResolve to Trusted Provider (name: " + issuerConfig.getName() + ", location: " + connection + ") with binding: " + SAML2Binding.SOAP_BINDING + "\nSAML2 message:\n" + artifactResolve.getXMLRepresentation());
            }
            if ((response = SOAPHTTPBinding.sendSOAPRequest((HttpURLConnection)connection, (String)SAMLMessage)) != null) {
                if (response instanceof SAML2ArtifactResponse) {
                    String topLevelStatusCode;
                    SAML2ArtifactResponse artifactResponse = (SAML2ArtifactResponse)response;
                    if (LOCATION.beInfo()) {
                        LOCATION.infoT("Received ArtifactResponse (top level status code: {0}, second level status code: {1}) from provider: {2} through binding: {3}\n SAML2 message:\n {4}", new Object[]{artifactResponse.getTopLevelStatusCode(), artifactResponse.getSecondLevelStatusCode(), issuerConfig.getName(), SAML2Binding.SOAP_BINDING.getName(), artifactResponse.getXMLRepresentation()});
                    }
                    boolean artifactResponseSignatureVerified = false;
                    if (artifactResponse.isSigned()) {
                        SAML2CommonServicesManager.getInstance().getSignatureValidator().validateSignature((SAML2SignableToken)artifactResponse, localProviderConfig, issuerConfig);
                        artifactResponseSignatureVerified = true;
                        if (signedInfo != null) {
                            signedInfo.put("ArtifactResponseSigned", "true");
                        }
                        if (LOCATION.beDebug()) {
                            LOCATION.debugT("Artifact signature successfully validated.");
                        }
                    } else if (issuerConfig.isToRequireSignedArtifactResolutionMessages().equals((Object)SignatureOption.ALWAYS)) {
                        String text = "The artifact response message is not signed, but has to be according to the configuration for trusted provider " + issuerConfig.getName() + ".";
                        if (LOCATION.beDebug()) {
                            LOCATION.debugT(text);
                        }
                        throw new SAML2Exception(text);
                    }
                    if ((topLevelStatusCode = artifactResponse.getTopLevelStatusCode()) == null) {
                        String text = "The artifact response has no top level status code set.";
                        if (LOCATION.beDebug()) {
                            LOCATION.debugT(text);
                        }
                        throw new SAML2Exception(text);
                    }
                    if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(topLevelStatusCode)) {
                        String secondLevelStatusCode = artifactResponse.getSecondLevelStatusCode();
                        String statusMessage = artifactResponse.getStatusMessage();
                        String errMsg = "Error code found in artifact response. Artifact resolution of artifact " + artifact + " failed:\nTop level status code=" + topLevelStatusCode + "\nSecond level status code=" + secondLevelStatusCode + "\nStatus message=" + statusMessage;
                        if (LOCATION.beDebug()) {
                            LOCATION.debugT(errMsg);
                        }
                        throw new SAML2Exception(errMsg);
                    }
                    SAML2ProtocolToken result = artifactResponse.extractPayloadAsProtocolToken();
                    if (result != null) {
                        result.setParentSAML2TokenSignatureVerified(artifactResponseSignatureVerified);
                        result.setParentTokenId(artifactResponse.getID());
                    }
                    return result;
                }
                String text = "The SAML2 message received from trusted provider " + issuerConfig.getName() + " is not an artifact resolve response. Its Java type is " + response.getClass().getName() + ".";
                if (LOCATION.beDebug()) {
                    LOCATION.debugT(text);
                }
                throw new SAML2Exception(text);
            }
            String text = "Did not receive an artifact resolve response from trusted provider " + issuerConfig.getName() + ".";
            if (LOCATION.beDebug()) {
                LOCATION.debugT(text);
            }
            throw new SAML2Exception(text);
        }
        catch (Exception e) {
            throw new SAML2Exception((Throwable)e);
        }
    }
}

