/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons;

import java.io.Serializable;
import java.util.List;

public class Attribute
implements Serializable {
    private static final long serialVersionUID = -205286389774749304L;
    private static final String DEFAULT_NAMESPACE = "com.sap.security.saml2";
    private String namespace = null;
    private String name = null;
    private List<String> values = null;

    public Attribute(String namespace, String name, List<String> values) {
        this.namespace = namespace != null ? namespace : DEFAULT_NAMESPACE;
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null.");
        }
        this.name = name;
        this.values = values;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getValues() {
        return this.values;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public String toString() {
        return "[Namespace: " + this.namespace + ", Name: " + this.name + ", Values: " + this.values + "]";
    }
}

