/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons;

import java.io.Serializable;
import java.util.Calendar;

public final class AuthnContext
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 166863471262539273L;
    private long timeStamp;
    private String name;
    private String alias;
    private boolean isInteractive;
    private boolean isHttps;
    private boolean isHttp;
    private boolean isCustom;

    public AuthnContext(String name) {
        this(name, null, false, false, false, false);
    }

    public AuthnContext(String name, String alias, boolean isInteractive, boolean isHttps, boolean isHttp, boolean isCustom) {
        this(Calendar.getInstance().getTimeInMillis(), name, alias, isInteractive, isHttps, isHttp, isCustom);
    }

    private AuthnContext(long timeStamp, String name, String alias, boolean isInteractive, boolean isHttps, boolean isHttp, boolean isCustom) {
        this.name = name;
        this.alias = alias;
        this.timeStamp = timeStamp;
        this.isInteractive = isInteractive;
        this.isHttps = isHttps;
        this.isHttp = isHttp;
        this.isCustom = isCustom;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isHttps() {
        return this.isHttps;
    }

    public boolean isHttp() {
        return this.isHttp;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public AuthnContext clone() {
        AuthnContext ac = new AuthnContext(this.timeStamp, this.name, this.alias, this.isInteractive, this.isHttps, this.isHttp, this.isCustom);
        return ac;
    }

    public String toString() {
        return "[Name: " + this.name + ", Alias: " + this.alias + ", TimeStamp: " + this.timeStamp + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthnContext)) {
            return false;
        }
        AuthnContext other = (AuthnContext)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        if (this.isCustom != other.isCustom) {
            return false;
        }
        if (this.isHttp != other.isHttp) {
            return false;
        }
        if (this.isHttps != other.isHttps) {
            return false;
        }
        if (this.isInteractive != other.isInteractive) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.timeStamp == other.timeStamp;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.isCustom ? 1231 : 1237);
        result = 31 * result + (this.isHttp ? 1231 : 1237);
        result = 31 * result + (this.isHttps ? 1231 : 1237);
        result = 31 * result + (this.isInteractive ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        return result;
    }
}

