/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons;

import com.sap.security.saml2.commons.AuthnContext;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class AuthnContextList
implements Iterable<AuthnContext>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8453727910758212246L;
    private static final Location LOCATION = Location.getLocation(AuthnContextList.class);
    private List<AuthnContext> contexts = Collections.synchronizedList(new ArrayList());

    public AuthnContextList() {
    }

    public AuthnContextList(AuthnContext context) {
        this.contexts.add(context);
    }

    public void add(AuthnContext context) {
        AuthnContext acToRemove = null;
        for (AuthnContext ac : this.contexts) {
            if (!ac.getName().equalsIgnoreCase(context.getName())) continue;
            acToRemove = ac;
            break;
        }
        if (acToRemove != null) {
            this.contexts.remove(acToRemove);
        }
        this.contexts.add(context);
    }

    @Override
    public Iterator<AuthnContext> iterator() {
        return this.contexts.iterator();
    }

    public boolean isEmpty() {
        return this.contexts.isEmpty();
    }

    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (AuthnContext ac : this.contexts) {
            names.add(ac.getName());
        }
        return names;
    }

    public String toString() {
        return this.contexts.toString();
    }

    public List<AuthnContext> entrySet() {
        return Collections.unmodifiableList(this.contexts);
    }

    public AuthnContextList clone() {
        AuthnContextList acl = new AuthnContextList();
        for (AuthnContext ac : this.contexts) {
            acl.add(ac.clone());
        }
        return acl;
    }

    public boolean hasAuthnContext(Long ts, boolean checkInteractive) {
        if (ts == null) {
            return false;
        }
        for (AuthnContext ctx : this.contexts) {
            if ((!checkInteractive || !ctx.isInteractive() || ctx.getTimeStamp() <= ts) && (checkInteractive || ctx.getTimeStamp() <= ts)) continue;
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Authentication context [{0}] found after timestamp [{1}].", new Object[]{ctx, ts});
            }
            return true;
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("No authentication context found after timestamp [{0}]. Authenticated contexts: [{1}]", new Object[]{ts, this.contexts});
        }
        return false;
    }

    public boolean hasAuthnContext(Long ts, AuthnContextList inputContexts) {
        if (ts == null) {
            return false;
        }
        for (AuthnContext inputContext : inputContexts) {
            for (AuthnContext authenticatedContext : this.contexts) {
                if (!authenticatedContext.isInteractive() || !authenticatedContext.getName().equalsIgnoreCase(inputContext.getName()) || authenticatedContext.getTimeStamp() <= ts) continue;
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Interactive authentication context [{0}] after timestamp [{1}]. Input contexts: [{2}]. Authenticated contexts: [{3}]", new Object[]{authenticatedContext, ts, inputContexts, this.contexts});
                }
                return true;
            }
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("No interactive authentication context found after timestamp [{0}]. Input contexts: [{1}]. Authenticated contexts: [{2}]", new Object[]{ts, inputContexts, this.contexts});
        }
        return false;
    }

    public boolean isSufficient(AuthnContext context) {
        for (AuthnContext ctx : this.contexts) {
            if (!ctx.getName().equalsIgnoreCase(context.getName())) continue;
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Authentication context [{0}] is sufficient.", new Object[]{context});
            }
            return true;
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Authentication context [{0}] is not sufficient. Authenticated contexts: [{1}]", new Object[]{context, this.contexts});
        }
        return false;
    }

    public boolean hasSufficient(AuthnContextList authnContexts) {
        for (AuthnContext ctx : authnContexts) {
            if (!this.isSufficient(ctx)) continue;
            return true;
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Authentication contexts [{0}] are not sufficient against configured authentication contexts for the application [{1}].", new Object[]{this.contexts, authnContexts});
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuthnContextList)) {
            return false;
        }
        AuthnContextList ctxList = (AuthnContextList)obj;
        return this.contexts.equals(ctxList.entrySet());
    }

    public int hashCode() {
        return this.contexts.hashCode();
    }
}

