/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons;

import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class AuthnContextsMapping {
    private static final String AUTHN_CONTEXT_SEPARATOR = ";";
    private static final Location LOCATION = Location.getLocation(AuthnContextsMapping.class);
    public static final String AUTHNCONTEXT_PASSWORD_SHORTNAME = "password";
    public static final String AUTHNCONTEXT_PASSWORDPROTECTED_SHORTNAME = "passwordprotected";
    public static final String AUTHNCONTEXT_KERBEROS_SHORTNAME = "kerberos";
    public static final String AUTHNCONTEXT_TLSCLIENT_SHORTNAME = "tlsclient";

    public static String buildAuthnContextString(List<String> authnContextNames) {
        String authnContexts = "";
        for (String context : authnContextNames) {
            if (context.equals("urn:oasis:names:tc:SAML:2.0:ac:classes:Password")) {
                authnContexts = String.valueOf(authnContexts) + "password;";
                continue;
            }
            if (context.equals("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport")) {
                authnContexts = String.valueOf(authnContexts) + "passwordprotected;";
                continue;
            }
            if (context.equals("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos")) {
                authnContexts = String.valueOf(authnContexts) + "kerberos;";
                continue;
            }
            if (!context.equals("urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient")) continue;
            authnContexts = String.valueOf(authnContexts) + "tlsclient;";
        }
        if (authnContexts.length() != 0 && authnContexts.endsWith(AUTHN_CONTEXT_SEPARATOR)) {
            authnContexts = authnContexts.substring(0, authnContexts.length() - 1);
        }
        return authnContexts;
    }

    public static List<String> parseAuthnContextString(String authnContextsString) {
        ArrayList<String> authnContexts = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(authnContextsString, AUTHN_CONTEXT_SEPARATOR);
        while (st.hasMoreTokens()) {
            String authnContextShortName = st.nextToken();
            if (AUTHNCONTEXT_PASSWORD_SHORTNAME.equalsIgnoreCase(authnContextShortName)) {
                authnContexts.add("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
                continue;
            }
            if (AUTHNCONTEXT_PASSWORDPROTECTED_SHORTNAME.equalsIgnoreCase(authnContextShortName)) {
                authnContexts.add("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
                continue;
            }
            if (AUTHNCONTEXT_KERBEROS_SHORTNAME.equalsIgnoreCase(authnContextShortName)) {
                authnContexts.add("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
                continue;
            }
            if (!AUTHNCONTEXT_TLSCLIENT_SHORTNAME.equalsIgnoreCase(authnContextShortName)) continue;
            authnContexts.add("urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient");
        }
        return authnContexts;
    }

    public static String buildAuthnContextString(SAML2LocalProvider localProviderConfig, List<String> authnContextNames) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String authnContextName : authnContextNames) {
            SAML2CfgAuthenticationContext authnContext = localProviderConfig.getAuthenticationContextByName(authnContextName);
            if (authnContext != null) {
                String authnContextAlias = authnContext.getAlias();
                if (authnContextAlias != null && authnContextAlias.length() > 0) {
                    if (i > 0) {
                        builder.append(AUTHN_CONTEXT_SEPARATOR);
                    }
                    builder.append(authnContextAlias);
                    ++i;
                    continue;
                }
                if (!LOCATION.beWarning()) continue;
                LOCATION.warningT("The authentication context configuration: {0} does not have an alias.", new Object[]{authnContext});
                continue;
            }
            if (!LOCATION.beWarning()) continue;
            LOCATION.warningT("There is not configuration for authentication context with name: {0}", new Object[]{authnContextName});
        }
        return builder.toString();
    }

    public static List<String> parseAuthnContextString(SAML2LocalProvider localProviderConfig, String authnContextsString) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(authnContextsString, AUTHN_CONTEXT_SEPARATOR);
        while (st.hasMoreTokens()) {
            String authnContextAlias = st.nextToken().trim();
            SAML2CfgAuthenticationContext authnContext = localProviderConfig.getAuthenticationContextByAlias(authnContextAlias);
            if (authnContext != null) {
                String authnContextName = authnContext.getName();
                if (authnContextName != null && authnContextName.length() > 0) {
                    result.add(authnContextName);
                    continue;
                }
                if (!LOCATION.beWarning()) continue;
                LOCATION.warningT("The authentication context configuration: {0} does not have a name.", new Object[]{authnContext});
                continue;
            }
            if (!LOCATION.beWarning()) continue;
            LOCATION.warningT("There is not configuration for authentication context with alias: {0}", new Object[]{authnContextAlias});
        }
        return result;
    }

    public String generateAuthnContextsString(String[] authnContextNames) {
        String authnContexts = "";
        String[] stringArray = authnContextNames;
        int n = authnContextNames.length;
        int n2 = 0;
        while (n2 < n) {
            String context = stringArray[n2];
            if (context.equals("urn:oasis:names:tc:SAML:2.0:ac:classes:Password")) {
                authnContexts = String.valueOf(authnContexts) + "password;";
            } else if (context.equals("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport")) {
                authnContexts = String.valueOf(authnContexts) + "passwordprotected;";
            } else if (context.equals("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos")) {
                authnContexts = String.valueOf(authnContexts) + "kerberos;";
            } else if (context.equals("urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient")) {
                authnContexts = String.valueOf(authnContexts) + "tlsclient;";
            }
            ++n2;
        }
        if (authnContexts.length() != 0 && authnContexts.endsWith(AUTHN_CONTEXT_SEPARATOR)) {
            authnContexts = authnContexts.substring(0, authnContexts.length() - 1);
        }
        return authnContexts;
    }

    public List<String> parseAuthnContextsString(String authnContextsString) {
        ArrayList<String> authnContexts = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(authnContextsString, AUTHN_CONTEXT_SEPARATOR);
        while (st.hasMoreTokens()) {
            String authnContextShortName = st.nextToken();
            if (AUTHNCONTEXT_PASSWORD_SHORTNAME.equalsIgnoreCase(authnContextShortName)) {
                authnContexts.add("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
                continue;
            }
            if (AUTHNCONTEXT_PASSWORDPROTECTED_SHORTNAME.equalsIgnoreCase(authnContextShortName)) {
                authnContexts.add("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
                continue;
            }
            if (AUTHNCONTEXT_KERBEROS_SHORTNAME.equalsIgnoreCase(authnContextShortName)) {
                authnContexts.add("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
                continue;
            }
            if (!AUTHNCONTEXT_TLSCLIENT_SHORTNAME.equalsIgnoreCase(authnContextShortName)) continue;
            authnContexts.add("urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient");
        }
        return authnContexts;
    }
}

