/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons;

import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.commons.AuditData;
import com.sap.security.saml2.commons.SAML2CommonServicesManager;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.saml2.commons.monitoring.Monitors;
import com.sap.security.saml2.lib.callbacks.SAMLGetterCallback;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2AuthRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ManageNameIDRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ManageNameIDResponse;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ResponseBase;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CommonSAML2Utils {
    private static final Location LOCATION = Location.getLocation(CommonSAML2Utils.class);
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)SAML2CommonServicesManager.getInstance().getCommonServicesInstance().getAuthenticationCategoryName());
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static void redirectToLogoutPage(HttpServletResponse response, String targetURL) throws IOException {
        String logoutPage = SAML2CommonServicesManager.getInstance().getCommonServicesInstance().getLogoutPage();
        if (targetURL != null && targetURL.length() > 0) {
            logoutPage = CommonSAML2Utils.addQueryStringParameter(SAML2CommonServicesManager.getInstance().getCommonServicesInstance().getRedirectURLParameterName(), targetURL, logoutPage);
        }
        response.sendRedirect(logoutPage);
    }

    public static String addQueryStringParameter(String name, String value, String url) {
        value = CommonSAML2Utils.safeEncodeUrl(value);
        String searchName1 = "?" + name + "=";
        String searchName2 = "&" + name + "=";
        int paramBegin = url.indexOf(searchName1);
        if (paramBegin == -1) {
            paramBegin = url.indexOf(searchName2);
        }
        if (paramBegin != -1) {
            url = CommonSAML2Utils.removeQueryStringParameter(url, name);
        }
        url = url.indexOf("?") == -1 ? String.valueOf(url) + "?" + name + "=" + value : String.valueOf(url) + "&" + name + "=" + value;
        return url;
    }

    public static String removeQueryStringParameter(String url, String parameter) {
        String searchName1 = "?" + parameter + "=";
        String searchName2 = "&" + parameter + "=";
        int paramBegin = url.indexOf(searchName1);
        if (paramBegin == -1) {
            paramBegin = url.indexOf(searchName2);
        }
        if (paramBegin != -1) {
            int paramEnd = url.indexOf("&", paramBegin + 1);
            if (paramEnd == -1) {
                url = url.substring(0, paramBegin);
            } else {
                String url1 = url.substring(0, paramBegin + 1);
                String url2 = url.substring(paramEnd + 1, url.length());
                url = String.valueOf(url1) + url2;
            }
        }
        return url;
    }

    public static String safeEncodeUrl(String url) {
        try {
            String decodedUrl = URLDecoder.decode(url, DEFAULT_ENCODING);
            if (decodedUrl.equals(url)) {
                return URLEncoder.encode(url, DEFAULT_ENCODING);
            }
            return url;
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Error encoding target url.", (Throwable)e);
            return null;
        }
    }

    public static String getProviderName(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.length() != 0) {
            int qsIndex;
            if (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            if ((qsIndex = pathInfo.indexOf("?")) != -1) {
                pathInfo = pathInfo.substring(0, qsIndex);
            }
            return pathInfo;
        }
        return null;
    }

    public static void checkIssueInstant(Date issueInstant, SAML2LocalProvider localProvider) throws SAML2Exception {
        if (issueInstant == null) {
            throw new SAML2Exception("The IssueInstant is mandatory field");
        }
        long currentTimeInMillis = System.currentTimeMillis();
        long issueInstantInMillis = issueInstant.getTime();
        int notBeforePeriodInMillis = localProvider.getIssueInstantValidityNotBeforeInMinutes() * 60 * 1000;
        int notAfterPeriodInMillis = localProvider.getIssueInstantValidityNotAfterInMinutes() * 60 * 1000;
        int clockSkewInMillis = localProvider.getClockSkewToleranceInSeconds() * 1000;
        if (issueInstantInMillis < currentTimeInMillis - (long)notBeforePeriodInMillis - (long)clockSkewInMillis) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Issue Instant is not valid yet. IssueInstant: {0}; current time: {1}; Not before period: {2}; Clock skew: {3}", new Object[]{issueInstantInMillis, currentTimeInMillis, notBeforePeriodInMillis, clockSkewInMillis});
            }
            throw new SAML2Exception("Issue Instant is not valid anymore. IssueInstant: " + issueInstant + "Curent time: " + new Date());
        }
        if (issueInstantInMillis > currentTimeInMillis + (long)notAfterPeriodInMillis + (long)clockSkewInMillis) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Issue Instant is not valid anymore. IssueInstant: {0}; current time: {1}; Not after period: {2}; Clock skew: {3}", new Object[]{issueInstantInMillis, currentTimeInMillis, notAfterPeriodInMillis, clockSkewInMillis});
            }
            throw new SAML2Exception("Issue Instant is not valid yet. IssueInstant: " + issueInstant + "Curent time: " + new Date());
        }
    }

    public static void endpointSendError(HttpServletResponse response, int responseCode, String message) {
        if (response.isCommitted()) {
            LOCATION.errorT("HTTP response is committed and error message cannot be displayed. Message: {0}", new Object[]{message});
        } else {
            try {
                response.sendError(responseCode, message);
            }
            catch (IOException e) {
                LOCATION.traceThrowableT(500, "Failed to send error message: " + message, (Throwable)e);
            }
        }
    }

    public static SAML2Binding getBindingFromAlias(String alias) {
        SAML2Binding binding = null;
        if (alias != null) {
            if (alias.equalsIgnoreCase("soap")) {
                binding = SAML2Binding.SOAP_BINDING;
            } else if (alias.equalsIgnoreCase("post")) {
                binding = SAML2Binding.HTTP_POST_BINDING;
            } else if (alias.equalsIgnoreCase("redirect")) {
                binding = SAML2Binding.HTTP_REDIRECT_BINDING;
            } else if (alias.equalsIgnoreCase("artifact")) {
                binding = SAML2Binding.HTTP_ARTIFACT_BINDING;
            } else if (alias.equalsIgnoreCase("paos")) {
                binding = SAML2Binding.PAOS_BINDING;
            } else if (alias.equals("")) {
                binding = null;
            } else {
                LOCATION.errorT("Unsupported binding provided as short name alias in request parameter. Supported values: post, redirect, soap, artifact. Current value: {0}", new Object[]{alias});
            }
        }
        return binding;
    }

    public static SAML2Principal obtainSAML2Principal() {
        SAML2Principal saml2Principal = SAML2CommonServicesManager.getInstance().getCommonServicesInstance().getSAML2Principal();
        if (saml2Principal != null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("SAML2Principal loaded: {0}", new Object[]{saml2Principal});
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("SAML2Principal not found in current client context.");
        }
        return saml2Principal;
    }

    public static String toAuditString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2Assertion assertion = auditData.getAssertion();
        if (assertion != null) {
            builder.append(assertion.isSigned() ? "signed" : "not signed");
            builder.append(" Assertion \n");
            builder.append(CommonSAML2Utils.getAssertionString(auditData));
        }
        return builder.toString();
    }

    public static String getRejectedAssertionAuditString(AuditData auditData, String reason) {
        StringBuilder builder = new StringBuilder(256);
        SAML2Assertion assertion = auditData.getAssertion();
        if (assertion != null) {
            builder.append("Rejected ");
            builder.append(assertion.isSigned() ? "signed" : "not signed");
            builder.append(" Assertion \n");
            builder.append("Reason: ").append(reason).append("\n");
            builder.append(CommonSAML2Utils.getAssertionString(auditData));
        }
        return builder.toString();
    }

    public static String getSuccessAssertionAuditString(AuditData auditData, String reason) {
        StringBuilder builder = new StringBuilder(256);
        builder.append(reason);
        SAML2Assertion assertion = auditData.getAssertion();
        if (assertion != null) {
            builder.append("\n\nConsumed ");
            builder.append(CommonSAML2Utils.toAuditString(auditData));
        }
        return builder.toString();
    }

    public static String getRejectedResponseAuditString(AuditData auditData, String reason) {
        StringBuilder builder = new StringBuilder(256);
        SAML2ResponseBase saml2ResponseBase = auditData.getSaml2ResponseBase();
        if (saml2ResponseBase != null) {
            builder.append("Rejected ");
            if (saml2ResponseBase.isSigned() || saml2ResponseBase.isSignedOnBindingLevel()) {
                builder.append("signed");
            } else {
                builder.append("not signed");
            }
            builder.append(" Response \n");
            builder.append("Reason: ").append(reason).append("\n");
            builder.append(CommonSAML2Utils.getResponseBaseString(auditData));
        }
        return builder.toString();
    }

    public static String getIssuedLogoutResponseAuditString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2ResponseBase saml2Response = auditData.getSaml2ResponseBase();
        if (saml2Response != null) {
            builder.append("Issued ");
            if (saml2Response.isSigned() || auditData.isSigned() || auditData.isSignedOnBindingLevel()) {
                builder.append("signed");
            } else {
                builder.append("not signed");
            }
            builder.append(" Logout Response \n");
            builder.append(CommonSAML2Utils.getResponseBaseString(auditData));
        }
        return builder.toString();
    }

    public static String getReceivedLogoutResponseAuditString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2ResponseBase saml2ResponseBase = auditData.getSaml2ResponseBase();
        if (saml2ResponseBase != null) {
            builder.append("Received ");
            if (saml2ResponseBase.isSigned() || saml2ResponseBase.isSignedOnBindingLevel()) {
                builder.append("signed");
            } else {
                builder.append("not signed");
            }
            builder.append(" Logout Response \n");
            builder.append(CommonSAML2Utils.getResponseBaseString(auditData));
        }
        return builder.toString();
    }

    public static String getReceivedMNIRequestAuditString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2ManageNameIDRequest mniRequest = auditData.getMNIRequest();
        if (mniRequest != null) {
            builder.append("Received ");
            if (mniRequest.isSigned() || mniRequest.isSignedOnBindingLevel()) {
                builder.append("signed");
            } else {
                builder.append("not signed");
            }
            builder.append(" ManageNameIDRequest \n");
            builder.append(CommonSAML2Utils.getMNIRequestString(auditData));
        }
        return builder.toString();
    }

    public static String getReceivedMNIResponseAuditString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2ManageNameIDResponse mniResponse = auditData.getMNIResponse();
        if (mniResponse != null) {
            builder.append("Received ");
            if (mniResponse.isSigned() || mniResponse.isSignedOnBindingLevel()) {
                builder.append("signed");
            } else {
                builder.append("not signed");
            }
            builder.append(" ManageNameIDResponse \n");
            builder.append(CommonSAML2Utils.getMNIResponseString(auditData));
        }
        return builder.toString();
    }

    public static String getIssuedMNIRequestAuditString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2ManageNameIDRequest mniRequest = auditData.getMNIRequest();
        if (mniRequest != null) {
            builder.append("Issued ");
            if (mniRequest.isSigned() || auditData.isSignedOnBindingLevel()) {
                builder.append("signed");
            } else {
                builder.append("not signed");
            }
            builder.append(" ManageNameIDRequest \n");
            builder.append(CommonSAML2Utils.getMNIRequestString(auditData));
        }
        return builder.toString();
    }

    public static String getIssuedMNIResponseAuditString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2ManageNameIDResponse mniResponse = auditData.getMNIResponse();
        if (mniResponse != null) {
            builder.append("Issued ");
            if (mniResponse.isSigned() || auditData.isSignedOnBindingLevel()) {
                builder.append("signed");
            } else {
                builder.append("not signed");
            }
            builder.append(" ManageNameIDResponse \n");
            builder.append(CommonSAML2Utils.getMNIResponseString(auditData));
        }
        return builder.toString();
    }

    public static String getIssuedLogoutRequestAuditString(AuditData auditData, String user) {
        StringBuilder builder = new StringBuilder(256);
        SAML2LogoutRequest logoutRequest = auditData.getLogoutRequest();
        if (logoutRequest != null) {
            builder.append("Issued ");
            if (logoutRequest.isSigned() || auditData.isSigned() || auditData.isSignedOnBindingLevel()) {
                builder.append("signed");
            } else {
                builder.append("not signed");
            }
            builder.append(" LogoutRequest \n");
            if (user != null) {
                builder.append("Local User: ").append(user).append("\n");
            }
            builder.append(CommonSAML2Utils.getLogoutRequestString(auditData));
        }
        return builder.toString();
    }

    public static String getAcceptedLogoutRequestAuditString(AuditData auditData, String user) {
        StringBuilder builder = new StringBuilder(256);
        SAML2LogoutRequest logoutRequest = auditData.getLogoutRequest();
        if (logoutRequest != null) {
            builder.append("Accepted ");
            if (logoutRequest.isSigned() || logoutRequest.isSignedOnBindingLevel()) {
                builder.append("signed");
            } else {
                builder.append(logoutRequest.isSigned() ? "signed" : "not signed");
            }
            builder.append(" LogoutRequest \n");
            if (user != null) {
                builder.append("Local User: ").append(user).append("\n");
            }
            builder.append(CommonSAML2Utils.getLogoutRequestString(auditData));
        }
        return builder.toString();
    }

    public static String getRejectedLogoutRequestAuditString(AuditData auditData, String reason) {
        StringBuilder builder = new StringBuilder(256);
        SAML2LogoutRequest logoutRequest = auditData.getLogoutRequest();
        if (logoutRequest != null) {
            builder.append("Rejected ");
            if (logoutRequest.isSigned() || logoutRequest.isSignedOnBindingLevel()) {
                builder.append("signed");
            } else {
                builder.append(logoutRequest.isSigned() ? "signed" : "not signed");
            }
            builder.append(" LogoutRequest \n");
            builder.append("Reason: ").append(reason).append("\n");
            builder.append(CommonSAML2Utils.getLogoutRequestString(auditData));
        }
        return builder.toString();
    }

    public static String getIssuedAuthenticationRequestString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2AuthRequest authnRequest = auditData.getSaml2AuthnRequest();
        if (authnRequest != null) {
            builder.append("Issued ");
            if (authnRequest.isSigned() || auditData.isSigned() || auditData.isSignedOnBindingLevel()) {
                builder.append("signed");
            } else {
                builder.append("not signed");
            }
            builder.append(" Authentication Request \n");
            builder.append(CommonSAML2Utils.getAuthenticationRequestString(auditData));
        }
        return builder.toString();
    }

    public static String getReceivedAuthenticationRequestString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2AuthRequest authnRequest = auditData.getSaml2AuthnRequest();
        if (authnRequest != null) {
            builder.append("Received ");
            if (authnRequest.isSigned() || authnRequest.isSignedOnBindingLevel()) {
                builder.append("signed");
            } else {
                builder.append("not signed");
            }
            builder.append(" Authentication Request \n");
            builder.append(CommonSAML2Utils.getAuthenticationRequestString(auditData));
        }
        return builder.toString();
    }

    private static String getLogoutRequestString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2LogoutRequest logoutRequest = auditData.getLogoutRequest();
        if (logoutRequest != null) {
            builder.append("  ID: ").append(logoutRequest.getID() != null ? logoutRequest.getID() : "").append("\n");
            SAML2NameID issuer = logoutRequest.getIssuer();
            if (issuer != null) {
                builder.append("  Issuer: ").append(issuer.getName() != null ? issuer.getName() : "").append("\n");
            }
            builder.append("  Issue Instant: ").append(logoutRequest.getIssueInstant() != null ? logoutRequest.getIssueInstant() : "").append("\n");
            builder.append("  NotOnOrAfter: ").append(logoutRequest.getNotOnOrAfter() != null ? logoutRequest.getNotOnOrAfter() : "").append("\n");
            builder.append("  Destination: ").append(logoutRequest.getDestination() != null ? logoutRequest.getDestination() : "").append("\n");
            builder.append(auditData.getNameID() != null ? auditData.getNameID() : "");
            builder.append("  Encrypted: ").append(auditData.isSAML2NameIDEncrypted() ? "true" : "false").append("\n");
            builder.append("  Session Index: ").append(logoutRequest.getSessionIndex() != null ? logoutRequest.getSessionIndex() : "").append("\n");
        }
        return builder.toString();
    }

    private static String getAuthenticationRequestString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2AuthRequest authnRequest = auditData.getSaml2AuthnRequest();
        if (authnRequest != null) {
            builder.append("  ID: ").append(authnRequest.getID() != null ? authnRequest.getID() : "").append("\n");
            SAML2NameID issuer = authnRequest.getIssuer();
            if (issuer != null) {
                builder.append("  Issuer: ").append(issuer.getName() != null ? issuer.getName() : "").append("\n");
            }
            builder.append("  Issue Instant: ").append(authnRequest.getIssueInstant() != null ? authnRequest.getIssueInstant() : "").append("\n");
            builder.append("  Destination: ").append(authnRequest.getDestination() != null ? authnRequest.getDestination() : "").append("\n");
            builder.append("  Force Authentication: ").append(authnRequest.isForceAuthn() ? "true" : "false").append("\n");
            builder.append("  Is Passive: ").append(authnRequest.isPassive() ? "true" : "false").append("\n");
            builder.append("  NameID Policy Format: ").append(authnRequest.getNameIDPolicyFormat() != null ? authnRequest.getNameIDPolicyFormat() : "").append("\n");
            builder.append("  NameID Policy SP Name Qualifier: ").append(authnRequest.getNameIDPolicySPNameQualifier() != null ? authnRequest.getNameIDPolicySPNameQualifier() : "").append("\n");
            builder.append("  NameID Policy Allow Create: ").append(authnRequest.isNameIDPolicyAllowCreate() ? "true" : "false").append("\n");
            builder.append("  Requested Authentication Context ClassRefs: ").append(authnRequest.getRequestedAuthnContextClassRefs() != null ? authnRequest.getRequestedAuthnContextClassRefs() : "").append("\n");
            builder.append("  Assertion Consumer Service Index: ").append(authnRequest.getAssertionConsumerServiceIndex() != null ? authnRequest.getAssertionConsumerServiceIndex() : "").append("\n");
            builder.append("  Assertion Consumer Service URL: ").append(authnRequest.getAssertionConsumerServiceURL() != null ? authnRequest.getAssertionConsumerServiceURL() : "").append("\n");
            builder.append("  Protocol Binding: ").append(authnRequest.getProtocolBinding() != null ? authnRequest.getProtocolBinding() : "").append("\n");
            builder.append("  Consent: ").append(authnRequest.getConsent() != null ? authnRequest.getConsent() : "").append("\n");
        }
        return builder.toString();
    }

    private static String getMNIRequestString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2ManageNameIDRequest mniRequest = auditData.getMNIRequest();
        if (mniRequest != null) {
            builder.append("  ID: ").append(mniRequest.getID() != null ? mniRequest.getID() : "").append("\n");
            SAML2NameID issuer = mniRequest.getIssuer();
            if (issuer != null) {
                builder.append("  Issuer: ").append(issuer.getName() != null ? issuer.getName() : "").append("\n");
            }
            builder.append("  Issue Instant: ").append(mniRequest.getIssueInstant() != null ? mniRequest.getIssueInstant() : "").append("\n");
            builder.append("  Destination: ").append(mniRequest.getDestination() != null ? mniRequest.getDestination() : "").append("\n");
            builder.append("  Is terminate: ").append(mniRequest.isTerminate() ? "true" : "false").append("\n");
            builder.append("  Consent: ").append(mniRequest.getConsent() != null ? mniRequest.getConsent() : "").append("\n");
            if (auditData.getNameID() != null) {
                builder.append(auditData.getNameID());
                builder.append("  Name ID is encrypted: ").append(mniRequest.getEncryptedNameID() != null ? "true" : "false").append("\n");
            }
            if (auditData.getNewNameID() != null) {
                builder.append(auditData.getNewNameID()).append("\n");
                builder.append("  New ID is encrypted: ").append(mniRequest.getEncryptedNewID() != null ? "true" : "false").append("\n");
            }
        }
        return builder.toString();
    }

    private static String getMNIResponseString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2ManageNameIDResponse mniResponse = auditData.getMNIResponse();
        if (mniResponse != null) {
            builder.append("  ID: ").append(mniResponse.getID() != null ? mniResponse.getID() : "").append("\n");
            SAML2NameID issuer = mniResponse.getIssuer();
            if (issuer != null) {
                builder.append("  Issuer: ").append(issuer.getName() != null ? issuer.getName() : "").append("\n");
            }
            builder.append("  Destination: ").append(mniResponse.getDestination() != null ? mniResponse.getDestination() : "").append("\n");
            builder.append("  In Response To: ").append(mniResponse.getInResponseTo() != null ? mniResponse.getInResponseTo() : "").append("\n");
            builder.append("  Issue Instant: ").append(mniResponse.getIssueInstant() != null ? mniResponse.getIssueInstant() : "").append("\n");
            builder.append("  Top Level Status Code: ").append(mniResponse.getTopLevelStatusCode() != null ? mniResponse.getTopLevelStatusCode() : "").append("\n");
            builder.append("  Second Level Status Code: ").append(mniResponse.getSecondLevelStatusCode() != null ? mniResponse.getSecondLevelStatusCode() : "").append("\n");
            builder.append("  Status Message: ").append(mniResponse.getStatusMessage() != null ? mniResponse.getStatusMessage() : "").append("\n");
            builder.append("  Consent: ").append(mniResponse.getConsent() != null ? mniResponse.getConsent() : "").append("\n");
        }
        return builder.toString();
    }

    private static String getResponseBaseString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2ResponseBase saml2ResponseBase = auditData.getSaml2ResponseBase();
        if (saml2ResponseBase != null) {
            builder.append("  ID: ").append(saml2ResponseBase.getID() != null ? saml2ResponseBase.getID() : "").append("\n");
            SAML2NameID issuer = saml2ResponseBase.getIssuer();
            if (issuer != null) {
                builder.append("  Issuer: ").append(issuer.getName() != null ? issuer.getName() : "").append("\n");
            }
            builder.append("  Destination: ").append(saml2ResponseBase.getDestination() != null ? saml2ResponseBase.getDestination() : "").append("\n");
            builder.append("  In Response To: ").append(saml2ResponseBase.getInResponseTo() != null ? saml2ResponseBase.getInResponseTo() : "").append("\n");
            builder.append("  Issue Instant: ").append(saml2ResponseBase.getIssueInstant() != null ? saml2ResponseBase.getIssueInstant() : "").append("\n");
            builder.append("  Top Level Status Code: ").append(saml2ResponseBase.getTopLevelStatusCode() != null ? saml2ResponseBase.getTopLevelStatusCode() : "").append("\n");
            builder.append("  Second Level Status Code: ").append(saml2ResponseBase.getSecondLevelStatusCode() != null ? saml2ResponseBase.getSecondLevelStatusCode() : "").append("\n");
            builder.append("  Status Message: ").append(saml2ResponseBase.getStatusMessage() != null ? saml2ResponseBase.getStatusMessage() : "").append("\n");
            builder.append("  Consent: ").append(saml2ResponseBase.getConsent() != null ? saml2ResponseBase.getConsent() : "").append("\n");
        }
        return builder.toString();
    }

    private static String getAssertionString(AuditData auditData) {
        StringBuilder builder = new StringBuilder(256);
        SAML2Assertion assertion = auditData.getAssertion();
        if (assertion != null) {
            builder.append("  ID: ").append(assertion.getID() != null ? assertion.getID() : "").append("\n");
            builder.append("  Encrypted: ").append(auditData.isAssertionEncrypted() ? "true" : "false").append("\n");
            SAML2NameID issuer = assertion.getIssuer();
            if (issuer != null) {
                builder.append("  Issuer: ").append(issuer.getName() != null ? issuer.getName() : "").append("\n");
            }
            builder.append("  Issue Instant: ").append(assertion.getIssueInstant() != null ? assertion.getIssueInstant() : "").append("\n");
            builder.append("  Condition Not Before: ").append(assertion.getConditionsNotBefore() != null ? assertion.getConditionsNotBefore() : "").append("\n");
            builder.append("  Condition NotOnOrAfter: ").append(assertion.getConditionsNotOnOrAfter() != null ? assertion.getConditionsNotOnOrAfter() : "").append("\n");
            builder.append(auditData.getNameID() != null ? auditData.getNameID() : "");
            builder.append("  Encrypted: ").append(auditData.isSAML2NameIDEncrypted() ? "true" : "false").append("\n");
            builder.append(auditData.getSubConf() != null ? auditData.getSubConf() : "");
            builder.append(auditData.getAuthnStatement() != null ? auditData.getAuthnStatement() : "");
            builder.append(auditData.getAttrValues() != null ? auditData.getAttrValues() : "");
        }
        return builder.toString();
    }

    public static int getPortFromUrl(URL url) {
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        return port;
    }

    public static Category getAuthenticationCategory() {
        return CATEGORY;
    }

    public static void registerMonitor(String monitorName, boolean isError, long respTime, HttpServletRequest request) {
        String monitorAttribute = (String)request.getAttribute("SAML2PMonitoring");
        if (isError || "errorCase".equals(monitorAttribute)) {
            Monitors.getInstance().addReading(monitorName.concat(" ERROR"), respTime);
        } else if (!"skipCurrentRequest".equals(monitorAttribute)) {
            Monitors.getInstance().addReading(monitorName, respTime);
        }
    }

    public static boolean shouldIssueTokensToBackendSystems(String username) {
        return SAML2CommonServicesManager.getInstance().getCommonServicesInstance().shouldIssueTokensToBackendSystems(username);
    }

    public static boolean checkSalt(CallbackHandler callbackHandler) {
        return CommonSAML2Utils.checkSalt(callbackHandler, null);
    }

    public static boolean checkSalt(HttpServletRequest request) {
        return CommonSAML2Utils.checkSalt(null, request);
    }

    private static boolean checkSalt(CallbackHandler callbackHandler, HttpServletRequest request) {
        Object saltCheck = null;
        try {
            saltCheck = callbackHandler != null ? CommonSAML2Utils.getRequestAttribute(callbackHandler, "com.sap.engine.security.authentication.salt_check") : request.getAttribute("com.sap.engine.security.authentication.salt_check");
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Count not obtain salt check result.", (Throwable)e);
            return true;
        }
        if (saltCheck instanceof Boolean) {
            boolean checkResult = (Boolean)saltCheck;
            if (checkResult) {
                LOCATION.debugT("Salt check successful.");
                return true;
            }
            LOCATION.debugT("Salt check failed.");
            return false;
        }
        LOCATION.debugT("Security interface component version does not support salt checking.");
        return true;
    }

    private static Object getRequestAttribute(CallbackHandler callbackHandler, String requestAttributeName) throws IOException, UnsupportedCallbackException {
        SAMLGetterCallback sgc = new SAMLGetterCallback();
        sgc.setType((byte)13);
        sgc.setName(requestAttributeName);
        callbackHandler.handle(new Callback[]{sgc});
        Object object = sgc.getValue();
        return object;
    }
}

