/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons;

import com.sap.security.saml2.commons.interfaces.services.ConsumedAssertionService;
import com.sap.security.saml2.commons.interfaces.services.ConsumedAssertionStorage;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.exceptions.SAML2AlreadyConsumedException;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import java.util.Date;

public class ConsumedAssertionServiceImpl
implements ConsumedAssertionService {
    private ConsumedAssertionStorage assertionStorage;

    ConsumedAssertionServiceImpl(ConsumedAssertionStorage assertionStorage) {
        if (assertionStorage == null) {
            throw new IllegalArgumentException("Storage for consumed assertions cannot be null");
        }
        this.assertionStorage = assertionStorage;
    }

    @Override
    public boolean isAlreadyConsumed(SAML2Assertion saml2Assertion) throws SAML2Exception {
        return this.assertionStorage.isAlreadyConsumed(saml2Assertion.getIssuer().getName(), saml2Assertion.getID());
    }

    @Override
    public void consume(SAML2Assertion assertion, Date subjectConfirmationNotAfterWithClockSkew) throws SAML2AlreadyConsumedException, SAML2Exception {
        this.assertionStorage.consume(assertion.getIssuer().getName(), assertion.getID(), subjectConfirmationNotAfterWithClockSkew);
    }
}

