/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons;

import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedProvider;
import com.sap.security.saml2.commons.mni.MNIStatusContext;
import com.sap.security.saml2.commons.mni.ReferrerUrlCookie;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ManageNameIDRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ManageNameIDResponse;
import com.sap.tc.logging.Location;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MNIStatusUtils {
    private static final Location LOCATION = Location.getLocation(MNIStatusUtils.class);

    public static void forwardToStatusPage(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, SAML2ManageNameIDResponse mniResponse, SAML2LocalProvider localProvider, SAML2TrustedProvider trustedProvider, String relayState) {
        ReferrerUrlCookie cookie = null;
        try {
            cookie = ReferrerUrlCookie.getCookie(request, relayState);
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not read referrer cookie.", (Throwable)e);
        }
        String referrerUrl = null;
        boolean isTerminate = false;
        if (cookie != null) {
            referrerUrl = cookie.getReferrerUrl();
            isTerminate = cookie.isTerminate();
            cookie.removeCookie(response);
        }
        MNIStatusUtils.forwardToStatusPage(servletContext, request, response, mniResponse, localProvider, trustedProvider, referrerUrl, isTerminate);
    }

    public static void forwardToStatusPage(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, SAML2ManageNameIDResponse mniResponse, SAML2LocalProvider localProvider, SAML2TrustedProvider trustedProvider, String referrerUrl, boolean isTerminate) {
        MNIStatusContext context = new MNIStatusContext();
        if (mniResponse != null) {
            context.setTopLevelCode(mniResponse.getTopLevelStatusCode());
            context.setSecondLevelCode(mniResponse.getSecondLevelStatusCode());
            context.setStatusMessage(mniResponse.getStatusMessage());
        } else {
            LOCATION.debugT("forwardToStatusPage: mniResponse is null");
        }
        if (localProvider != null) {
            context.setLocalProvider(localProvider.getName());
        } else {
            LOCATION.debugT("forwardToStatusPage: localProvider is null");
        }
        if (trustedProvider != null) {
            context.setTrustedProvider(trustedProvider.getName());
        } else {
            LOCATION.debugT("forwardToStatusPage: trustedProvider is null");
        }
        context.setReferrerUrl(referrerUrl);
        context.setTerminate(isTerminate);
        MNIStatusUtils.forwardToStatusPage(servletContext, request, response, context);
    }

    public static void forwardToStatusPage(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, SAML2LocalProvider localProvider, SAML2TrustedProvider trustedProvider, String errorMessage, String referrerUrl, boolean isTerminate) {
        MNIStatusContext context = new MNIStatusContext();
        context.setTopLevelCode("urn:oasis:names:tc:SAML:2.0:status:Requester");
        context.setStatusMessage(errorMessage);
        if (localProvider != null) {
            context.setLocalProvider(localProvider.getName());
        } else {
            LOCATION.debugT("forwardToStatusPage: localProvider is null");
        }
        if (trustedProvider != null) {
            context.setTrustedProvider(trustedProvider.getName());
        } else {
            LOCATION.debugT("forwardToStatusPage: trustedProvider is null");
        }
        context.setReferrerUrl(referrerUrl);
        context.setTerminate(isTerminate);
        MNIStatusUtils.forwardToStatusPage(servletContext, request, response, context);
    }

    private static void forwardToStatusPage(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, MNIStatusContext context) {
        if (response.isCommitted()) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("The response has already been committed. Forward to status page not possible.");
            }
            return;
        }
        request.setAttribute("mnistatus", (Object)context);
        try {
            servletContext.getContext("/saml2/mnistatus").getRequestDispatcher("/status").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not forward to status page.", (Throwable)e);
        }
    }

    public static String createReferrerCookie(HttpServletRequest request, HttpServletResponse response, SAML2ManageNameIDRequest mniRequest, boolean isTerminate) {
        ReferrerUrlCookie cookie = new ReferrerUrlCookie(request.getContextPath(), request.isSecure());
        String referrerHeader = request.getHeader("Referer");
        if (referrerHeader == null) {
            LOCATION.infoT("Referer header is empty.");
        } else {
            try {
                URL referrer = new URL(request.getHeader("Referer"));
                if (referrer != null) {
                    if (request.getLocalName().equalsIgnoreCase(referrer.getHost())) {
                        cookie.setReferrerUrl(referrer.getPath());
                    } else {
                        LOCATION.warningT("The referrer [{0}] is not a local application. It will be ignored.", new Object[]{referrer.toString()});
                    }
                }
            }
            catch (MalformedURLException e) {
                LOCATION.traceThrowableT(500, "Referrer header [{0}] does not contain a valid URL.", new Object[]{referrerHeader}, (Throwable)e);
            }
        }
        cookie.setTerminate(isTerminate);
        String relayState = "";
        try {
            relayState = cookie.addCookie(response, mniRequest.getID());
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not create referrer url cookie.", (Throwable)e);
        }
        return relayState;
    }
}

