/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons;

import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.commons.ArtifactServiceImpl;
import com.sap.security.saml2.commons.ConsumedAssertionServiceImpl;
import com.sap.security.saml2.commons.SAML2SignatureValidatorImpl;
import com.sap.security.saml2.commons.interfaces.services.ArtifactService;
import com.sap.security.saml2.commons.interfaces.services.ArtifactStorage;
import com.sap.security.saml2.commons.interfaces.services.CommonServices;
import com.sap.security.saml2.commons.interfaces.services.ConsumedAssertionService;
import com.sap.security.saml2.commons.interfaces.services.ConsumedAssertionStorage;
import com.sap.security.saml2.commons.interfaces.services.EndpointSecurityManager;
import com.sap.security.saml2.commons.interfaces.services.SAML2SignatureValidator;
import com.sap.security.saml2.commons.interfaces.services.SSO2Service;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ServicesManagerBase;
import com.sap.security.saml2.lib.common.exceptions.SAML2ServiceInstantiationException;
import java.util.HashMap;
import java.util.Map;

public final class SAML2CommonServicesManager
extends SAML2ServicesManagerBase {
    private static final String SSO2_NW_ADAPTER = "com.sap.security.saml2.commons.nwadapters.SSO2ServiceNWAdapter";
    private static final String SSO2_LJS_ADAPTER = "com.sap.security.saml2.commons.ljsadapters.SSO2ServiceLJSAdapter";
    private static final String ENDPOINT_SECURITY_MANAGER_NW_ADAPTER = "com.sap.security.saml2.commons.nwadapters.EndpointSecurityManagerNWAdapter";
    private static final String ENDPOINT_SECURITY_MANAGER_LJS_ADAPTER = "com.sap.security.saml2.commons.ljsadapters.EndpointSecurityManagerLJSAdapter";
    private static final String ARTIFACT_STORAGE_NW_ADAPTER = "com.sap.security.saml2.commons.nwadapters.ArtifactStorageNWAdapter";
    private static final String ARTIFACT_STORAGE_LJS_ADAPTER = "com.sap.security.saml2.commons.ljsadapters.ArtifactStorageLJSAdapter";
    private static final String ASSERTION_STORAGE_NW_ADAPTER = "com.sap.security.saml2.commons.nwadapters.ConsumedAssertionStorageNWAdapter";
    private static final String ASSERTION_STORAGE_LJS_ADAPTER = "com.sap.security.saml2.commons.ljsadapters.ConsumedAssertionStorageLJSAdapter";
    private static final String COMMON_SERVICES_NW_ADAPTER = "com.sap.security.saml2.commons.nwadapters.CommonServicesNWAdapter";
    private static final String COMMON_SERVICES_LJS_ADAPTER = "com.sap.security.saml2.commons.ljsadapters.CommonServicesLJSAdapter";
    private static final SAML2SignatureValidator signatureValidator = new SAML2SignatureValidatorImpl();
    private final Map<Class, Object> adapterInstances = new HashMap<Class, Object>();
    private static final SAML2CommonServicesManager INSTANCE = new SAML2CommonServicesManager();
    private ArtifactStorage artifactStorage;
    private ConsumedAssertionStorage consumedAssertionStorage;
    private ArtifactService artifactService;
    private ConsumedAssertionService assertionService;

    public static SAML2CommonServicesManager getInstance() {
        return INSTANCE;
    }

    private SAML2CommonServicesManager() {
    }

    void destroy() {
        if (this.artifactStorage != null) {
            this.artifactStorage.destroy();
        }
        if (this.consumedAssertionStorage != null) {
            this.consumedAssertionStorage.destroy();
        }
    }

    protected Object instantiateClass(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Class.forName(className).newInstance();
    }

    protected Map<Class, Object> getAdapterInstances() {
        return this.adapterInstances;
    }

    public SSO2Service getSSO2ServiceInstance() throws SAML2ServiceInstantiationException {
        return (SSO2Service)this.instantiateService(SSO2Service.class, new String[]{SSO2_NW_ADAPTER, SSO2_LJS_ADAPTER});
    }

    public EndpointSecurityManager getEndpointSecurityManagerInstance() throws SAML2ServiceInstantiationException {
        return (EndpointSecurityManager)this.instantiateService(EndpointSecurityManager.class, new String[]{ENDPOINT_SECURITY_MANAGER_NW_ADAPTER, ENDPOINT_SECURITY_MANAGER_LJS_ADAPTER});
    }

    private ArtifactStorage getArtifactStorageInstance() throws SAML2ServiceInstantiationException {
        return (ArtifactStorage)this.instantiateService(ArtifactStorage.class, new String[]{ARTIFACT_STORAGE_NW_ADAPTER, ARTIFACT_STORAGE_LJS_ADAPTER});
    }

    private ConsumedAssertionStorage getConsumedAssertionStorageInstance() throws SAML2ServiceInstantiationException {
        return (ConsumedAssertionStorage)this.instantiateService(ConsumedAssertionStorage.class, new String[]{ASSERTION_STORAGE_NW_ADAPTER, ASSERTION_STORAGE_LJS_ADAPTER});
    }

    public CommonServices getCommonServicesInstance() throws SAML2ServiceInstantiationException {
        return (CommonServices)this.instantiateService(CommonServices.class, new String[]{COMMON_SERVICES_NW_ADAPTER, COMMON_SERVICES_LJS_ADAPTER});
    }

    public void registerSSO2Service(SSO2Service adapterInstance) throws SAML2Exception {
        this.registerServiceAdapter(SSO2Service.class, adapterInstance);
    }

    public void registerEndpointSecurityManager(EndpointSecurityManager adapterInstance) throws SAML2Exception {
        this.registerServiceAdapter(EndpointSecurityManager.class, adapterInstance);
    }

    public void registerArtifactStorage(ArtifactStorage adapterInstance) throws SAML2Exception {
        this.registerServiceAdapter(ArtifactStorage.class, adapterInstance);
    }

    public void registerConsumedAssertionStorage(ConsumedAssertionStorage adapterInstance) throws SAML2Exception {
        this.registerServiceAdapter(ConsumedAssertionStorage.class, adapterInstance);
    }

    public void registerCommonServices(CommonServices adapterInstance) throws SAML2Exception {
        this.registerServiceAdapter(CommonServices.class, adapterInstance);
    }

    public void unregisterSSO2Service(SSO2Service adapterInstance) {
        this.unregisterServiceAdapter(SSO2Service.class, adapterInstance);
    }

    public void unregisterEndpointSecurityManager(EndpointSecurityManager adapterInstance) {
        this.unregisterServiceAdapter(EndpointSecurityManager.class, adapterInstance);
    }

    public void unregisterArtifactStorage(ArtifactStorage adapterInstance) {
        this.unregisterServiceAdapter(ArtifactStorage.class, adapterInstance);
    }

    public void unregisterConsumedAssertionStorage(ConsumedAssertionStorage adapterInstance) {
        this.unregisterServiceAdapter(ConsumedAssertionStorage.class, adapterInstance);
    }

    public void unregisterCommonServices(CommonServices adapterInstance) {
        this.unregisterServiceAdapter(CommonServices.class, adapterInstance);
    }

    public synchronized ArtifactService getArtifactServiceInstance() {
        if (this.artifactService == null) {
            this.artifactStorage = this.getArtifactStorageInstance();
            try {
                this.artifactStorage.init();
            }
            catch (SAML2ConfigurationException e) {
                throw new SAML2ServiceInstantiationException("Could not initialize artifact storage", (Throwable)e);
            }
            catch (SAML2Exception e) {
                throw new SAML2ServiceInstantiationException("Could not initialize artifact storage", (Throwable)e);
            }
            this.artifactService = new ArtifactServiceImpl(this.artifactStorage);
        }
        return this.artifactService;
    }

    public synchronized ConsumedAssertionService getConsumedAssertionService() {
        if (this.assertionService == null) {
            this.consumedAssertionStorage = this.getConsumedAssertionStorageInstance();
            try {
                this.consumedAssertionStorage.init();
            }
            catch (SAML2ConfigurationException e) {
                throw new SAML2ServiceInstantiationException("Could not initialize consumed assertion storage", (Throwable)e);
            }
            catch (SAML2Exception e) {
                throw new SAML2ServiceInstantiationException("Could not initialize consumed assertion storage", (Throwable)e);
            }
            this.assertionService = new ConsumedAssertionServiceImpl(this.consumedAssertionStorage);
        }
        return this.assertionService;
    }

    public SAML2SignatureValidator getSignatureValidator() {
        return signatureValidator;
    }
}

