/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons;

import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2IDPEntry;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2IDPList;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Scoping;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2AuthRequest;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class SAML2LMProxyingData {
    private static final Location LOCATION = Location.getLocation(SAML2LMProxyingData.class);
    private static final String KEY_PROXYING = "proxying";
    private static final String KEY_PROVIDER = "provider";
    private static final String KEY_REQUEST_ID = "original_request_id";
    private static final String KEY_REQUEST_REQUESTER_IDS = "original_request_requester_ids";
    private static final String KEY_REQUEST_FORCE_AUTHN = "original_request_force_authn";
    private static final String KEY_REQUEST_IS_PASSIVE = "original_request_is_passive";
    private static final String KEY_REQUESTED_AUTHN_CONTEXTS = "original_request_requested_authn_contexts";
    private static final String KEY_REQUEST_PROXY_COUNT = "original_request_proxy_count";
    private static final String KEY_REQUEST_IDP_LIST_SIZE = "original_request_idp_list_size";
    private static final String KEY_REQUEST_IDP_LIST_GETCOMPLETE = "original_request_idp_list_getcomplete";
    private static final String KEY_REQUEST_IDP_LIST_PROVIDER_ID = "original_request_idp_list_providerid";
    private static final String KEY_REQUEST_IDP_LIST_NAME = "original_request_idp_list_name";
    private static final String KEY_REQUEST_IDP_LIST_LOCATION = "original_request_idp_list_location";
    private boolean isProxying;
    private String provider;
    private SAML2AuthRequest authnRequest;
    private String originalRequestID;
    private SAML2Scoping originalRequestScoping;
    private boolean originalRequestIsPassive;
    private boolean originalRequestForceAuthn;
    private List<String> originalRequestRequestedAuthnContexts;

    public SAML2LMProxyingData(String provider, SAML2AuthRequest originalAuthnRequest) {
        this.isProxying = true;
        this.provider = provider;
        this.authnRequest = originalAuthnRequest;
    }

    public SAML2LMProxyingData(Map<String, String> saml2LMOptions) {
        this.isProxying = Boolean.parseBoolean(saml2LMOptions.get(KEY_PROXYING));
        if (!this.isProxying) {
            return;
        }
        this.provider = saml2LMOptions.get(KEY_PROVIDER);
        this.originalRequestID = saml2LMOptions.get(KEY_REQUEST_ID);
        this.originalRequestScoping = this.parseScoping(saml2LMOptions);
        this.originalRequestIsPassive = Boolean.parseBoolean(saml2LMOptions.get(KEY_REQUEST_IS_PASSIVE));
        this.originalRequestForceAuthn = Boolean.parseBoolean(saml2LMOptions.get(KEY_REQUEST_FORCE_AUTHN));
        this.originalRequestRequestedAuthnContexts = this.convertLMOptionValueToList(saml2LMOptions.get(KEY_REQUESTED_AUTHN_CONTEXTS));
    }

    private SAML2Scoping parseScoping(Map<String, String> saml2LMOptions) {
        Integer proxyCount;
        List<String> originalRequestRequesterIDs;
        SAML2IDPList originalRequestIDPList;
        block13: {
            originalRequestIDPList = null;
            String idpListSizeOption = saml2LMOptions.get(KEY_REQUEST_IDP_LIST_SIZE);
            if (idpListSizeOption != null && idpListSizeOption.length() > 0) {
                ArrayList<SAML2IDPEntry> idpEntries = new ArrayList<SAML2IDPEntry>();
                int idpListSize = 0;
                try {
                    idpListSize = Integer.parseInt(idpListSizeOption);
                }
                catch (NumberFormatException e) {
                    LOCATION.warningT("Could not parse IdP List size from value: [{0}]. Details: [{1}]", new Object[]{idpListSizeOption, e.getMessage()});
                }
                int i = 1;
                while (i < idpListSize + 1) {
                    block12: {
                        String providerId = saml2LMOptions.get(KEY_REQUEST_IDP_LIST_PROVIDER_ID + i);
                        if (providerId != null && providerId.length() > 0) {
                            try {
                                SAML2IDPEntry idpEntry = SAML2DataFactory.getInstance().createSAML2IDPEntry(providerId);
                                idpEntry.setName(saml2LMOptions.get(KEY_REQUEST_IDP_LIST_NAME + i));
                                idpEntry.setLocation(saml2LMOptions.get(KEY_REQUEST_IDP_LIST_LOCATION + i));
                                idpEntries.add(idpEntry);
                            }
                            catch (SAML2Exception e) {
                                if (!LOCATION.beWarning()) break block12;
                                LOCATION.warningT("Could not create SAML2 IdP entry for providerId: [{0}]. Reason: [{1}]", new Object[]{providerId, e.getMessage()});
                            }
                        }
                    }
                    ++i;
                }
                if (!idpEntries.isEmpty()) {
                    originalRequestIDPList = SAML2DataFactory.getInstance().createSAML2IDPList();
                    originalRequestIDPList.setIdPEntries(idpEntries);
                }
            }
            originalRequestRequesterIDs = this.convertLMOptionValueToList(saml2LMOptions.get(KEY_REQUEST_REQUESTER_IDS));
            String proxyCountValue = saml2LMOptions.get(KEY_REQUEST_PROXY_COUNT);
            proxyCount = null;
            if (proxyCountValue != null && proxyCountValue.length() > 0) {
                try {
                    proxyCount = Integer.parseInt(proxyCountValue);
                }
                catch (NumberFormatException e) {
                    if (!LOCATION.beWarning()) break block13;
                    LOCATION.warningT("Could not parse ProxyCount from value: [{0}]. Details: [{1}]", new Object[]{proxyCountValue, e.getMessage()});
                }
            }
        }
        if (originalRequestIDPList != null || proxyCount != null || originalRequestRequesterIDs != null && !originalRequestRequesterIDs.isEmpty()) {
            SAML2Scoping scoping = SAML2DataFactory.getInstance().createSAML2Scoping();
            scoping.setIDPList(originalRequestIDPList);
            scoping.setRequesterIDs(originalRequestRequesterIDs);
            scoping.setProxyCount(proxyCount);
            return scoping;
        }
        return null;
    }

    public Map<String, String> convertToLoginModuleOptions() {
        List requestedAuthnContexts;
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.provider != null) {
            result.put(KEY_PROVIDER, this.provider);
        }
        result.put(KEY_PROXYING, String.valueOf(this.isProxying));
        result.put(KEY_REQUEST_ID, this.authnRequest.getID());
        SAML2Scoping scoping = this.authnRequest.getScoping();
        if (scoping != null) {
            SAML2IDPList idpList;
            List requesterIDs;
            Integer originalProxyCount = scoping.getProxyCount();
            if (originalProxyCount != null) {
                result.put(KEY_REQUEST_PROXY_COUNT, originalProxyCount.toString());
            }
            if ((requesterIDs = scoping.getRequesterIDs()) != null && !requesterIDs.isEmpty()) {
                String lmOptionValue = this.convertListToLMOptionValue(requesterIDs);
                result.put(KEY_REQUEST_REQUESTER_IDS, lmOptionValue);
            }
            if ((idpList = scoping.getIDPList()) != null) {
                List idpEntries;
                String getComplete = idpList.getGetComplete();
                if (getComplete != null) {
                    result.put(KEY_REQUEST_IDP_LIST_GETCOMPLETE, getComplete);
                }
                if ((idpEntries = idpList.getIdPEntries()) != null) {
                    int counter = 0;
                    for (SAML2IDPEntry entry : idpEntries) {
                        String location;
                        String name;
                        ++counter;
                        String providerId = entry.getProviderID();
                        if (providerId != null) {
                            result.put(KEY_REQUEST_IDP_LIST_PROVIDER_ID + counter, providerId);
                        }
                        if ((name = entry.getName()) != null) {
                            result.put(KEY_REQUEST_IDP_LIST_NAME + counter, name);
                        }
                        if ((location = entry.getLocation()) == null) continue;
                        result.put(KEY_REQUEST_IDP_LIST_LOCATION + counter, location);
                    }
                    result.put(KEY_REQUEST_IDP_LIST_SIZE, String.valueOf(counter));
                }
            }
        }
        if ((requestedAuthnContexts = this.authnRequest.getRequestedAuthnContextClassRefs()) != null && !requestedAuthnContexts.isEmpty()) {
            String lmOptionValue = this.convertListToLMOptionValue(requestedAuthnContexts);
            result.put(KEY_REQUESTED_AUTHN_CONTEXTS, lmOptionValue);
        }
        result.put(KEY_REQUEST_IS_PASSIVE, String.valueOf(this.authnRequest.isPassive()));
        result.put(KEY_REQUEST_FORCE_AUTHN, String.valueOf(this.authnRequest.isForceAuthn()));
        return result;
    }

    private String convertListToLMOptionValue(List<String> list) {
        if (list == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String str : list) {
            if (result.length() > 0) {
                result.append(';');
            }
            result.append(str);
        }
        return result.toString();
    }

    private List<String> convertLMOptionValueToList(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() < 1) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(value, ";");
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken().trim();
            if (element == null || element.length() <= 0) continue;
            result.add(element);
        }
        return result;
    }

    public boolean isProxying() {
        return this.isProxying;
    }

    public String getProvider() {
        return this.provider;
    }

    public List<String> getOriginalRequestRequestedAuthnContexts() {
        return this.originalRequestRequestedAuthnContexts;
    }

    public String getOriginalRequestID() {
        return this.originalRequestID;
    }

    public SAML2Scoping getOriginalRequestScoping() {
        return this.originalRequestScoping;
    }

    public boolean isOriginalRequestIsPassive() {
        return this.originalRequestIsPassive;
    }

    public boolean isOriginalRequestForceAuthn() {
        return this.originalRequestForceAuthn;
    }
}

