/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons;

import com.sap.engine.lib.security.Principal;
import com.sap.security.api.logon.NonDuplicable;
import com.sap.security.saml2.commons.Attribute;
import com.sap.security.saml2.commons.AuthnContext;
import com.sap.security.saml2.commons.AuthnContextList;
import com.sap.security.saml2.commons.IdPProxyContext;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SAML2Principal
extends Principal
implements Serializable,
NonDuplicable {
    private static final long serialVersionUID = -509230275440284203L;
    public static final String AUTH_METHOD_SAML2 = "SAML2";
    private String nameId;
    private String nameIdFormat;
    private String nameIdSPNameQualifier;
    private String nameIdNameQualifier;
    private String spProvidedId;
    private String idpName;
    private String spName;
    private List<String> sessionIndexes;
    private AuthnContextList authnContexts;
    private AuthnContext lastAuthnContext;
    private IdPProxyContext idpProxyContext;
    private boolean isMNITerminated;
    private int hashCode;
    private boolean isAssertionUnsigned;
    private Certificate saml2IdpCert;
    private Set<Attribute> attributes;

    @Deprecated
    public SAML2Principal(String name, String idpName, String nameId, String nameIdFormat, String sessionIndex, AuthnContext authnContext) {
        super(name);
        this.idpName = idpName;
        this.nameId = nameId;
        this.nameIdFormat = nameIdFormat;
        this.sessionIndexes = new ArrayList<String>();
        if (sessionIndex != null) {
            this.sessionIndexes.add(sessionIndex);
        }
        this.authnContexts = new AuthnContextList(authnContext);
        this.lastAuthnContext = authnContext;
        this.setAuthenticationMethod(AUTH_METHOD_SAML2);
        this.computeHashCode();
    }

    @Deprecated
    public SAML2Principal(String name, String idpName, String spName, String nameId, String nameIdFormat, String sessionIndex, AuthnContext authnContext) {
        super(name);
        this.idpName = idpName;
        this.spName = spName;
        this.nameId = nameId;
        this.nameIdFormat = nameIdFormat;
        this.sessionIndexes = new ArrayList<String>();
        if (sessionIndex != null) {
            this.sessionIndexes.add(sessionIndex);
        }
        this.authnContexts = new AuthnContextList(authnContext);
        this.lastAuthnContext = authnContext;
        this.setAuthenticationMethod(AUTH_METHOD_SAML2);
        this.computeHashCode();
    }

    @Deprecated
    public SAML2Principal(String name, String idpName, String spName, String nameId, String nameIdFormat, String nameIdSPNameQualifier, String nameIdNameQualifier, String sessionIndex, AuthnContext authnContext) {
        super(name);
        this.idpName = idpName;
        this.spName = spName;
        this.nameId = nameId;
        this.nameIdFormat = nameIdFormat;
        this.nameIdSPNameQualifier = nameIdSPNameQualifier;
        this.nameIdNameQualifier = nameIdNameQualifier;
        this.sessionIndexes = new ArrayList<String>();
        if (sessionIndex != null) {
            this.sessionIndexes.add(sessionIndex);
        }
        this.authnContexts = new AuthnContextList(authnContext);
        this.lastAuthnContext = authnContext;
        this.setAuthenticationMethod(AUTH_METHOD_SAML2);
        this.computeHashCode();
    }

    @Deprecated
    public SAML2Principal(SAML2Principal principal, String nameId) {
        super(principal.getName());
        this.idpName = principal.getIdPName();
        this.spName = principal.getSPName();
        this.nameId = nameId;
        this.nameIdFormat = principal.getNameIdFormat();
        this.nameIdSPNameQualifier = principal.getNameIdSPNameQualifier();
        this.nameIdNameQualifier = principal.getNameIdNameQualifier();
        this.sessionIndexes = principal.getSessionIndexes();
        this.authnContexts = principal.getAuthnContexts().clone();
        Iterator<AuthnContext> iter = this.authnContexts.iterator();
        String lastAuthnContext = principal.getLastAuthnContext();
        while (iter.hasNext()) {
            AuthnContext authnContext = iter.next();
            if (authnContext.getName() == null || !authnContext.getName().equals(lastAuthnContext)) continue;
            this.lastAuthnContext = authnContext;
            break;
        }
        this.setAuthenticationMethod(AUTH_METHOD_SAML2);
        this.computeHashCode();
    }

    @Deprecated
    public SAML2Principal(String name, String idpName, String spName, String nameId, String nameIdFormat, String nameIdSPNameQualifier, String nameIdNameQualifier, String sessionIndex, AuthnContext authnContext, IdPProxyContext proxyContext) {
        super(name);
        this.idpName = idpName;
        this.spName = spName;
        this.nameId = nameId;
        this.nameIdFormat = nameIdFormat;
        this.nameIdSPNameQualifier = nameIdSPNameQualifier;
        this.nameIdNameQualifier = nameIdNameQualifier;
        this.sessionIndexes = new ArrayList<String>();
        if (sessionIndex != null) {
            this.sessionIndexes.add(sessionIndex);
        }
        this.authnContexts = new AuthnContextList(authnContext);
        this.lastAuthnContext = authnContext;
        this.idpProxyContext = proxyContext;
        this.setAuthenticationMethod(AUTH_METHOD_SAML2);
        this.computeHashCode();
    }

    public SAML2Principal(String name, String idpName, String spName, String nameId, String nameIdFormat, String spProvidedId, String nameIdSPNameQualifier, String nameIdNameQualifier, String sessionIndex, AuthnContext authnContext, IdPProxyContext proxyContext, boolean isMNITerminated) {
        super(name);
        this.idpName = idpName;
        this.spName = spName;
        this.nameId = nameId;
        this.nameIdFormat = nameIdFormat;
        this.spProvidedId = spProvidedId;
        this.nameIdSPNameQualifier = nameIdSPNameQualifier;
        this.nameIdNameQualifier = nameIdNameQualifier;
        this.sessionIndexes = new ArrayList<String>();
        if (sessionIndex != null) {
            this.sessionIndexes.add(sessionIndex);
        }
        this.authnContexts = new AuthnContextList(authnContext);
        this.lastAuthnContext = authnContext;
        this.idpProxyContext = proxyContext;
        this.isMNITerminated = isMNITerminated;
        this.setAuthenticationMethod(AUTH_METHOD_SAML2);
        this.computeHashCode();
    }

    public SAML2Principal(String name, String idpName, String nameId, String nameIdFormat, AuthnContext authnContext) {
        super(name);
        this.idpName = idpName;
        this.nameId = nameId;
        this.nameIdFormat = nameIdFormat;
        this.sessionIndexes = new ArrayList<String>();
        this.authnContexts = new AuthnContextList(authnContext);
        this.lastAuthnContext = authnContext;
        this.setAuthenticationMethod(AUTH_METHOD_SAML2);
        this.computeHashCode();
    }

    public SAML2Principal(SAML2Principal principal) {
        super(principal.getName());
        this.idpName = principal.getIdPName();
        this.spName = principal.getSPName();
        this.nameId = principal.getNameId();
        this.nameIdFormat = principal.getNameIdFormat();
        this.spProvidedId = principal.getSPProvidedID();
        this.nameIdSPNameQualifier = principal.getNameIdSPNameQualifier();
        this.nameIdNameQualifier = principal.getNameIdNameQualifier();
        this.sessionIndexes = principal.getSessionIndexes();
        this.authnContexts = principal.getAuthnContexts().clone();
        String lastAuthnContext = principal.getLastAuthnContext();
        if (lastAuthnContext != null) {
            for (AuthnContext authnContext : this.authnContexts) {
                if (!lastAuthnContext.equals(authnContext.getName())) continue;
                this.lastAuthnContext = authnContext;
                break;
            }
        }
        this.idpProxyContext = principal.getIdPProxyContext();
        this.isMNITerminated = principal.isMNITerminated();
        this.attributes = principal.getAttributes();
        this.setAuthenticationMethod(AUTH_METHOD_SAML2);
        this.computeHashCode();
    }

    public SAML2Principal(SAML2Principal principal, String name, String nameId) {
        super(name);
        this.idpName = principal.getIdPName();
        this.spName = principal.getSPName();
        this.nameId = nameId;
        this.nameIdFormat = principal.getNameIdFormat();
        this.spProvidedId = principal.getSPProvidedID();
        this.nameIdSPNameQualifier = principal.getNameIdSPNameQualifier();
        this.nameIdNameQualifier = principal.getNameIdNameQualifier();
        this.sessionIndexes = principal.getSessionIndexes();
        this.authnContexts = principal.getAuthnContexts().clone();
        String lastAuthnContext = principal.getLastAuthnContext();
        if (lastAuthnContext != null) {
            for (AuthnContext authnContext : this.authnContexts) {
                if (!lastAuthnContext.equals(authnContext.getName())) continue;
                this.lastAuthnContext = authnContext;
                break;
            }
        }
        this.idpProxyContext = principal.getIdPProxyContext();
        this.isMNITerminated = principal.isMNITerminated();
        this.attributes = principal.getAttributes();
        this.setAuthenticationMethod(AUTH_METHOD_SAML2);
        this.computeHashCode();
    }

    public SAML2Principal(SAML2Principal principal, String sessionIndex, AuthnContext newAuthnContext) {
        this(principal);
        if (sessionIndex != null) {
            this.addSessionIndex(sessionIndex);
        }
        this.authnContexts.add(newAuthnContext);
        this.lastAuthnContext = newAuthnContext;
        this.computeHashCode();
    }

    public SAML2Principal(SAML2Principal principal, String nameId, String spProvidedId, boolean mniTerminated) {
        super(principal.getName());
        this.idpName = principal.getIdPName();
        this.spName = principal.getSPName();
        this.nameId = nameId;
        this.nameIdFormat = principal.getNameIdFormat();
        this.spProvidedId = spProvidedId != null ? spProvidedId : principal.getSPProvidedID();
        this.nameIdSPNameQualifier = principal.getNameIdSPNameQualifier();
        this.nameIdNameQualifier = principal.getNameIdNameQualifier();
        this.sessionIndexes = principal.getSessionIndexes();
        this.authnContexts = principal.getAuthnContexts().clone();
        this.isMNITerminated = mniTerminated;
        Iterator<AuthnContext> iter = this.authnContexts.iterator();
        String lastAuthnContext = principal.getLastAuthnContext();
        while (iter.hasNext()) {
            AuthnContext authnContext = iter.next();
            if (authnContext.getName() == null || !authnContext.getName().equals(lastAuthnContext)) continue;
            this.lastAuthnContext = authnContext;
            break;
        }
        this.setAuthenticationMethod(AUTH_METHOD_SAML2);
        this.computeHashCode();
    }

    public SAML2Principal(SAML2Principal principal, String sessionIndex, AuthnContext newAuthnContext, Set<Attribute> attributes) {
        super(principal.getName());
        this.idpName = principal.getIdPName();
        this.spName = principal.getSPName();
        this.nameId = principal.getNameId();
        this.nameIdFormat = principal.getNameIdFormat();
        this.spProvidedId = principal.getSPProvidedID();
        this.nameIdSPNameQualifier = principal.getNameIdSPNameQualifier();
        this.nameIdNameQualifier = principal.getNameIdNameQualifier();
        this.sessionIndexes = principal.getSessionIndexes();
        if (sessionIndex != null) {
            this.addSessionIndex(sessionIndex);
        }
        this.authnContexts = principal.getAuthnContexts().clone();
        this.authnContexts.add(newAuthnContext);
        this.lastAuthnContext = newAuthnContext;
        this.isMNITerminated = principal.isMNITerminated();
        this.attributes = attributes;
        this.setAuthenticationMethod(AUTH_METHOD_SAML2);
        this.computeHashCode();
    }

    public SAML2Principal(String name, String idpName, String spName, String nameId, String nameIdFormat, String spProvidedId, String nameIdSPNameQualifier, String nameIdNameQualifier, String sessionIndex, AuthnContext authnContext, IdPProxyContext proxyContext, boolean isMNITerminated, Set<Attribute> attributes) {
        super(name);
        this.idpName = idpName;
        this.spName = spName;
        this.nameId = nameId;
        this.nameIdFormat = nameIdFormat;
        this.spProvidedId = spProvidedId;
        this.nameIdSPNameQualifier = nameIdSPNameQualifier;
        this.nameIdNameQualifier = nameIdNameQualifier;
        this.sessionIndexes = new ArrayList<String>();
        if (sessionIndex != null) {
            this.sessionIndexes.add(sessionIndex);
        }
        this.authnContexts = new AuthnContextList(authnContext);
        this.lastAuthnContext = authnContext;
        this.idpProxyContext = proxyContext;
        this.isMNITerminated = isMNITerminated;
        this.attributes = attributes;
        this.setAuthenticationMethod(AUTH_METHOD_SAML2);
        this.computeHashCode();
    }

    public String getIdPName() {
        return this.idpName;
    }

    public String getSPName() {
        return this.spName;
    }

    public boolean isLocalProvider(String idp) throws Exception {
        boolean isLocal;
        boolean bl = isLocal = this.spName == null;
        if (isLocal && !this.idpName.equalsIgnoreCase(idp)) {
            throw new Exception("Local provider in SAML2Principal [" + this.idpName + "] is different from current provider [" + idp + "].");
        }
        return isLocal;
    }

    public String getNameId() {
        return this.nameId;
    }

    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    public String getNameIdSPNameQualifier() {
        return this.nameIdSPNameQualifier;
    }

    public String getNameIdNameQualifier() {
        return this.nameIdNameQualifier;
    }

    public String getSPProvidedID() {
        return this.spProvidedId;
    }

    public List<String> getSessionIndexes() {
        ArrayList<String> temp = new ArrayList<String>(this.sessionIndexes.size());
        temp.addAll(this.sessionIndexes);
        return temp;
    }

    public AuthnContextList getAuthnContexts() {
        return this.authnContexts.clone();
    }

    public String getLastAuthnContext() {
        return this.lastAuthnContext == null ? null : this.lastAuthnContext.getName();
    }

    public boolean isIdPProxyRequest() {
        return this.idpProxyContext != null;
    }

    public IdPProxyContext getIdPProxyContext() {
        return this.idpProxyContext;
    }

    public boolean isMNITerminated() {
        return this.isMNITerminated;
    }

    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    public Certificate getSaml2IdpCert() {
        return this.saml2IdpCert;
    }

    public void setSaml2IdpCert(Certificate saml2IdpCert) {
        this.saml2IdpCert = saml2IdpCert;
    }

    public boolean isAssertionUnsigned() {
        return this.isAssertionUnsigned;
    }

    public void setAssertionUnsigned(boolean isAssertionSigned) {
        this.isAssertionUnsigned = isAssertionSigned;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("\n");
        sb.append(" [IdP=").append(this.idpName).append(", SP=").append(this.spName);
        sb.append("; NameID=").append(this.nameId).append("; NameIDFormat=").append(this.nameIdFormat);
        sb.append("; AuthnContexts=").append(this.authnContexts).append("]\n");
        sb.append("; Attributes=").append(this.attributes).append("\n");
        if (this.nameIdNameQualifier != null) {
            sb.append("NameIDNameQualifier=").append(this.nameIdNameQualifier).append("\n");
        }
        if (this.nameIdSPNameQualifier != null) {
            sb.append("NameIDSPNameQualifier=").append(this.nameIdSPNameQualifier).append("\n");
        }
        if (this.spProvidedId != null) {
            sb.append("SPProvidedID=").append(this.spProvidedId).append("\n");
        }
        if (this.idpProxyContext != null) {
            sb.append("IdPProxyContext=").append(this.idpProxyContext).append("\n");
        }
        sb.append("MNI terminated=").append(this.isMNITerminated).append("\n");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SAML2Principal other = (SAML2Principal)obj;
        if (this.authnContexts == null ? other.authnContexts != null : !this.authnContexts.equals(other.authnContexts)) {
            return false;
        }
        if (this.hashCode != other.hashCode) {
            return false;
        }
        if (this.idpName == null ? other.idpName != null : !this.idpName.equals(other.idpName)) {
            return false;
        }
        if (this.idpProxyContext == null ? other.idpProxyContext != null : !this.idpProxyContext.equals(other.idpProxyContext)) {
            return false;
        }
        if (this.isMNITerminated != other.isMNITerminated) {
            return false;
        }
        if (this.lastAuthnContext == null ? other.lastAuthnContext != null : !this.lastAuthnContext.equals(other.lastAuthnContext)) {
            return false;
        }
        if (this.nameId == null ? other.nameId != null : !this.nameId.equals(other.nameId)) {
            return false;
        }
        if (this.nameIdFormat == null ? other.nameIdFormat != null : !this.nameIdFormat.equals(other.nameIdFormat)) {
            return false;
        }
        if (this.nameIdNameQualifier == null ? other.nameIdNameQualifier != null : !this.nameIdNameQualifier.equals(other.nameIdNameQualifier)) {
            return false;
        }
        if (this.nameIdSPNameQualifier == null ? other.nameIdSPNameQualifier != null : !this.nameIdSPNameQualifier.equals(other.nameIdSPNameQualifier)) {
            return false;
        }
        if (this.sessionIndexes == null ? other.sessionIndexes != null : !this.sessionIndexes.equals(other.sessionIndexes)) {
            return false;
        }
        if (this.spName == null ? other.spName != null : !this.spName.equals(other.spName)) {
            return false;
        }
        if (this.spProvidedId == null ? other.spProvidedId != null : !this.spProvidedId.equals(other.spProvidedId)) {
            return false;
        }
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        return !(this.saml2IdpCert == null ? other.saml2IdpCert != null : !this.saml2IdpCert.equals(other.saml2IdpCert));
    }

    public int hashCode() {
        return this.hashCode;
    }

    private void computeHashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.authnContexts == null ? 0 : this.authnContexts.hashCode());
        result = 31 * result + this.hashCode;
        result = 31 * result + (this.idpName == null ? 0 : this.idpName.hashCode());
        result = 31 * result + (this.idpProxyContext == null ? 0 : this.idpProxyContext.hashCode());
        result = 31 * result + (this.isMNITerminated ? 1231 : 1237);
        result = 31 * result + (this.lastAuthnContext == null ? 0 : this.lastAuthnContext.hashCode());
        result = 31 * result + (this.nameId == null ? 0 : this.nameId.hashCode());
        result = 31 * result + (this.nameIdFormat == null ? 0 : this.nameIdFormat.hashCode());
        result = 31 * result + (this.nameIdNameQualifier == null ? 0 : this.nameIdNameQualifier.hashCode());
        result = 31 * result + (this.nameIdSPNameQualifier == null ? 0 : this.nameIdSPNameQualifier.hashCode());
        result = 31 * result + (this.sessionIndexes == null ? 0 : this.sessionIndexes.hashCode());
        result = 31 * result + (this.spName == null ? 0 : this.spName.hashCode());
        result = 31 * result + (this.spProvidedId == null ? 0 : this.spProvidedId.hashCode());
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        this.hashCode = result = 31 * result + (this.saml2IdpCert == null ? 0 : this.saml2IdpCert.hashCode());
    }

    private void addSessionIndex(String sessionIndex) {
        if (sessionIndex == null) {
            return;
        }
        for (String index : this.sessionIndexes) {
            if (!index.equals(sessionIndex)) continue;
            return;
        }
        this.sessionIndexes.add(sessionIndex);
    }
}

