/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons;

import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedProvider;
import com.sap.security.saml2.commons.interfaces.services.SAML2SignatureValidator;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.interfaces.SAML2SignableToken;
import com.sap.tc.logging.Location;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class SAML2SignatureValidatorImpl
implements SAML2SignatureValidator {
    private static final Location LOCATION = Location.getLocation(SAML2SignatureValidatorImpl.class);

    @Override
    public void validateSignature(SAML2SignableToken token, SAML2LocalProvider localProvider, SAML2TrustedProvider trustedProvider) throws SAML2Exception, SAML2ConfigurationException {
        Certificate secondaryCertificate;
        Certificate primaryCertificate;
        block17: {
            block16: {
                primaryCertificate = null;
                try {
                    primaryCertificate = trustedProvider.getCertificateForSignature();
                }
                catch (SAML2ConfigurationException e) {
                    if (!LOCATION.beWarning()) break block16;
                    LOCATION.traceThrowableT(400, "Could not obtain primary certificate for signature", (Throwable)e);
                }
            }
            secondaryCertificate = null;
            try {
                secondaryCertificate = trustedProvider.getSecondaryCertificateForSignature();
            }
            catch (SAML2ConfigurationException e) {
                if (!LOCATION.beWarning()) break block17;
                LOCATION.traceThrowableT(400, "Could not obtain secondary certificate for signature", (Throwable)e);
            }
        }
        if (primaryCertificate == null && secondaryCertificate == null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("There are not available neither primary nor secondary certificates for signature validation");
            }
            throw new SAML2ConfigurationException("Signature of the SAML2 protocol token cannot be validated because neither primary nor secondary certificates are available in the configuration");
        }
        if (primaryCertificate != null) {
            try {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Try to validate the signature with the configured primary certificate");
                }
                token.validateSignature(primaryCertificate);
            }
            catch (SAML2Exception e) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Signature validation with the configured primary certificate failed. Details: {0}", new Object[]{e.getMessage()});
                }
                if (secondaryCertificate == null) {
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("There is not configured secondary certificate, signature validation failed");
                    }
                    throw e;
                }
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("There is configured secondary certificate, try to validate the signature with it.");
                }
                token.validateSignature(secondaryCertificate);
            }
        } else {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Primary certificate for signature validation is not configured or it is missing in the keystore. Try to validate the signature with the configured secondary certificate.");
            }
            token.validateSignature(secondaryCertificate);
        }
    }

    private boolean isTrusted(X509Certificate signatureCertificate, String trustedCAsViewName, String trustedProviderName) {
        return false;
    }
}

