/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons.ljsadapters;

import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.commons.ConsumedAssertionStorageEntity;
import com.sap.security.saml2.commons.interfaces.services.ConsumedAssertionStorage;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.exceptions.SAML2AlreadyConsumedException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ConsumedAssertionStorageLJSAdapter
implements ConsumedAssertionStorage {
    private static final String CONCATENATOR = "@";
    private static int GC_REQUEST_ID_COUNT = 10;
    private static Set<String> consumedResponsesSyncSet;
    private static SortedSet<ConsumedAssertionStorageEntity> consumedResponsesDateSorted;

    @Override
    public synchronized void consume(String idpName, String assertionId, Date subjectConfirmationNotAfterWithClockSkew) throws SAML2AlreadyConsumedException, SAML2Exception {
        String id = this.assertIdWithinIDP(idpName, assertionId);
        if (consumedResponsesSyncSet.contains(id)) {
            throw new SAML2AlreadyConsumedException("SAML2Assertion received is already consumed.");
        }
        consumedResponsesSyncSet.add(id);
        consumedResponsesDateSorted.add(new ConsumedAssertionStorageEntity(id, subjectConfirmationNotAfterWithClockSkew));
        this.removeExpiredAssertions();
    }

    @Override
    public boolean isAlreadyConsumed(String idpName, String assertionId) throws SAML2Exception {
        return consumedResponsesSyncSet.contains(this.assertIdWithinIDP(idpName, assertionId));
    }

    @Override
    public void init() throws SAML2ConfigurationException, SAML2Exception {
        consumedResponsesSyncSet = Collections.synchronizedSet(new HashSet());
        consumedResponsesDateSorted = Collections.synchronizedSortedSet(new TreeSet());
    }

    @Override
    public void destroy() {
    }

    private String assertIdWithinIDP(String idpName, String assertionId) {
        return String.valueOf(assertionId) + CONCATENATOR + idpName;
    }

    private void removeExpiredAssertions() {
        Date currentDate = new Date();
        int i = 0;
        while (i < GC_REQUEST_ID_COUNT) {
            ConsumedAssertionStorageEntity assertionEntry;
            if (consumedResponsesDateSorted.isEmpty() || !(assertionEntry = consumedResponsesDateSorted.first()).getExpiration().before(currentDate)) break;
            consumedResponsesDateSorted.remove(assertionEntry);
            consumedResponsesSyncSet.remove(assertionEntry.getId());
            ++i;
        }
    }
}

