/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.commons.mni;

import com.sap.security.saml2.commons.CommonSAML2Utils;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.tc.logging.Location;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReferrerUrlCookie {
    private static final Location LOCATION = Location.getLocation(ReferrerUrlCookie.class);
    private static final String COOKIE_NAME_PREFIX = "msc";
    private static final String COOKIE_PATH = "/";
    private static final String COOKIE_PARTS_DELIMITER = ";";
    private static final String REFERRER_URL = "refUrl";
    private static final String IS_TERMINATE = "term";
    private String referrerUrl;
    private boolean isTerminate;
    private String cookiePath;
    private boolean isSecure;
    private String cookieName;

    public ReferrerUrlCookie(String cookiePath, boolean isSecure) {
        this.cookiePath = cookiePath;
        if (this.cookiePath == null) {
            cookiePath = COOKIE_PATH;
        }
        this.isSecure = isSecure;
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Created ReferrerUrlCookie: Path [{0}], Secure [{1}]", new Object[]{cookiePath, isSecure});
        }
    }

    private ReferrerUrlCookie(String cookieName) {
        this.cookieName = cookieName;
        this.cookiePath = COOKIE_PATH;
    }

    public static ReferrerUrlCookie getCookie(HttpServletRequest request, String cookieName) throws Exception {
        ReferrerUrlCookie cookie = null;
        if (!ReferrerUrlCookie.isReferrerUrlCookieName(cookieName)) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Could not parse referrer URL cookie because the provided name is invalid: {0}", new Object[]{cookieName});
            }
        } else {
            String cookieValue = (String)ReferrerUrlCookie.getCookieFromRequest(request, cookieName);
            if (cookieValue != null) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Referrer URL cookie value: {0}", new Object[]{cookieValue});
                }
                String decodedValue = URLDecoder.decode(cookieValue, "UTF-8");
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("URLDecoded referrer URL cookie value: {0}", new Object[]{decodedValue});
                }
                String base64DecodedValue = SAML2Utils.decodeBase64AsString((String)decodedValue);
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Base64 decoded referrer URL cookie value: {0}", new Object[]{base64DecodedValue});
                }
                String[] parts = base64DecodedValue.split(COOKIE_PARTS_DELIMITER);
                cookie = new ReferrerUrlCookie(cookieName);
                cookie.handleCookieParts(parts);
            } else {
                LOCATION.warningT("Referrer URL cookie not found in HTTP request.");
            }
        }
        return cookie;
    }

    public String getReferrerUrl() {
        return this.referrerUrl;
    }

    public void setReferrerUrl(String referrerUrl) {
        this.referrerUrl = referrerUrl;
    }

    public boolean isTerminate() {
        return this.isTerminate;
    }

    public void setTerminate(boolean isTerminate) {
        this.isTerminate = isTerminate;
    }

    public String addCookie(HttpServletResponse response, String requestId) throws Exception {
        String name = this.generateCookieName(requestId);
        String value = this.generateCookieValue();
        this.addCookieToResponse(response, name, value);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Referrer URL [{0}] set as cookie: name = [{1}], value = [{2}]", new Object[]{this.referrerUrl, name, value});
        }
        return name;
    }

    public void removeCookie(HttpServletResponse response) {
        if (!ReferrerUrlCookie.isReferrerUrlCookieName(this.cookieName)) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Removing referrer url cookie failed. This cookie has no name.");
            }
            return;
        }
        Cookie newCookie = new Cookie(this.cookieName, "");
        newCookie.setMaxAge(0);
        newCookie.setPath(this.cookiePath);
        response.addCookie(newCookie);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Referrer URL cookie [{0}] set for removal.", new Object[]{this.cookieName});
        }
    }

    private static boolean isReferrerUrlCookieName(String name) {
        return name != null && name.startsWith(COOKIE_NAME_PREFIX);
    }

    private void handleCookieParts(String[] parts) throws Exception {
        LOCATION.debugT("Reading referrer url cookie parts.");
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.startsWith(REFERRER_URL)) {
                String referrer = this.getValueFromPair(part);
                if (referrer != null && !referrer.startsWith(COOKIE_PATH)) {
                    throw new Exception("The referrer url [" + referrer + "] is invalid. Only path expressions are allowed as referrer url.");
                }
                this.referrerUrl = referrer;
                LOCATION.debugT("Referrer URL: {0}", new Object[]{this.referrerUrl});
            } else if (part.startsWith(IS_TERMINATE)) {
                this.isTerminate = Boolean.parseBoolean(this.getValueFromPair(part));
                LOCATION.debugT("Terminate: {0}", new Object[]{this.isTerminate});
            }
            ++n2;
        }
    }

    private String generateCookieName(String requestId) {
        StringBuilder name = new StringBuilder(COOKIE_NAME_PREFIX);
        String hashCode = String.valueOf(Math.abs((long)requestId.hashCode()));
        int i = 0;
        while (i < hashCode.length()) {
            int next = Integer.parseInt(String.valueOf(hashCode.charAt(i)));
            next = next * 25 / 10;
            name.append((char)(97 + next));
            ++i;
        }
        return name.toString();
    }

    private String generateCookieValue() throws NoSuchAlgorithmException, SAML2Exception {
        StringBuilder value = new StringBuilder();
        if (this.referrerUrl != null) {
            value.append(this.generateKeyValuePair(REFERRER_URL, this.referrerUrl)).append(COOKIE_PARTS_DELIMITER);
        }
        value.append(this.generateKeyValuePair(IS_TERMINATE, String.valueOf(this.isTerminate)));
        String plainValue = value.toString();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Referrer URL cookie value: {0}", new Object[]{plainValue});
        }
        String base64EncodedValue = SAML2Utils.encodeBase64AsString((String)plainValue);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Base64 encoded referrer URL cookie value: {0}", new Object[]{base64EncodedValue});
        }
        String encodedValue = CommonSAML2Utils.safeEncodeUrl(base64EncodedValue);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("URL encoded referrer URL cookie value: {0}", new Object[]{encodedValue});
        }
        return encodedValue;
    }

    private String generateKeyValuePair(String name, String value) throws SAML2Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("=").append(SAML2Utils.encodeBase64AsString((String)value));
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Name-value pair [name = {0}, value = {1}] added to referrer URL cookie value.", new Object[]{name, value});
        }
        return sb.toString();
    }

    private String getValueFromPair(String pair) throws Exception {
        int pos = pair.indexOf(61);
        if (pos != -1) {
            String value = pair.substring(pos + 1);
            String decodedValue = SAML2Utils.decodeBase64AsString((String)value);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Value [{0}] extracted from name-value pair [{1}] from referrer URL cookie value.", new Object[]{value, pair});
            }
            return decodedValue;
        }
        throw new Exception("Invalid name-value pair in referrer URL cookie value: " + pair);
    }

    private static Object getCookieFromRequest(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().equalsIgnoreCase(name)) {
                    return cookie.getValue();
                }
                ++n2;
            }
        } else {
            LOCATION.debugT("HTTP request contains no cookies. Referrer URL cookie not found in request.");
        }
        return null;
    }

    private void addCookieToResponse(HttpServletResponse response, String name, String value) throws Exception {
        StringBuilder sbCookieValue = new StringBuilder();
        sbCookieValue.append(value);
        sbCookieValue.append("; path=");
        sbCookieValue.append(this.cookiePath);
        if (this.isSecure) {
            sbCookieValue.append("; secure");
        }
        sbCookieValue.append("; HttpOnly");
        Cookie newCookie = new Cookie(name, sbCookieValue.toString());
        response.addCookie(newCookie);
    }
}

