/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.idp.api;

import com.sap.security.saml2.lib.interfaces.assertions.SAML2ProxyRestriction;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AssertionData {
    private String nameId;
    private String nameIdFormat;
    private String nameQualifier;
    private String spNameQualifier;
    private String spProvidedId;
    private String authenticationContext;
    private Date authenticationInstant;
    private Date sessionNotOnOrAfter;
    private String sessionIndex;
    private Map<String, Collection<String>> attributes;
    private SAML2ProxyRestriction saml2ProxyRestriction;
    private List<String> authenticatingAuthorities;

    public AssertionData(String nameId) {
        this(nameId, null, null, null, null, null, null);
    }

    public AssertionData(String nameId, String nameIdFormat, String authenticationContext, Date authenticationInstant, Date sessionNotOnOrAfter, String sessionIndex, Map<String, Collection<String>> attributes) throws IllegalArgumentException {
        this.nameId = nameId;
        this.nameIdFormat = nameIdFormat;
        this.sessionNotOnOrAfter = sessionNotOnOrAfter;
        this.sessionIndex = sessionIndex;
        this.attributes = attributes;
        this.authenticationContext = authenticationContext;
        this.authenticationInstant = authenticationInstant;
    }

    public String getNameId() {
        return this.nameId;
    }

    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    public String getNameQualifier() {
        return this.nameQualifier;
    }

    public String getSPNameQualifier() {
        return this.spNameQualifier;
    }

    public String getSPProvidedID() {
        return this.spProvidedId;
    }

    public Date getAuthenticationInstant() {
        return this.authenticationInstant;
    }

    public String getAuthenticationContext() {
        return this.authenticationContext;
    }

    public Date getSessionNotOnOrAfter() {
        return this.sessionNotOnOrAfter;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public Map<String, Collection<String>> getAttributes() {
        return this.attributes;
    }

    public SAML2ProxyRestriction getSaml2ProxyRestriction() {
        return this.saml2ProxyRestriction;
    }

    public List<String> getAuthenticatingAuthorities() {
        return this.authenticatingAuthorities;
    }

    public void setNameIdFormat(String nameIdFormat) {
        this.nameIdFormat = nameIdFormat;
    }

    public void setNameQualifier(String nameQualifier) {
        this.nameQualifier = nameQualifier;
    }

    public void setSPNameQualifier(String spNameQualifier) {
        this.spNameQualifier = spNameQualifier;
    }

    public void setSPProvidedID(String spProvidedId) {
        this.spProvidedId = spProvidedId;
    }

    public void setAuthenticationContext(String authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setAuthenticationInstant(Date authenticationInstant) {
        this.authenticationInstant = authenticationInstant;
    }

    public void setSessionNotOnOrAfter(Date sessionNotOnOrAfter) {
        this.sessionNotOnOrAfter = sessionNotOnOrAfter;
    }

    public void setSessionIndex(String sessionIndex) {
        this.sessionIndex = sessionIndex;
    }

    public void setAttributes(Map<String, Collection<String>> attributes) {
        this.attributes = attributes;
    }

    public void setSaml2ProxyRestriction(SAML2ProxyRestriction saml2ProxyRestriction) {
        this.saml2ProxyRestriction = saml2ProxyRestriction;
    }

    public void setAuthenticatingAuthorities(List<String> authenticatingAuthorities) {
        this.authenticatingAuthorities = authenticatingAuthorities;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AssertionData [attributes=");
        builder.append(this.attributes);
        builder.append(", authenticationContext=");
        builder.append(this.authenticationContext);
        builder.append(", authenticationInstant=");
        builder.append(this.authenticationInstant);
        builder.append(", nameId=");
        builder.append(this.nameId);
        builder.append(", nameIdFormat=");
        builder.append(this.nameIdFormat);
        builder.append(", nameQualifier=");
        builder.append(this.nameQualifier);
        builder.append(", spNameQualifier=");
        builder.append(this.spNameQualifier);
        builder.append(", sessionIndex=");
        builder.append(this.sessionIndex);
        builder.append(", sessionNotOnOrAfter=");
        builder.append(this.sessionNotOnOrAfter);
        builder.append(", authenticatingAuthoritiest=");
        builder.append(this.authenticatingAuthorities);
        builder.append(", saml2ProxyRestriction=");
        if (this.saml2ProxyRestriction != null) {
            builder.append("{Audience=");
            builder.append(this.saml2ProxyRestriction.getAudience());
            builder.append(", Count=");
            builder.append(this.saml2ProxyRestriction.getCount()).append("}");
        } else {
            builder.append("null");
        }
        builder.append("]");
        return builder.toString();
    }
}

