/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.idp.api;

import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2IdPConfiguration;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedSP;
import com.sap.security.saml2.commons.CommonSAML2Utils;
import com.sap.security.saml2.commons.SAML2CommonServicesManager;
import com.sap.security.saml2.idp.api.SAML2ConfigurationSynchronizerAccessor;
import com.sap.security.saml2.lib.common.SAML2ErrorResponseDetails;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.exceptions.SAML2ErrorResponseException;
import com.sap.security.saml2.lib.interfaces.SAML2SignableToken;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.bindings.RedirectPayloadDeflate;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2AuthRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ProtocolToken;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2RequestBase;
import com.sap.tc.logging.Location;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;

class AuthnRequestValidationService {
    private static final Location LOCATION = Location.getLocation(AuthnRequestValidationService.class);
    private static final boolean MESSAGE_TYPE_REQUEST = true;
    private static final boolean MESSAGE_TYPE_RESPONSE = false;
    private static final AuthnRequestValidationService INSTANCE = new AuthnRequestValidationService();

    private AuthnRequestValidationService() {
    }

    static AuthnRequestValidationService getInstance() {
        return INSTANCE;
    }

    void ensureSAML2AuthnRequestIsValid(SAML2IdPConfiguration configuration, String actualDestination, SAML2AuthRequest saml2AuthnRequest, RedirectPayloadDeflate payload, SAML2Binding binding) throws SAML2Exception, SAML2ConfigurationException {
        SAML2TrustedSP spConfig;
        block6: {
            String trustedSPName = this.getTrustedSPName(saml2AuthnRequest);
            SAML2ConfigurationSynchronizerAccessor.getInstance().updateTrustedSPConfiguration(configuration.getLocalIdP().getName(), trustedSPName);
            spConfig = configuration.getTrustedSP(trustedSPName);
            if (spConfig == null) {
                LOCATION.logT(500, "Trusted Service Provider with name [{0}] does not exists", new Object[]{trustedSPName});
                throw new SAML2ConfigurationException("No trusted Service Provider configuration with name [" + trustedSPName + "] found");
            }
            this.ensureReceivedSAML2MessageIsValid(configuration.getLocalIdP(), (SAML2ProtocolToken)saml2AuthnRequest, payload, spConfig, false, binding);
            String destinationFromMessage = saml2AuthnRequest.getDestination();
            if (destinationFromMessage != null) {
                try {
                    URL msgDestUrl = new URL(destinationFromMessage);
                    URL actDestUrl = new URL(actualDestination);
                    if (CommonSAML2Utils.getPortFromUrl(msgDestUrl) != CommonSAML2Utils.getPortFromUrl(actDestUrl) || !msgDestUrl.getPath().equalsIgnoreCase(actDestUrl.getPath())) {
                        LOCATION.logT(400, "The received SAML2 message states \"{0}\" as intended destination, but has been sent to \"{1}\".", new Object[]{destinationFromMessage, actualDestination});
                        SAML2ErrorResponseDetails details = new SAML2ErrorResponseDetails(saml2AuthnRequest.getID(), spConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", null, "The SAML2 message has wrong destination path");
                        throw new SAML2ErrorResponseException(details.getStatusMsg(), details);
                    }
                    break block6;
                }
                catch (MalformedURLException e) {
                    LOCATION.traceThrowableT(500, "Received SAML2AuthnRequest from Service Provider [{0}] whose destination contains malformed URL.", new Object[]{spConfig.getName()}, (Throwable)e);
                    LOCATION.logT(500, "The received SAML2 message states \"{0}\" as intended destination, but has been sent to \"{1}\".", new Object[]{destinationFromMessage, actualDestination});
                    SAML2ErrorResponseDetails details = new SAML2ErrorResponseDetails(saml2AuthnRequest.getID(), spConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", null, "The SAML2 message has wrong destination path");
                    throw new SAML2ErrorResponseException(details.getStatusMsg(), details);
                }
            }
            if (saml2AuthnRequest.isSigned() && (SAML2Binding.HTTP_POST_BINDING.equals((Object)binding) || SAML2Binding.HTTP_REDIRECT_BINDING.equals((Object)binding))) {
                LOCATION.logT(500, "The SAML2 message has been received via the {0} binding which requires the message's \"Destination\" element to be set, but the element is empty or missing.", new Object[]{binding.getName()});
                SAML2ErrorResponseDetails details = new SAML2ErrorResponseDetails(saml2AuthnRequest.getID(), spConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", null, "The SAML2 message does not contain destination attribute");
                throw new SAML2ErrorResponseException(details.getStatusMsg(), details);
            }
        }
        this.checkResponseLocationRequirements(saml2AuthnRequest, spConfig);
    }

    private void checkResponseLocationRequirements(SAML2AuthRequest authnRequest, SAML2TrustedSP trustedSP) throws SAML2ErrorResponseException {
        Integer assertionConsumerIndex = authnRequest.getAssertionConsumerServiceIndex();
        String assertionConsumerUrl = authnRequest.getAssertionConsumerServiceURL();
        String protocolBinding = authnRequest.getProtocolBinding();
        if (assertionConsumerIndex != null) {
            if (assertionConsumerUrl != null && assertionConsumerUrl.length() > 0) {
                String extendedMsg = "SAML2 authentication request with id: " + authnRequest.getID() + " received from Service Provider: " + trustedSP.getName() + " contains both AssertionConsumerServiceIndex and AssertionConsumerServiceURL attributes, but should contain at most one of them";
                LOCATION.errorT(extendedMsg);
                throw new SAML2ErrorResponseException(extendedMsg, new SAML2ErrorResponseDetails(authnRequest.getID(), trustedSP.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "Both AssertionConsumerServiceIndex and AssertionConsumerServiceURL attributes are specified, but should be specified at most one of them"));
            }
            if (protocolBinding != null && protocolBinding.length() > 0) {
                String extendedMsg = "SAML2 authentication request with id: " + authnRequest.getID() + " received from Service Provider: " + trustedSP.getName() + " must not contain ProtocolBinding attribute together with AssertionConsumerServiceIndex attribute";
                LOCATION.errorT(extendedMsg);
                throw new SAML2ErrorResponseException(extendedMsg, new SAML2ErrorResponseDetails(authnRequest.getID(), trustedSP.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "ProtocolBinding attribute must not be specified together with AssertionConsumerServiceIndex attribute"));
            }
            if (trustedSP.getAssertionConsumerEndpoint(assertionConsumerIndex.intValue()) == null) {
                String extendedMsg = "SAML2 authentication request with id: " + authnRequest.getID() + " received from Service Provider: " + trustedSP.getName() + " requested returning of the SAML2 Response at Assertion Consumer Service with index: " + assertionConsumerIndex + ". But ACS endpoint with such index is not found in the configuration for this trusted SP";
                LOCATION.errorT(extendedMsg);
                throw new SAML2ErrorResponseException(extendedMsg, new SAML2ErrorResponseDetails(authnRequest.getID(), trustedSP.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", null, "Requested Assertion Consumer Service endpoint index is not found in the configuration"));
            }
        }
        SAML2Binding requiredBinding = null;
        if (protocolBinding != null && protocolBinding.length() > 0) {
            requiredBinding = SAML2Binding.getBinding((String)protocolBinding);
            if (requiredBinding == null) {
                String extendedMsg = "SAML2 authentication request with id: " + authnRequest.getID() + " received from Service Provider: " + trustedSP.getName() + " contains unknown binding specified as ProtocolBinding attribute: " + protocolBinding;
                LOCATION.errorT(extendedMsg);
                throw new SAML2ErrorResponseException(extendedMsg, new SAML2ErrorResponseDetails(authnRequest.getID(), trustedSP.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:UnsupportedBinding", "Unknown binding specified as ProtocolBinding attribute"));
            }
            if (requiredBinding != SAML2Binding.HTTP_POST_BINDING && requiredBinding != SAML2Binding.HTTP_ARTIFACT_BINDING) {
                String extendedMsg = "SAML2 authentication request with id: " + authnRequest.getID() + " received from Service Provider: " + trustedSP.getName() + " contains unsupported binding as ProtocolBinding attribute: " + protocolBinding;
                LOCATION.errorT(extendedMsg);
                throw new SAML2ErrorResponseException(extendedMsg, new SAML2ErrorResponseDetails(authnRequest.getID(), trustedSP.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:UnsupportedBinding", "Unsupported binding specified as ProtocolBinding attribute"));
            }
        }
        if (assertionConsumerUrl != null && assertionConsumerUrl.length() > 0 && !authnRequest.isSigned() && !authnRequest.isSignedOnBindingLevel() && this.findACSEndpointByLocation(trustedSP, assertionConsumerUrl, requiredBinding) == null) {
            String extendedMsg = "SAML2 authentication request with id: " + authnRequest.getID() + " received from Service Provider: " + trustedSP.getName() + " requested returning of the SAML2 Response at Assertion Consumer Service with url: " + assertionConsumerUrl + ". But the authentication request is not signed and ACS endpoint with such url is not found in the configuration for this trusted SP";
            LOCATION.errorT(extendedMsg);
            throw new SAML2ErrorResponseException(extendedMsg, new SAML2ErrorResponseDetails(authnRequest.getID(), trustedSP.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", null, "AuthnRequest was not signed and the requested Assertion Consumer Service endpoint URL is not found in the configuration"));
        }
    }

    private SAML2Endpoint findACSEndpointByLocation(SAML2TrustedSP trustedSP, String url, SAML2Binding requiredBinding) {
        SAML2Endpoint defaultEndpoint;
        int qsIndex = url.indexOf(63);
        if (qsIndex != -1) {
            url = url.substring(0, qsIndex);
        }
        if ((defaultEndpoint = trustedSP.getDefaultAssertionConsumerEndpoint()) != null) {
            String responseLocation = defaultEndpoint.getResponseLocation();
            String location = defaultEndpoint.getLocation();
            if ((url.equalsIgnoreCase(responseLocation) || url.equalsIgnoreCase(location)) && (requiredBinding == null || requiredBinding == defaultEndpoint.getBinding())) {
                return defaultEndpoint;
            }
        }
        Collection endpoints = null;
        endpoints = requiredBinding != null ? trustedSP.getAssertionConsumerEndpoints(requiredBinding) : trustedSP.getACSEndpoints();
        if (endpoints != null && !endpoints.isEmpty()) {
            for (SAML2Endpoint endpoint : endpoints) {
                String responseLocation = endpoint.getResponseLocation();
                String location = endpoint.getLocation();
                if (!url.equalsIgnoreCase(responseLocation) && !url.equalsIgnoreCase(location)) continue;
                return endpoint;
            }
        }
        return null;
    }

    private void ensureReceivedSAML2MessageIsValid(SAML2LocalIdP idpConfig, SAML2ProtocolToken protocolToken, RedirectPayloadDeflate payload, SAML2TrustedSP spConfig, boolean checkIssuer, SAML2Binding binding) throws SAML2ErrorResponseException {
        block22: {
            SAML2ErrorResponseDetails details;
            String samlVersion = protocolToken.getVersion();
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Trusted Service Provider configuration: {0}", new Object[]{spConfig});
            }
            if (!"2.0".equals(samlVersion)) {
                LOCATION.logT(400, "The received SAML2 message complies with SAML version {0} which is not supported.", new Object[]{samlVersion});
                SAML2ErrorResponseDetails details2 = new SAML2ErrorResponseDetails(protocolToken.getID(), spConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:VersionMismatch", null, "SAML version is not supported");
                throw new SAML2ErrorResponseException(details2.getStatusMsg(), details2);
            }
            try {
                CommonSAML2Utils.checkIssueInstant(protocolToken.getIssueInstant(), (SAML2LocalProvider)idpConfig);
            }
            catch (SAML2Exception e) {
                LOCATION.logT(500, "The received SAML2 message has been issued at {0}, which is not within the expected time frame. The message has either expired or is not yet valid.", new Object[]{protocolToken.getIssueInstant()});
                SAML2ErrorResponseDetails details3 = new SAML2ErrorResponseDetails(protocolToken.getID(), spConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", null, "The message has either expired or is not yet valid.");
                throw new SAML2ErrorResponseException(details3.getStatusMsg(), (Throwable)e, details3);
            }
            if (checkIssuer) {
                SAML2NameID issuer = protocolToken.getIssuer();
                if (issuer == null) {
                    LOCATION.logT(500, "The received SAML2 message does not contain the mandatory issuer name ID.");
                    SAML2ErrorResponseDetails details4 = new SAML2ErrorResponseDetails(protocolToken.getID(), spConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", null, "The received SAML2 message does not contain the mandatory issuer name ID.");
                    throw new SAML2ErrorResponseException(details4.getStatusMsg(), details4);
                }
                String name = issuer.getName();
                String format = issuer.getFormat();
                if (format != null && !"urn:oasis:names:tc:SAML:2.0:nameid-format:entity".equals(format)) {
                    LOCATION.logT(400, "The name ID format {0} of the issuer {1} of the received SAML2 message is invalid.", new Object[]{format, name});
                    SAML2ErrorResponseDetails details5 = new SAML2ErrorResponseDetails(protocolToken.getID(), spConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", null, "The name ID format of the issuer of the received SAML2 message is invalid.");
                    throw new SAML2ErrorResponseException(details5.getStatusMsg(), details5);
                }
                if (!spConfig.getName().equals(name)) {
                    LOCATION.logT(400, "The received SAML2 response mentions service provider {0} as issuer, but was expected to come from service provider {1}.", new Object[]{name, spConfig.getName()});
                    SAML2ErrorResponseDetails details6 = new SAML2ErrorResponseDetails(protocolToken.getID(), spConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", null, "The issuer of the received SAML2 message is invalid.");
                    throw new SAML2ErrorResponseException(details6.getStatusMsg(), details6);
                }
            }
            if (protocolToken instanceof SAML2RequestBase) {
                // empty if block
            }
            try {
                if (payload != null) {
                    if (payload.isSigned()) {
                        try {
                            SAML2CommonServicesManager.getInstance().getSignatureValidator().validateSignature((SAML2SignableToken)payload, (SAML2LocalProvider)idpConfig, (SAML2TrustedProvider)spConfig);
                            LOCATION.debugT("The digital signature on the received SAML2 message (payload) is valid.");
                        }
                        catch (SAML2Exception e) {
                            LOCATION.debugT("The digital signature on the received SAML2 message (payload) is invalid.");
                            details = new SAML2ErrorResponseDetails(protocolToken.getID(), spConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "The digital signature of the received SAML2 message is invalid.");
                            throw new SAML2ErrorResponseException(details.getStatusMsg(), (Throwable)e, details);
                        }
                        catch (SAML2ConfigurationException e) {
                            LOCATION.debugT("The digital signature on the received SAML2 message (payload) cannot be checked because of an error while retrieving the signing certificate of the issuer from the identity provider configuration.");
                            throw e;
                        }
                    } else {
                        this.ensureSignatureIsNotRequired(spConfig, binding, protocolToken);
                    }
                }
                if (protocolToken.isSigned()) {
                    try {
                        SAML2CommonServicesManager.getInstance().getSignatureValidator().validateSignature((SAML2SignableToken)protocolToken, (SAML2LocalProvider)idpConfig, (SAML2TrustedProvider)spConfig);
                        LOCATION.debugT("The digital signature on the received SAML2 message is valid.");
                        break block22;
                    }
                    catch (SAML2Exception e) {
                        LOCATION.debugT("The digital signature on the received SAML2 message is invalid.");
                        details = new SAML2ErrorResponseDetails(protocolToken.getID(), spConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "The digital signature of the received SAML2 message is invalid.");
                        throw new SAML2ErrorResponseException(details.getStatusMsg(), (Throwable)e, details);
                    }
                    catch (SAML2ConfigurationException e) {
                        LOCATION.debugT("The digital signature on the received SAML2 message cannot be checked because of an error while retrieving the signing certificate of the issuer from the identity provider configuration.");
                        throw e;
                    }
                }
                if (payload == null || !payload.isSigned()) {
                    this.ensureSignatureIsNotRequired(spConfig, binding, protocolToken);
                }
            }
            catch (SAML2ConfigurationException e) {
                LOCATION.logT(500, "An unexpected exception occurred. See call stack for details.");
                details = new SAML2ErrorResponseDetails(protocolToken.getID(), spConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:Responder", null, "An unexpected exception occurred. See call stack for details.");
                throw new SAML2ErrorResponseException(details.getStatusMsg(), (Throwable)e, details);
            }
        }
    }

    private String getTrustedSPName(SAML2AuthRequest saml2Request) throws SAML2Exception {
        String trustedSPName = null;
        SAML2NameID issuerNameId = saml2Request.getIssuer();
        if (issuerNameId == null || issuerNameId.getName() == null || issuerNameId.getName().length() < 1) {
            throw new SAML2Exception("SAML2Request does not specify an issuer.");
        }
        trustedSPName = issuerNameId.getName();
        return trustedSPName;
    }

    private void ensureSignatureIsNotRequired(SAML2TrustedSP spConfig, SAML2Binding binding, SAML2ProtocolToken protocolToken) throws SAML2ErrorResponseException {
        boolean saml2MessageMustBeSigned = true;
        SignatureOption signatureRequirements = this.getSignatureRequirements(spConfig, protocolToken);
        if (signatureRequirements == SignatureOption.NEVER) {
            saml2MessageMustBeSigned = false;
        } else if (signatureRequirements == SignatureOption.FRONT_CHANNEL_ONLY && binding != SAML2Binding.HTTP_REDIRECT_BINDING && binding != SAML2Binding.HTTP_POST_BINDING) {
            saml2MessageMustBeSigned = false;
        }
        if (binding == SAML2Binding.HTTP_ARTIFACT_BINDING && protocolToken.isParentSAML2TokenSignatureVerified()) {
            saml2MessageMustBeSigned = false;
            LOCATION.debugT("There is no digital signature on the received SAML2 message, but parent SAML2 token is signed and the SAML2 message inherits its signature.");
        }
        if (saml2MessageMustBeSigned) {
            LOCATION.warningT("Received SAML2 message from Service Provider: {0} through binding: {1} is not signed, but the configuration require signature for this message and binding. Configured value for signature requirement is: {2}", new Object[]{spConfig.getName(), binding, signatureRequirements});
            SAML2ErrorResponseDetails details = new SAML2ErrorResponseDetails(protocolToken.getID(), spConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "The received SAML2 authentication request is not signed, but the configuration require signature for the message and binding.");
            throw new SAML2ErrorResponseException(details.getStatusMsg(), details);
        }
        LOCATION.debugT("There is no digital signature on the received SAML2 message (payload), but it is not required either.");
    }

    private SignatureOption getSignatureRequirements(SAML2TrustedSP spConfig, SAML2ProtocolToken protocolToken) {
        if (protocolToken instanceof SAML2AuthRequest) {
            return spConfig.isToRequireSignedAuthnRequests();
        }
        throw new IllegalStateException("This method is not implemented for messages other that SAML2AuthRequest");
    }
}

