/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.idp.api;

import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2IdPConfiguration;
import com.sap.security.saml2.commons.slo.SLOInfo;
import com.sap.security.saml2.commons.slo.SLORequestInfo;
import com.sap.security.saml2.commons.sso.SSORequestInfo;
import com.sap.security.saml2.idp.api.AssertionData;
import com.sap.security.saml2.idp.api.AuthnRequestValidationService;
import com.sap.security.saml2.idp.api.LogoutResponseData;
import com.sap.security.saml2.idp.api.SLOService;
import com.sap.security.saml2.idp.api.SSOService;
import com.sap.security.saml2.lib.bindings.HTTPRedirectBindingDeflate;
import com.sap.security.saml2.lib.common.SAML2ErrorResponseDetails;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ProtocolFactory;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.common.exceptions.SAML2ErrorResponseException;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.bindings.RedirectPayloadDeflate;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2AuthRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2Response;
import com.sap.tc.logging.Location;
import java.util.List;
import java.util.Map;

public class SAML2IdPAPI {
    private static final SAML2IdPAPI INSTANCE = new SAML2IdPAPI();
    private static final Location LOCATION = Location.getLocation(SAML2IdPAPI.class);

    private SAML2IdPAPI() {
    }

    public static SAML2IdPAPI getInstance() {
        return INSTANCE;
    }

    public SAML2Response createSSOResponse(SAML2IdPConfiguration configuration, String spName, AssertionData data, SAML2AuthRequest authRequest) throws SAML2Exception, SAML2ConfigurationException, IllegalArgumentException {
        SAML2Response response = SSOService.getInstance().createAuthnResponse(configuration, spName, null, data, authRequest, false);
        response.generate();
        return response;
    }

    public SAML2Response createSSOResponse(SAML2IdPConfiguration configuration, String spName, AssertionData data) throws SAML2Exception, SAML2ConfigurationException, IllegalArgumentException {
        return this.createSSOResponse(configuration, spName, data, null);
    }

    public SAML2Response createSSOResponse(SAML2IdPConfiguration configuration, String spName, String destinationUrl, AssertionData data) throws SAML2Exception, SAML2ConfigurationException, IllegalArgumentException {
        SAML2Response response = SSOService.getInstance().createAuthnResponse(configuration, spName, destinationUrl, data, null, false);
        response.generate();
        return response;
    }

    public SAML2Response createSSOResponseForExternalSP(SAML2IdPConfiguration configuration, String spName, String destinationUrl, AssertionData data) throws SAML2Exception, SAML2ConfigurationException, IllegalArgumentException {
        SAML2Response response = SSOService.getInstance().createAuthnResponse(configuration, spName, destinationUrl, data, null, true);
        response.generate();
        return response;
    }

    public SAML2Response createSSOErrorResponse(SAML2IdPConfiguration configuration, SAML2ErrorResponseDetails errorDetails) throws SAML2Exception, SAML2ConfigurationException, IllegalArgumentException {
        return this.createSSOErrorResponse(configuration, errorDetails, null);
    }

    public SAML2Response createSSOErrorResponse(SAML2IdPConfiguration configuration, SAML2ErrorResponseDetails errorDetails, SAML2AuthRequest authnRequest) throws SAML2Exception, SAML2ConfigurationException, IllegalArgumentException {
        SAML2Response response = SSOService.getInstance().createSSOErrorResponse(configuration, errorDetails, authnRequest);
        response.generate();
        return response;
    }

    public String createSSOResponseHttpBody(SAML2Response response, String relayState) throws SAML2Exception, IllegalArgumentException {
        return SSOService.getInstance().createSSOResponseHttpBody(response, relayState);
    }

    public String createSLORequestUrl(SAML2IdPConfiguration configuration, String spName, String relayState, SAML2NameID nameId, List<String> sessionIndexes) throws SAML2Exception, SAML2ConfigurationException {
        return SLOService.getInstance().createSLORequestUrl(configuration, spName, relayState, nameId, sessionIndexes, null);
    }

    public String createSLORequestUrl(SAML2IdPConfiguration configuration, String spName, String relayState, SAML2NameID nameId, List<String> sessionIndexes, String requestId) throws SAML2Exception, SAML2ConfigurationException {
        return SLOService.getInstance().createSLORequestUrl(configuration, spName, relayState, nameId, sessionIndexes, requestId);
    }

    public String createSLORequestHttpBody(SAML2IdPConfiguration configuration, String spName, String relayState, SAML2NameID nameId, List<String> sessionIndexes) throws SAML2Exception, SAML2ConfigurationException {
        return SLOService.getInstance().createSLORequestHttpBody(configuration, spName, relayState, nameId, sessionIndexes, null);
    }

    public String createSLORequestHttpBody(SAML2IdPConfiguration configuration, String spName, String relayState, SAML2NameID nameId, List<String> sessionIndexes, String requestId) throws SAML2Exception, SAML2ConfigurationException {
        return SLOService.getInstance().createSLORequestHttpBody(configuration, spName, relayState, nameId, sessionIndexes, requestId);
    }

    public String createSLOResponseUrl(SAML2IdPConfiguration configuration, SLORequestInfo sloRequestInfo) throws SAML2Exception, SAML2ConfigurationException {
        return SLOService.getInstance().createSLOResponseUrl(configuration, sloRequestInfo);
    }

    public String createSLOResponseUrl(SAML2IdPConfiguration configuration, String spName, LogoutResponseData data) throws SAML2Exception, SAML2ConfigurationException {
        return SLOService.getInstance().createSLOResponseUrl(configuration, spName, data);
    }

    public String createSLOResponseHttpBody(SAML2IdPConfiguration configuration, SLORequestInfo sloRequestInfo) throws SAML2Exception, SAML2ConfigurationException {
        return SLOService.getInstance().createSLOResponseHttpBody(configuration, sloRequestInfo);
    }

    public String createSLOResponseHttpBody(SAML2IdPConfiguration configuration, String spName, LogoutResponseData data) throws SAML2Exception, SAML2ConfigurationException {
        return SLOService.getInstance().createSLOResponseHttpBody(configuration, spName, data);
    }

    public String createSLOErrorResponseUrl(SAML2IdPConfiguration configuration, SAML2ErrorResponseDetails errorDetails, String relayState) throws SAML2Exception, SAML2ConfigurationException {
        return SLOService.getInstance().createSLOErrorResponseUrl(configuration, errorDetails, relayState);
    }

    public String createSLOErrorResponseHttpBody(SAML2IdPConfiguration configuration, SAML2ErrorResponseDetails errorDetails, String relayState) throws SAML2Exception, SAML2ConfigurationException {
        return SLOService.getInstance().createSLOErrorResponseHttpBody(configuration, errorDetails, relayState);
    }

    public SLOInfo validateSLOMessageUrl(SAML2IdPConfiguration configuration, String url) throws SAML2Exception, SAML2ErrorResponseException, SAML2ConfigurationException {
        return SLOService.getInstance().validateSLOMessageUrl(configuration, url);
    }

    public SLOInfo validateSLOMessageHttpBody(SAML2IdPConfiguration configuration, Map<String, String> saml2PostParameters) throws SAML2Exception, SAML2ErrorResponseException, SAML2ConfigurationException {
        return SLOService.getInstance().validateSLOMessageHttpBody(configuration, saml2PostParameters);
    }

    public SSORequestInfo validateAuthnRequestUrl(SAML2IdPConfiguration configuration, String url) throws SAML2Exception, SAML2ConfigurationException, SAML2ErrorResponseException {
        int questionMarkIndex;
        if (LOCATION.beInfo()) {
            LOCATION.infoT("SAML2 request for validation:\n{0}", new Object[]{url});
        }
        if ((questionMarkIndex = url.indexOf(63)) == -1) {
            throw new SAML2Exception("Given url: " + url + " does not contain SAML2 authentication request for validation.");
        }
        String queryString = url.substring(questionMarkIndex + 1);
        RedirectPayloadDeflate redirectPayload = HTTPRedirectBindingDeflate.extractRedirectPayload((String)queryString);
        if (redirectPayload == null) {
            throw new SAML2Exception("Given url: " + url + " does not contain SAML2 authentication request for validation.");
        }
        Object obj = redirectPayload.getSAMLPayload();
        SAML2AuthRequest saml2AuthnRequest = null;
        if (!(obj instanceof SAML2AuthRequest)) {
            throw new SAML2Exception("Given url: " + url + " does not contain SAML2 authentication request for validation.");
        }
        saml2AuthnRequest = (SAML2AuthRequest)obj;
        String recipientUrl = url.substring(0, questionMarkIndex);
        AuthnRequestValidationService.getInstance().ensureSAML2AuthnRequestIsValid(configuration, recipientUrl, saml2AuthnRequest, redirectPayload, SAML2Binding.HTTP_REDIRECT_BINDING);
        SSORequestInfo ssoRequestInfo = new SSORequestInfo(saml2AuthnRequest);
        String relayState = redirectPayload.getRelayState();
        ssoRequestInfo.setRelayState(relayState);
        return ssoRequestInfo;
    }

    public SSORequestInfo validateAuthnRequestHttpBody(SAML2IdPConfiguration configuration, Map<String, String> saml2PostParameters, String recipientUrl) throws SAML2Exception, SAML2ConfigurationException, SAML2ErrorResponseException {
        if (LOCATION.beInfo()) {
            LOCATION.infoT("SAML2 POST parameters for authentication request validation:\n{0}", new Object[]{saml2PostParameters});
        }
        if (saml2PostParameters == null || saml2PostParameters.isEmpty()) {
            throw new SAML2Exception("There is no SAML2 authentication request to validate. SAML2 POST parameters map is empty");
        }
        String saml2AuthnRequest = saml2PostParameters.get("SAMLRequest");
        String relayState = saml2PostParameters.get("RelayState");
        if (saml2AuthnRequest != null) {
            String authnRequestXML = SAML2Utils.decodeBase64AsString((String)saml2AuthnRequest);
            return this.validateAuthnRequestHttpBody(configuration, authnRequestXML, relayState, recipientUrl);
        }
        throw new SAML2Exception("There is no SAML2 authentication request to validate in the given POST parameters");
    }

    public SSORequestInfo validateAuthnRequestHttpBody(SAML2IdPConfiguration configuration, String authnRequestXML, String relayState, String recipientUrl) throws SAML2Exception, SAML2ConfigurationException, SAML2ErrorResponseException {
        SAML2AuthRequest saml2AuthnRequest = null;
        try {
            saml2AuthnRequest = SAML2ProtocolFactory.getInstance().createAuthnRequest(authnRequestXML);
            saml2AuthnRequest.parse();
        }
        catch (SAML2Exception e) {
            throw new SAML2Exception("Could not parse the given authentication request XML", (Throwable)e);
        }
        SSORequestInfo ssoRequestInfo = new SSORequestInfo(saml2AuthnRequest);
        AuthnRequestValidationService.getInstance().ensureSAML2AuthnRequestIsValid(configuration, recipientUrl, saml2AuthnRequest, null, SAML2Binding.HTTP_POST_BINDING);
        ssoRequestInfo.setRelayState(relayState);
        return ssoRequestInfo;
    }
}

