/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.idp.api;

import com.sap.security.saml2.cfg.enums.EncryptionAlgorithm;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedSP;
import com.sap.security.saml2.idp.api.IdPUtils;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ProtocolFactory;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutResponse;
import com.sap.tc.logging.Location;
import java.security.Key;
import java.security.PublicKey;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

class SLOMessageFactory {
    private static final Location LOCATION = Location.getLocation(SLOMessageFactory.class);

    SLOMessageFactory() {
    }

    static SAML2LogoutRequest createLogoutRequest(SAML2LocalIdP localIdP, SAML2TrustedSP trustedSP, String spSLOUrl, String nameId, String nameIdFormat, String nameIdSPNameQualifier, String nameIdNameQualifier, List<String> sessionIndexes, String requestId) throws SAML2Exception, SAML2ConfigurationException {
        SAML2LogoutRequest logoutRequest;
        SAML2NameID userNameId = SAML2DataFactory.getInstance().createSAML2NameID(nameId);
        userNameId.setFormat(nameIdFormat);
        userNameId.setSPNameQualifier(nameIdSPNameQualifier);
        userNameId.setNameQualifier(nameIdNameQualifier);
        try {
            Date now = Calendar.getInstance().getTime();
            if (requestId == null) {
                requestId = SAML2Utils.generateUUID();
            }
            if (trustedSP.isToEncryptSingleLogoutSubject()) {
                EncryptionAlgorithm encryptAlgorithm = trustedSP.getEncryptionAlgorithm();
                if (encryptAlgorithm == null) {
                    throw new SAML2ConfigurationException("Encryption algorithm cannot be read from trusted SP configuration.");
                }
                PublicKey spEncPublicKey = IdPUtils.getTrustedSPPublicKeyForEncryption(trustedSP);
                SAML2EncryptedNameID encNameId = userNameId.encrypt((Key)spEncPublicKey, encryptAlgorithm.getName());
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("LogoutRequest Name ID successfully encrypted using algorithm: {0}", encryptAlgorithm.getName());
                }
                logoutRequest = SAML2ProtocolFactory.getInstance().createLogoutRequest(requestId, now, encNameId);
            } else {
                logoutRequest = SAML2ProtocolFactory.getInstance().createLogoutRequest(requestId, now, userNameId);
            }
            logoutRequest.setSessionIndex(sessionIndexes);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("SesionIndex set in the LogoutRequest: {0}", new Object[]{sessionIndexes});
            }
            SAML2NameID issuerNameId = SAML2DataFactory.getInstance().createSAML2NameID(localIdP.getName());
            logoutRequest.setIssuer(issuerNameId);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Issuer set in the LogoutRequest: {0}", new Object[]{localIdP.getName()});
            }
            logoutRequest.setDestination(spSLOUrl);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Destination set in the LogoutRequest: {0}", new Object[]{spSLOUrl});
            }
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(500, "LogoutRequest could not be created due to a configuration problem.", (Throwable)e);
            throw e;
        }
        catch (SAML2Exception e) {
            LOCATION.traceThrowableT(500, "LogoutRequest could not be created.", (Throwable)e);
            throw e;
        }
        return logoutRequest;
    }

    static SAML2LogoutResponse createLogoutResponse(SAML2LocalIdP localIdP, String spSLOLocation, String inResponseTo, String statusCode, String secondLevelStatusCode, String statusMessage) throws SAML2Exception {
        SAML2LogoutResponse logoutResponse = SAML2ProtocolFactory.getInstance().createLogoutResponse(SAML2Utils.generateUUID(), statusCode, new Date());
        logoutResponse.setSecondLevelStatusCode(secondLevelStatusCode);
        SAML2NameID nameID = SAML2DataFactory.getInstance().createSAML2NameID(localIdP.getName());
        logoutResponse.setIssuer(nameID);
        logoutResponse.setInResponseTo(inResponseTo);
        logoutResponse.setDestination(spSLOLocation);
        logoutResponse.setStatusMessage(statusMessage);
        return logoutResponse;
    }

    static SAML2LogoutResponse createLogoutResponse(SAML2LocalIdP localIdP, SAML2TrustedSP trustedSP, SAML2Binding binding, String inResponseTo, String statusCode, String secondLevelStatusCode, String statusMessage) throws SAML2Exception, SAML2ConfigurationException {
        SAML2Endpoint spSLOEndpoint = IdPUtils.getSLOEndpoint(trustedSP, binding);
        String spSLOLocation = spSLOEndpoint.getResponseLocation();
        if (!(spSLOLocation != null && spSLOLocation.length() >= 1 || (spSLOLocation = spSLOEndpoint.getLocation()) != null && spSLOLocation.length() >= 1)) {
            throw new SAML2ConfigurationException("Configured SLO endpoint for SP: " + trustedSP.getName() + " does not contain ResponseLocation or Location");
        }
        return SLOMessageFactory.createLogoutResponse(localIdP, spSLOLocation, inResponseTo, statusCode, secondLevelStatusCode, statusMessage);
    }
}

