/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.idp.api;

import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2IdPConfiguration;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedSP;
import com.sap.security.saml2.commons.CommonSAML2Utils;
import com.sap.security.saml2.commons.SAML2CommonServicesManager;
import com.sap.security.saml2.commons.slo.SLOInfo;
import com.sap.security.saml2.commons.slo.SLORequestInfo;
import com.sap.security.saml2.commons.slo.SLOResponseInfo;
import com.sap.security.saml2.idp.api.IdPUtils;
import com.sap.security.saml2.lib.common.SAML2ErrorResponseDetails;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ProtocolFactory;
import com.sap.security.saml2.lib.common.exceptions.SAML2ErrorResponseException;
import com.sap.security.saml2.lib.common.exceptions.SAML2ValidationFailedException;
import com.sap.security.saml2.lib.interfaces.SAML2SignableToken;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.bindings.RedirectPayloadDeflate;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutResponse;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ProtocolToken;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2RequestBase;
import com.sap.tc.logging.Location;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Date;
import java.util.List;

class SLOMessageValidator {
    private static final Location LOCATION = Location.getLocation(SLOMessageValidator.class);

    SLOMessageValidator() {
    }

    static SLOInfo validateSLOPayload(RedirectPayloadDeflate redirectPayload, SAML2IdPConfiguration cfg) throws SAML2Exception, SAML2ErrorResponseException, SAML2ConfigurationException {
        SLOInfo result = null;
        Object payload = redirectPayload.getSAMLPayload();
        if (!(payload instanceof SAML2LogoutRequest) && !(payload instanceof SAML2LogoutResponse)) {
            throw new SAML2Exception("Received SAML2 message is neither LogoutRequest nor LogoutResponse. Parsed token: " + payload);
        }
        SAML2ProtocolToken protocolToken = (SAML2ProtocolToken)payload;
        SAML2LocalIdP localIdP = IdPUtils.getLocalIdP(cfg);
        SAML2TrustedSP trustedSP = SLOMessageValidator.getTrustedSP(cfg, protocolToken);
        SLOMessageValidator.validateMessageSignature(redirectPayload, protocolToken, localIdP, trustedSP);
        if (protocolToken instanceof SAML2LogoutRequest) {
            SAML2LogoutRequest logoutRequest = (SAML2LogoutRequest)protocolToken;
            result = SLOMessageValidator.validate(logoutRequest, localIdP, trustedSP, SAML2Binding.HTTP_REDIRECT_BINDING);
        } else if (protocolToken instanceof SAML2LogoutResponse) {
            SAML2LogoutResponse logoutResponse = (SAML2LogoutResponse)protocolToken;
            result = SLOMessageValidator.validate(logoutResponse, localIdP, trustedSP, SAML2Binding.HTTP_REDIRECT_BINDING);
        } else {
            throw new SAML2Exception("Received SAML2 message is neither LogoutRequest nor LogoutResponse. Parsed token: " + payload);
        }
        return result;
    }

    static SLORequestInfo validateSLORequest(String logoutRequestXML, SAML2IdPConfiguration cfg) throws SAML2Exception, SAML2ErrorResponseException, SAML2ConfigurationException {
        SAML2LogoutRequest logoutRequest = SAML2ProtocolFactory.getInstance().createLogoutRequest(logoutRequestXML);
        logoutRequest.parse();
        SAML2LocalIdP localIdP = IdPUtils.getLocalIdP(cfg);
        SAML2TrustedSP trustedSP = SLOMessageValidator.getTrustedSP(cfg, (SAML2ProtocolToken)logoutRequest);
        SLOMessageValidator.validateSLOMessageSignature((SAML2ProtocolToken)logoutRequest, localIdP, trustedSP, SAML2Binding.HTTP_POST_BINDING);
        SLORequestInfo result = SLOMessageValidator.validate(logoutRequest, localIdP, trustedSP, SAML2Binding.HTTP_POST_BINDING);
        return result;
    }

    static SLOResponseInfo validateSLOResponse(String logoutResponseXML, SAML2IdPConfiguration cfg) throws SAML2Exception, SAML2ConfigurationException {
        SAML2LogoutResponse logoutResponse = SAML2ProtocolFactory.getInstance().createLogoutResponse(logoutResponseXML);
        logoutResponse.parse();
        SAML2LocalIdP localIdP = IdPUtils.getLocalIdP(cfg);
        SAML2TrustedSP trustedSP = SLOMessageValidator.getTrustedSP(cfg, (SAML2ProtocolToken)logoutResponse);
        SLOMessageValidator.validateSLOMessageSignature((SAML2ProtocolToken)logoutResponse, localIdP, trustedSP, SAML2Binding.HTTP_POST_BINDING);
        SLOResponseInfo result = SLOMessageValidator.validate(logoutResponse, localIdP, trustedSP, SAML2Binding.HTTP_POST_BINDING);
        return result;
    }

    private static SAML2TrustedSP getTrustedSP(SAML2IdPConfiguration cfg, SAML2ProtocolToken protocolToken) throws SAML2ValidationFailedException, SAML2ConfigurationException {
        SAML2NameID issuer = protocolToken.getIssuer();
        if (issuer == null || issuer.getName() == null) {
            throw new SAML2ValidationFailedException("SLO message does not specify an issuer.");
        }
        String spName = issuer.getName();
        return IdPUtils.getTrustedSP(cfg, spName);
    }

    private static SLORequestInfo validate(SAML2LogoutRequest logoutRequest, SAML2LocalIdP localIdP, SAML2TrustedSP trustedSP, SAML2Binding binding) throws SAML2ErrorResponseException {
        String spName = trustedSP.getName();
        if (LOCATION.beInfo()) {
            boolean isSigned = logoutRequest.isSigned() || logoutRequest.isSignedOnBindingLevel();
            String signed = isSigned ? "signed" : "not signed";
            LOCATION.infoT("Processing {0} LogoutRequest from Service Provider: {1} through binding: {2}\nSAML2 message:\n {3}", new Object[]{signed, spName, binding.getName(), logoutRequest.getXMLRepresentation()});
        }
        SLOMessageValidator.checkIssueInstant(logoutRequest, localIdP, spName);
        SAML2NameID nameId = SLOMessageValidator.getNameId(localIdP, trustedSP, logoutRequest);
        List sessionIndexes = logoutRequest.getSessionIndex();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SessionIndex received in LogoutRequest: {0}", new Object[]{sessionIndexes});
        }
        if (sessionIndexes == null || sessionIndexes.isEmpty()) {
            SAML2ErrorResponseDetails details = new SAML2ErrorResponseDetails(logoutRequest.getID(), spName, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "LogoutRequest does not specify session indexes.");
            throw new SAML2ErrorResponseException(details.getStatusMsg(), details);
        }
        SLORequestInfo result = new SLORequestInfo(logoutRequest.getID(), spName, nameId, sessionIndexes, logoutRequest);
        return result;
    }

    private static SLOResponseInfo validate(SAML2LogoutResponse logoutResponse, SAML2LocalIdP localIdP, SAML2TrustedSP trustedSP, SAML2Binding binding) throws SAML2Exception {
        String spName = trustedSP.getName();
        if (LOCATION.beInfo()) {
            boolean isSigned = logoutResponse.isSigned() || logoutResponse.isSignedOnBindingLevel();
            String signed = isSigned ? "signed" : "not signed";
            LOCATION.infoT("Processing {0} LogoutResponse from Service Provider: {1} through binding: {2}\nSAML2 message:\n {3}", new Object[]{signed, spName, binding.getName(), logoutResponse.getXMLRepresentation()});
        }
        SLOResponseInfo result = new SLOResponseInfo(logoutResponse.getID(), spName, logoutResponse.getInResponseTo(), logoutResponse.getTopLevelStatusCode(), logoutResponse);
        result.setSecondaryStatusCode(logoutResponse.getSecondLevelStatusCode());
        result.setStatusMessage(logoutResponse.getStatusMessage());
        return result;
    }

    private static void checkIssueInstant(SAML2LogoutRequest logoutRequest, SAML2LocalIdP spConfig, String spName) throws SAML2ErrorResponseException {
        Date issueInstant = logoutRequest.getIssueInstant();
        try {
            CommonSAML2Utils.checkIssueInstant(issueInstant, (SAML2LocalProvider)spConfig);
        }
        catch (SAML2Exception e) {
            LOCATION.traceThrowableT(400, "LogoutRequest issue instant is not valid.", (Throwable)e);
            SAML2ErrorResponseDetails details = new SAML2ErrorResponseDetails(logoutRequest.getID(), spName, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "LogoutRequest issue instant is not valid.");
            throw new SAML2ErrorResponseException(details.getStatusMsg(), details);
        }
    }

    private static void validateMessageSignature(RedirectPayloadDeflate redirectPayload, SAML2ProtocolToken protocolToken, SAML2LocalIdP idpConfiguration, SAML2TrustedSP trustedSP) throws SAML2ErrorResponseException, SAML2ValidationFailedException {
        if (redirectPayload.isSigned()) {
            try {
                SAML2CommonServicesManager.getInstance().getSignatureValidator().validateSignature((SAML2SignableToken)redirectPayload, (SAML2LocalProvider)idpConfiguration, (SAML2TrustedProvider)trustedSP);
                LOCATION.debugT("Payload signature successfully validated.");
            }
            catch (SAML2ConfigurationException e) {
                LOCATION.traceThrowableT(500, "Could not read trusted Service Provider [" + trustedSP.getName() + "] certificate for signature from configuration.", (Throwable)e);
                if (protocolToken instanceof SAML2RequestBase) {
                    throw new SAML2ErrorResponseException("Could not read trusted Service Provider [" + trustedSP.getName() + "] certificate for signature from configuration.", (Throwable)e, new SAML2ErrorResponseDetails(protocolToken.getID(), trustedSP.getName(), "urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Configuration error occurred."));
                }
                throw new SAML2ValidationFailedException("Trusted Service Provider [" + trustedSP.getName() + "] certificate for signature not found", (Throwable)e);
            }
            catch (SAML2Exception e) {
                LOCATION.traceThrowableT(400, "RedirectPayload signature is invalid.", (Throwable)e);
                if (protocolToken instanceof SAML2RequestBase) {
                    throw new SAML2ErrorResponseException("RedirectPayload signature is invalid.", (Throwable)e, new SAML2ErrorResponseDetails(protocolToken.getID(), trustedSP.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "RedirectPayload signature is invalid."));
                }
                throw new SAML2ValidationFailedException("RedirectPayload signature is invalid.", (Throwable)e);
            }
        } else if (trustedSP.isToRequireSignedSingleLogoutMessages() == SignatureOption.ALWAYS || trustedSP.isToRequireSignedSingleLogoutMessages() == SignatureOption.FRONT_CHANNEL_ONLY) {
            if (protocolToken instanceof SAML2RequestBase) {
                throw new SAML2ErrorResponseException("RedirectPayload is not signed.", new SAML2ErrorResponseDetails(protocolToken.getID(), trustedSP.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "RedirectPayload is not signed."));
            }
            throw new SAML2ValidationFailedException("RedirectPayload is not signed.");
        }
    }

    private static void validateSLOMessageSignature(SAML2ProtocolToken protocolToken, SAML2LocalIdP localIdP, SAML2TrustedSP trustedSP, SAML2Binding binding) throws SAML2ErrorResponseException, SAML2ValidationFailedException {
        String spName = trustedSP.getName();
        if (protocolToken.isSigned()) {
            try {
                SAML2CommonServicesManager.getInstance().getSignatureValidator().validateSignature((SAML2SignableToken)protocolToken, (SAML2LocalProvider)localIdP, (SAML2TrustedProvider)trustedSP);
                LOCATION.debugT("SLO message signature successfully validated.");
            }
            catch (SAML2ConfigurationException e) {
                LOCATION.traceThrowableT(500, "Could not read trusted Service Provider [" + spName + "] certificate for signature from configuration.", (Throwable)e);
                if (protocolToken instanceof SAML2RequestBase) {
                    throw new SAML2ErrorResponseException("Could not validate SLO message signature due to missing certificate.", (Throwable)e, new SAML2ErrorResponseDetails(protocolToken.getID(), spName, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Configuration error occurred."));
                }
                throw new SAML2ValidationFailedException("Could not validate SLO message signature due to missing certificate.", (Throwable)e);
            }
            catch (SAML2Exception e) {
                LOCATION.traceThrowableT(400, "SLO message signature is invalid.", (Throwable)e);
                if (protocolToken instanceof SAML2RequestBase) {
                    throw new SAML2ErrorResponseException("SLO message signature is invalid.", new SAML2ErrorResponseDetails(protocolToken.getID(), spName, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "SLO message signature is invalid."));
                }
                throw new SAML2ValidationFailedException("SLO message signature is invalid.", (Throwable)e);
            }
        } else if (trustedSP.isToRequireSignedSingleLogoutMessages() == SignatureOption.ALWAYS || trustedSP.isToRequireSignedSingleLogoutMessages() == SignatureOption.FRONT_CHANNEL_ONLY && SAML2Binding.HTTP_POST_BINDING == binding) {
            if (protocolToken.isParentSAML2TokenSignatureVerified()) {
                LOCATION.debugT("SLO message is not signed but its parent message was signed. Signature accepted as valid.");
            } else {
                if (protocolToken instanceof SAML2RequestBase) {
                    throw new SAML2ErrorResponseException("SLO message is not signed.", new SAML2ErrorResponseDetails(protocolToken.getID(), spName, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "SLO message is not signed."));
                }
                throw new SAML2ValidationFailedException("SLO message is not signed.");
            }
        }
    }

    private static SAML2NameID getNameId(SAML2LocalIdP idpConfig, SAML2TrustedSP spConfig, SAML2LogoutRequest logoutRequest) throws SAML2ErrorResponseException {
        SAML2EncryptedNameID encNameId = logoutRequest.getEncryptedNameID();
        if (encNameId == null) {
            if (spConfig.isToRequireEncryptedSingleLogoutSubject()) {
                throw new SAML2ErrorResponseException("LogoutRequest does not contain encrypted Name ID.", new SAML2ErrorResponseDetails(logoutRequest.getID(), logoutRequest.getIssuer().getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "LogoutRequest does not contain encrypted Name ID."));
            }
            SAML2NameID nameId = logoutRequest.getNameID();
            if (nameId == null || nameId.getName() == null) {
                throw new SAML2ErrorResponseException("LogoutRequest does not contain name-id.", new SAML2ErrorResponseDetails(logoutRequest.getID(), logoutRequest.getIssuer().getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "LogoutRequest does not contain name-id."));
            }
            return nameId;
        }
        PrivateKey privateKey = SLOMessageValidator.getPrivateKeyForEncryption(idpConfig, logoutRequest.getID(), logoutRequest.getIssuer().getName());
        try {
            SAML2NameID plainNameId = encNameId.decrypt((Key)privateKey);
            LOCATION.debugT("Encrypted Name ID in LogoutRequest successfully decrypted: {0}", new Object[]{plainNameId});
            return plainNameId;
        }
        catch (SAML2Exception e) {
            LOCATION.traceThrowableT(500, "Could not decrypt encrypted Name ID received in LogoutRequest.", (Throwable)e);
            throw new SAML2ErrorResponseException("Could not decrypt encrypted Name ID received in LogoutRequest.", new SAML2ErrorResponseDetails(logoutRequest.getID(), logoutRequest.getIssuer().getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "Could not decrypt encrypted Name ID received in LogoutRequest."));
        }
    }

    private static PrivateKey getPrivateKeyForEncryption(SAML2LocalIdP idpConfig, String requestId, String issuerName) throws SAML2ErrorResponseException {
        PrivateKey privateKey = null;
        try {
            privateKey = idpConfig.getPrivateKeyForEncryption();
            if (privateKey == null) {
                throw new SAML2ErrorResponseException("Could not decrypt NameId due to configuration error (missing private key for decryption).", new SAML2ErrorResponseDetails(requestId, issuerName, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Configuration error occurred."));
            }
        }
        catch (SAML2ConfigurationException sAML2ConfigurationException) {
            throw new SAML2ErrorResponseException("Could not decrypt NameId due to configuration error (failed during reading of the private key for decryption).", new SAML2ErrorResponseDetails(requestId, issuerName, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Configuration error occurred."));
        }
        return privateKey;
    }
}

