/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.idp.api;

import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2IdPConfiguration;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedSP;
import com.sap.security.saml2.commons.slo.SLOInfo;
import com.sap.security.saml2.commons.slo.SLORequestInfo;
import com.sap.security.saml2.idp.api.IdPUtils;
import com.sap.security.saml2.idp.api.LogoutResponseData;
import com.sap.security.saml2.idp.api.SLOMessageFactory;
import com.sap.security.saml2.idp.api.SLOMessageValidator;
import com.sap.security.saml2.lib.bindings.HTTPPostBinding;
import com.sap.security.saml2.lib.bindings.HTTPRedirectBindingDeflate;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2ErrorResponseDetails;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.common.exceptions.SAML2ErrorResponseException;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.bindings.RedirectPayloadDeflate;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutResponse;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ProtocolToken;
import com.sap.tc.logging.Location;
import java.util.List;
import java.util.Map;

class SLOService {
    private static final Location LOCATION = Location.getLocation(SLOService.class);
    private static final SLOService INSTANCE = new SLOService();

    private SLOService() {
    }

    static SLOService getInstance() {
        return INSTANCE;
    }

    String createSLORequestUrl(SAML2IdPConfiguration configuration, String spName, String relayState, SAML2NameID nameId, List<String> sessionIndexes, String sloRequestId) throws SAML2Exception, SAML2ConfigurationException {
        if (LOCATION.bePath()) {
            LOCATION.entering("createSLORequestUrl", new Object[]{spName, relayState, nameId, sessionIndexes});
        }
        IdPUtils.checkStringArgument("createSLORequestUrl", "spName", spName);
        IdPUtils.checkNameId("createSLORequestUrl", nameId);
        IdPUtils.checkSessionIndexes("createSLORequestUrl", sessionIndexes);
        SAML2LocalIdP localIdP = IdPUtils.getLocalIdP(configuration);
        SAML2TrustedSP trustedSP = IdPUtils.getTrustedSP(configuration, spName);
        String spSLOLocation = IdPUtils.getSLOLocation(trustedSP, SAML2Binding.HTTP_REDIRECT_BINDING);
        SAML2LogoutRequest logoutRequest = SLOMessageFactory.createLogoutRequest(localIdP, trustedSP, spSLOLocation, nameId.getName(), nameId.getFormat(), nameId.getSPNameQualifier(), nameId.getNameQualifier(), sessionIndexes, sloRequestId);
        RedirectPayloadDeflate redirectPayload = SAML2DataFactory.getInstance().createRedirectPayloadDeflate((SAML2ProtocolToken)logoutRequest, relayState);
        IdPUtils.signSLORedirectPayload(localIdP, trustedSP, redirectPayload);
        String redirectUrl = HTTPRedirectBindingDeflate.generateRedirectLocationURL((String)spSLOLocation, (RedirectPayloadDeflate)redirectPayload);
        if (LOCATION.bePath()) {
            LOCATION.exiting("createSLORequestUrl", (Object)redirectUrl);
        }
        return redirectUrl;
    }

    String createSLORequestHttpBody(SAML2IdPConfiguration configuration, String spName, String relayState, SAML2NameID nameId, List<String> sessionIndexes, String sloRequestId) throws SAML2Exception, SAML2ConfigurationException {
        if (LOCATION.bePath()) {
            LOCATION.entering("createSLORequestHttpBody", new Object[]{spName, relayState, nameId, sessionIndexes});
        }
        IdPUtils.checkStringArgument("createSLORequestHttpBody", "spName", spName);
        IdPUtils.checkNameId("createSLORequestHttpBody", nameId);
        IdPUtils.checkSessionIndexes("createSLORequestHttpBody", sessionIndexes);
        SAML2LocalIdP localIdP = IdPUtils.getLocalIdP(configuration);
        SAML2TrustedSP trustedSP = IdPUtils.getTrustedSP(configuration, spName);
        String spSLOLocation = IdPUtils.getSLOLocation(trustedSP, SAML2Binding.HTTP_POST_BINDING);
        SAML2LogoutRequest logoutRequest = SLOMessageFactory.createLogoutRequest(localIdP, trustedSP, spSLOLocation, nameId.getName(), nameId.getFormat(), nameId.getSPNameQualifier(), nameId.getNameQualifier(), sessionIndexes, sloRequestId);
        IdPUtils.signSLOMessage(localIdP, trustedSP, (SAML2ProtocolToken)logoutRequest);
        String xmlRequest = logoutRequest.generate();
        LOCATION.debugT("Generated LogoutRequest: " + xmlRequest);
        String body = HTTPPostBinding.generateRequestForm((String)xmlRequest, (String)relayState, (String)spSLOLocation, null);
        if (LOCATION.bePath()) {
            LOCATION.exiting("createSLORequestHttpBody");
        }
        return body;
    }

    String createSLOResponseUrl(SAML2IdPConfiguration configuration, SLORequestInfo sloRequestInfo) throws SAML2Exception, SAML2ConfigurationException {
        if (LOCATION.bePath()) {
            LOCATION.entering("createSLOResponseUrl", new Object[]{sloRequestInfo});
        }
        IdPUtils.checkArgument("createSLOResponseUrl", "sloRequestInfo", sloRequestInfo);
        String trustedSPName = IdPUtils.getIssuer(sloRequestInfo);
        if (trustedSPName == null || trustedSPName.length() == 0) {
            throw new SAML2Exception("SLO response message could not be created, because sloRequestInfo does not contain issuer name of the original request.");
        }
        LogoutResponseData logoutResponseData = new LogoutResponseData(sloRequestInfo.getId(), "urn:oasis:names:tc:SAML:2.0:status:Success", null, null, sloRequestInfo.getRelayState());
        return this.createSLOResponseUrl(configuration, trustedSPName, logoutResponseData);
    }

    String createSLOResponseUrl(SAML2IdPConfiguration configuration, String spName, LogoutResponseData logoutResponseData) throws SAML2Exception, SAML2ConfigurationException {
        if (LOCATION.bePath()) {
            LOCATION.entering("createSLOResponseUrl", new Object[]{spName, logoutResponseData});
        }
        IdPUtils.checkStringArgument("createSLOResponseUrl", "spName", spName);
        if (logoutResponseData == null) {
            throw new IllegalArgumentException("Parameter logoutResponseData is null.");
        }
        IdPUtils.checkStringArgument("createSLOResponseUrl", "inResponseTo", logoutResponseData.getInResponseTo());
        if (logoutResponseData.getStatusCode() == null) {
            logoutResponseData.setStatusCode("urn:oasis:names:tc:SAML:2.0:status:Success");
        }
        SAML2LocalIdP localIdP = IdPUtils.getLocalIdP(configuration);
        SAML2TrustedSP trustedSP = IdPUtils.getTrustedSP(configuration, spName);
        SAML2LogoutResponse logoutResponse = SLOMessageFactory.createLogoutResponse(localIdP, trustedSP, SAML2Binding.HTTP_REDIRECT_BINDING, logoutResponseData.getInResponseTo(), logoutResponseData.getStatusCode(), logoutResponseData.getSecondLevelStatusCode(), logoutResponseData.getStatusMessage());
        RedirectPayloadDeflate redirectPayload = SAML2DataFactory.getInstance().createRedirectPayloadDeflate((SAML2ProtocolToken)logoutResponse, logoutResponseData.getRelayState());
        try {
            IdPUtils.signSLORedirectPayload(localIdP, trustedSP, redirectPayload);
        }
        catch (SAML2ConfigurationException e) {
            SAML2ErrorResponseDetails details = new SAML2ErrorResponseDetails(logoutResponseData.getInResponseTo(), spName, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Cannot get private key for local IdP.");
            throw new SAML2ErrorResponseException("Cannot get private key for local IdP.", (Throwable)e, details);
        }
        String redirectUrl = HTTPRedirectBindingDeflate.generateRedirectLocationURL((String)logoutResponse.getDestination(), (RedirectPayloadDeflate)redirectPayload);
        if (LOCATION.bePath()) {
            LOCATION.exiting("createSLOResponseUrl", (Object)redirectUrl);
        }
        return redirectUrl;
    }

    String createSLOResponseHttpBody(SAML2IdPConfiguration configuration, SLORequestInfo sloRequestInfo) throws SAML2Exception, SAML2ConfigurationException {
        if (LOCATION.bePath()) {
            LOCATION.entering("createSLOResponseHttpBody", new Object[]{sloRequestInfo});
        }
        IdPUtils.checkArgument("createSLOResponseHttpBody", "sloRequestInfo", sloRequestInfo);
        String trustedSPName = IdPUtils.getIssuer(sloRequestInfo);
        if (trustedSPName == null || trustedSPName.length() == 0) {
            throw new SAML2Exception("SLO response message could not be created, because sloRequestInfo does not contain issuer name of the original request.");
        }
        LogoutResponseData logoutResponseData = new LogoutResponseData(sloRequestInfo.getId(), "urn:oasis:names:tc:SAML:2.0:status:Success", null, null, sloRequestInfo.getRelayState());
        return this.createSLOResponseHttpBody(configuration, trustedSPName, logoutResponseData);
    }

    String createSLOResponseHttpBody(SAML2IdPConfiguration configuration, String spName, LogoutResponseData logoutResponseData) throws SAML2Exception, SAML2ConfigurationException {
        if (LOCATION.bePath()) {
            LOCATION.entering("createSLOResponseHttpBody", new Object[]{spName, logoutResponseData});
        }
        IdPUtils.checkStringArgument("createSLOResponseHttpBody", "spName", spName);
        if (logoutResponseData == null) {
            throw new IllegalArgumentException("Parameter logoutResponseData is null.");
        }
        IdPUtils.checkStringArgument("createSLOResponseHttpBody", "inResponseTo", logoutResponseData.getInResponseTo());
        if (logoutResponseData.getStatusCode() == null) {
            logoutResponseData.setStatusCode("urn:oasis:names:tc:SAML:2.0:status:Success");
        }
        SAML2LocalIdP localIdP = IdPUtils.getLocalIdP(configuration);
        SAML2TrustedSP trustedSP = IdPUtils.getTrustedSP(configuration, spName);
        SAML2LogoutResponse logoutResponse = SLOMessageFactory.createLogoutResponse(localIdP, trustedSP, SAML2Binding.HTTP_POST_BINDING, logoutResponseData.getInResponseTo(), logoutResponseData.getStatusCode(), logoutResponseData.getSecondLevelStatusCode(), logoutResponseData.getStatusMessage());
        try {
            IdPUtils.signSLOMessage(localIdP, trustedSP, (SAML2ProtocolToken)logoutResponse);
        }
        catch (SAML2ConfigurationException e) {
            SAML2ErrorResponseDetails details = new SAML2ErrorResponseDetails(logoutResponseData.getInResponseTo(), spName, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Cannot get private key for local IdP.");
            throw new SAML2ErrorResponseException("Cannot get private key for local IdP.", (Throwable)e, details);
        }
        String xmlResponse = logoutResponse.generate();
        LOCATION.debugT("Generated LogoutResponse: " + xmlResponse);
        String body = HTTPPostBinding.generateResponseForm((String)xmlResponse, (String)logoutResponseData.getRelayState(), (String)logoutResponse.getDestination(), null);
        if (LOCATION.bePath()) {
            LOCATION.exiting("createSLOResponseHttpBody");
        }
        return body;
    }

    String createSLOErrorResponseUrl(SAML2IdPConfiguration configuration, SAML2ErrorResponseDetails errorDetails, String relayState) throws SAML2Exception, SAML2ConfigurationException {
        if (LOCATION.bePath()) {
            LOCATION.entering("createSLOErrorResponseUrl", new Object[]{errorDetails, relayState});
        }
        IdPUtils.checkArgument("createSLOErrorResponseUrl", "errorDetails", errorDetails);
        String trustedSPName = errorDetails.getOriginalRequestIssuer();
        if (trustedSPName == null || trustedSPName.length() == 0) {
            throw new SAML2Exception("SLO error response message could not be created, because errorDetails does not contain issuer name of the original request.");
        }
        SAML2LocalIdP localIdP = IdPUtils.getLocalIdP(configuration);
        SAML2TrustedSP trustedSP = IdPUtils.getTrustedSP(configuration, trustedSPName);
        SAML2LogoutResponse logoutResponse = SLOMessageFactory.createLogoutResponse(localIdP, trustedSP, SAML2Binding.HTTP_REDIRECT_BINDING, errorDetails.getOriginalRequestId(), errorDetails.getStatusCode(), errorDetails.getSecondLevelStatusCode(), errorDetails.getStatusMsg());
        RedirectPayloadDeflate redirectPayload = SAML2DataFactory.getInstance().createRedirectPayloadDeflate((SAML2ProtocolToken)logoutResponse, relayState);
        try {
            IdPUtils.signSLORedirectPayload(localIdP, trustedSP, redirectPayload);
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(400, "Identity Provider could not sign the Error Response message due to configuration error.", (Throwable)e);
        }
        String redirectUrl = HTTPRedirectBindingDeflate.generateRedirectLocationURL((String)logoutResponse.getDestination(), (RedirectPayloadDeflate)redirectPayload);
        if (LOCATION.bePath()) {
            LOCATION.exiting("createSLOErrorResponseUrl", (Object)redirectUrl);
        }
        return redirectUrl;
    }

    String createSLOErrorResponseHttpBody(SAML2IdPConfiguration configuration, SAML2ErrorResponseDetails errorDetails, String relayState) throws SAML2Exception, SAML2ConfigurationException {
        if (LOCATION.bePath()) {
            LOCATION.entering("createSLOErrorResponseHttpBody", new Object[]{errorDetails, relayState});
        }
        IdPUtils.checkArgument("createSLOErrorResponseHttpBody", "errorDetails", errorDetails);
        String trustedSPName = errorDetails.getOriginalRequestIssuer();
        if (trustedSPName == null || trustedSPName.length() == 0) {
            throw new SAML2Exception("SLO error response message could not be created, because errorDetails does not contain issuer name of the original request.");
        }
        SAML2LocalIdP localIdP = IdPUtils.getLocalIdP(configuration);
        SAML2TrustedSP trustedSP = IdPUtils.getTrustedSP(configuration, trustedSPName);
        SAML2LogoutResponse logoutResponse = SLOMessageFactory.createLogoutResponse(localIdP, trustedSP, SAML2Binding.HTTP_POST_BINDING, errorDetails.getOriginalRequestId(), errorDetails.getStatusCode(), errorDetails.getSecondLevelStatusCode(), errorDetails.getStatusMsg());
        try {
            IdPUtils.signSLOMessage(localIdP, trustedSP, (SAML2ProtocolToken)logoutResponse);
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(400, "Identity Provider could not sign the Error Response message due to configuration error.", (Throwable)e);
        }
        String xmlResponse = logoutResponse.generate();
        LOCATION.debugT("Generated LogoutResponse: " + xmlResponse);
        String body = HTTPPostBinding.generateResponseForm((String)xmlResponse, (String)relayState, (String)logoutResponse.getDestination(), null);
        if (LOCATION.bePath()) {
            LOCATION.exiting("createSLOErrorResponseHttpBody");
        }
        return body;
    }

    SLOInfo validateSLOMessageUrl(SAML2IdPConfiguration configuration, String url) throws SAML2Exception, SAML2ErrorResponseException, SAML2ConfigurationException {
        int questionMarkIndex;
        if (LOCATION.bePath()) {
            LOCATION.entering("validateSLOMessageUrl", new Object[]{url});
        }
        if ((questionMarkIndex = url.indexOf(63)) == -1) {
            throw new SAML2Exception("Given url: " + url + " does not contain SAML2 SLO message for validation.");
        }
        String queryString = url.substring(questionMarkIndex + 1);
        RedirectPayloadDeflate redirectPayload = HTTPRedirectBindingDeflate.extractRedirectPayload((String)queryString);
        if (redirectPayload == null) {
            throw new SAML2Exception("Given url: " + url + " does not contain SAML2 SLO message for validation.");
        }
        SLOInfo result = SLOMessageValidator.validateSLOPayload(redirectPayload, configuration);
        String relayState = redirectPayload.getRelayState();
        result.setRelayState(relayState);
        if (LOCATION.bePath()) {
            LOCATION.exiting("validateSLOMessageUrl", (Object)result);
        }
        return result;
    }

    SLOInfo validateSLOMessageHttpBody(SAML2IdPConfiguration configuration, Map<String, String> saml2PostParameters) throws SAML2Exception, SAML2ErrorResponseException, SAML2ConfigurationException {
        SLOInfo result;
        if (LOCATION.bePath()) {
            LOCATION.entering("validateSLOMessageHttpBody", new Object[]{saml2PostParameters});
        }
        if (saml2PostParameters == null || saml2PostParameters.size() == 0) {
            throw new SAML2Exception("There is not SAML2 SLO message to validate. SAML2 POST parameters map is empty");
        }
        String logoutRequestBase64 = saml2PostParameters.get("SAMLRequest");
        String logoutResponseBase64 = saml2PostParameters.get("SAMLResponse");
        if (logoutRequestBase64 != null) {
            String logoutRequestXML = SAML2Utils.decodeBase64AsString((String)logoutRequestBase64);
            result = SLOMessageValidator.validateSLORequest(logoutRequestXML, configuration);
        } else if (logoutResponseBase64 != null) {
            String logoutResponseXML = SAML2Utils.decodeBase64AsString((String)logoutResponseBase64);
            result = SLOMessageValidator.validateSLOResponse(logoutResponseXML, configuration);
        } else {
            throw new SAML2Exception("POST parameters supplied as input parameter does not contain LogoutRequest or LogoutResponse.");
        }
        String relayState = saml2PostParameters.get("RelayState");
        result.setRelayState(relayState);
        if (LOCATION.bePath()) {
            LOCATION.exiting("validateSLOMessageHttpBody", (Object)result);
        }
        return result;
    }
}

