/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.idp.api;

import com.sap.security.saml2.cfg.custom.SAML2TrustedSPCustomImpl;
import com.sap.security.saml2.cfg.enums.DigestAlgorithm;
import com.sap.security.saml2.cfg.enums.EncryptionAlgorithm;
import com.sap.security.saml2.cfg.enums.EncryptionOption;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2IdPConfiguration;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedSP;
import com.sap.security.saml2.idp.api.AssertionData;
import com.sap.security.saml2.idp.api.DummyX509CertImpl;
import com.sap.security.saml2.idp.api.IdPUtils;
import com.sap.security.saml2.lib.bindings.HTTPPostBinding;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2ErrorResponseDetails;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2IDGenerator;
import com.sap.security.saml2.lib.common.SAML2ProtocolFactory;
import com.sap.security.saml2.lib.common.exceptions.SAML2ErrorResponseException;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Attribute;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2AttributeStatement;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2AuthnStatement;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedAssertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2ProxyRestriction;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SubjectConfirmation;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SubjectConfirmationData;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2AuthRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2Response;
import com.sap.tc.logging.Location;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

class SSOService {
    private static final Location LOCATION = Location.getLocation(SSOService.class);
    private static final SSOService INSTANCE = new SSOService();

    private SSOService() {
    }

    static SSOService getInstance() {
        return INSTANCE;
    }

    SAML2Response createAuthnResponse(SAML2IdPConfiguration configuration, String spName, String destinationUrl, AssertionData assertionData, SAML2AuthRequest authnRequest, boolean forExternalSP) throws SAML2Exception, SAML2ConfigurationException {
        String authnRequestId = null;
        if (authnRequest != null) {
            authnRequestId = authnRequest.getID();
        }
        if (LOCATION.bePath()) {
            LOCATION.entering("createAuthnResponse", new Object[]{configuration, spName, assertionData, authnRequestId});
        }
        try {
            SAML2Response response = this.generateAuthenticationResponse(configuration, spName, destinationUrl, assertionData, authnRequest, SAML2Binding.HTTP_POST_BINDING, forExternalSP);
            if (LOCATION.beDebug()) {
                if (authnRequestId == null) {
                    LOCATION.debugT("Successfully created an unsolicited response.");
                } else {
                    LOCATION.debugT("Successfully created an SAML2 response.");
                }
            }
            SAML2Response sAML2Response = response;
            return sAML2Response;
        }
        catch (SAML2Exception e) {
            if (LOCATION.beDebug()) {
                if (authnRequestId == null) {
                    LOCATION.traceThrowableT(500, "An error occured when creating an unsolicited response", (Throwable)e);
                } else {
                    LOCATION.traceThrowableT(500, "An error occured when creating an SAML2 response", (Throwable)e);
                }
            }
            throw e;
        }
        catch (SAML2ConfigurationException e) {
            if (LOCATION.beDebug()) {
                if (authnRequestId == null) {
                    LOCATION.traceThrowableT(500, "A configuration error occured when creating an unsolicited response", (Throwable)e);
                } else {
                    LOCATION.traceThrowableT(500, "A configuration error occured when creating an SAML2 response", (Throwable)e);
                }
            }
            throw e;
        }
        finally {
            if (LOCATION.bePath()) {
                LOCATION.exiting("createAuthnResponse");
            }
        }
    }

    SAML2Response createSSOErrorResponse(SAML2IdPConfiguration configuration, SAML2ErrorResponseDetails errorResponseDetails, SAML2AuthRequest authnRequest) throws SAML2Exception, SAML2ConfigurationException {
        String authnRequestId = null;
        if (authnRequest != null) {
            authnRequestId = authnRequest.getID();
        }
        if (LOCATION.bePath()) {
            LOCATION.entering("createSSOErrorResponse", new Object[]{configuration, errorResponseDetails, authnRequestId});
        }
        try {
            SAML2Response sAML2Response = this.createErrorResponse(configuration, errorResponseDetails, authnRequest);
            return sAML2Response;
        }
        finally {
            if (LOCATION.bePath()) {
                LOCATION.exiting("createSSOErrorResponse");
            }
        }
    }

    private SAML2Response generateAuthenticationResponse(SAML2IdPConfiguration configuration, String spName, String destinationUrl, AssertionData assertionData, SAML2AuthRequest authnRequest, SAML2Binding binding, boolean forExternalSP) throws SAML2Exception, SAML2ConfigurationException {
        boolean encryptAssertion;
        boolean encryptSubjectNameID;
        List<SAML2AttributeStatement> attributeStatements;
        if (configuration == null) {
            throw new IllegalArgumentException("configuration parameter is null.");
        }
        if (spName == null) {
            throw new IllegalArgumentException("spName parameter is null.");
        }
        if (assertionData == null) {
            throw new IllegalArgumentException("assertionData parameter is null.");
        }
        SAML2LocalIdP idpConfig = IdPUtils.getLocalIdP(configuration);
        Object spConfig = forExternalSP ? new SAML2TrustedSPCustomImpl(spName, (X509Certificate)new DummyX509CertImpl(), null) : IdPUtils.getTrustedSP(configuration, spName);
        Date authnInstant = assertionData.getAuthenticationInstant();
        if (authnInstant == null) {
            authnInstant = new Date(System.currentTimeMillis());
        }
        SAML2NameID idpNameID = null;
        if (idpConfig != null) {
            String idpName = idpConfig.getName();
            idpNameID = SAML2DataFactory.getInstance().createSAML2NameID(idpName);
        }
        String assertionid = SAML2IDGenerator.generateAssertionID();
        Date issueInstant = new Date(System.currentTimeMillis());
        List<SAML2AuthnStatement> statements = this.getAuthnStatements(idpConfig, assertionData, authnInstant);
        SAML2Assertion assertion = SAML2DataFactory.getInstance().createSAML2Assertion(assertionid, issueInstant, idpNameID, statements);
        if (LOCATION.beInfo()) {
            LOCATION.infoT("Issued assertion with assertion id {0}, issuer {1}, issue instant {2} ", new Object[]{assertionid, idpNameID, issueInstant});
        }
        if ((attributeStatements = this.getAttributeStatements((SAML2TrustedSP)spConfig, assertionData)) != null && attributeStatements.size() > 0) {
            assertion.setAttributeStatements(attributeStatements);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Attribute statement(s) added to assertion with id {0} and issuer {1}", new Object[]{assertionid, idpConfig != null ? idpConfig.getName() : null});
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("No attribute statement(s) configured for assertion with id {0} and issuer {1}", new Object[]{assertionid, idpConfig != null ? idpConfig.getName() : null});
        }
        String responseLocation = this.getResponseLocation(authnRequest, (SAML2TrustedSP)spConfig, destinationUrl, binding);
        Date notOnOrAfter = null;
        Date notBefore = null;
        if (idpConfig != null) {
            notOnOrAfter = new Date(issueInstant.getTime() + (long)(idpConfig.getAssertionValidityNotAfterInMinutes() * 60) * 1000L);
            notBefore = new Date(issueInstant.getTime() - (long)(idpConfig.getAssertionValidityNotBeforeInMinutes() * 60) * 1000L);
            assertion.setConditionsNotOnOrAfter(notOnOrAfter);
            assertion.setConditionsNotBefore(notBefore);
        }
        String authnRequestId = null;
        if (authnRequest != null) {
            authnRequestId = authnRequest.getID();
        }
        List<SAML2SubjectConfirmation> confirmation = this.getSubjectConfirmation(authnRequestId, responseLocation, notOnOrAfter);
        assertion.setSubjectConfirmations(confirmation);
        ArrayList<String> audiences = new ArrayList<String>(1);
        audiences.add(spName);
        assertion.setConditionsAudienceRestriction(audiences);
        SAML2ProxyRestriction saml2ProxyRestriction = assertionData.getSaml2ProxyRestriction();
        if (saml2ProxyRestriction != null) {
            assertion.setConditionsProxyRestriction(saml2ProxyRestriction);
        }
        String nameIDValue = assertionData.getNameId();
        SAML2NameID subjectNameID = SAML2DataFactory.getInstance().createSAML2NameID(nameIDValue);
        String nameIDFormat = this.getNameIdFormat((SAML2TrustedSP)spConfig, assertionData);
        subjectNameID.setFormat(nameIDFormat);
        subjectNameID.setNameQualifier(assertionData.getNameQualifier());
        subjectNameID.setSPNameQualifier(assertionData.getSPNameQualifier());
        subjectNameID.setSPProvidedID(assertionData.getSPProvidedID());
        EncryptionOption encOpt = spConfig.getAuthnResponseElementsToEncrypt();
        boolean bl = encryptSubjectNameID = EncryptionOption.SUBJECT_NAME_ID.equals((Object)encOpt) || EncryptionOption.SUBJECT_NAME_ID_AND_ATTRIBUTES.equals((Object)encOpt);
        if (encryptSubjectNameID) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Encryption of assertion name id is configured.");
            }
            assertion.setEncryptedSubjectNameID(this.encryptAssertionNameId((SAML2TrustedSP)spConfig, subjectNameID));
        } else {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Encryption of assertion name id is not configured.");
            }
            assertion.setSubjectNameID(subjectNameID);
        }
        SignatureOption signatureOption = spConfig.isToSignAssertions();
        boolean signAssertion = this.requireSignature(signatureOption, SAML2Binding.HTTP_POST_BINDING);
        if (signAssertion) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Assertion is required to be signed.");
            }
            try {
                DigestAlgorithm digestAlgorithm = spConfig.getDigestAlgorithm();
                if (digestAlgorithm != null) {
                    assertion.setDigestAlgorithm(digestAlgorithm.getName());
                }
                if (idpConfig != null) {
                    if (idpConfig.isToIncludeCertInSignature()) {
                        assertion.sign(idpConfig.getPrivateKeyForSignature(), idpConfig.getCertificateForSignature());
                    } else {
                        assertion.sign(idpConfig.getPrivateKeyForSignature());
                    }
                }
            }
            catch (SAML2ConfigurationException e) {
                this.throwErrorResponseException(authnRequest, e, "Could not load Identity Provider certificate for signature.");
            }
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Assertion is successfully signed.");
            }
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("Assertion is not required to be signed.");
        }
        ArrayList<Object> assertions = new ArrayList<Object>(1);
        boolean bl2 = encryptAssertion = encOpt == EncryptionOption.WHOLE_ASSERTION;
        if (encryptAssertion) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Encryption of assertion is configured.");
            }
            try {
                assertions.add(this.encryptAssertion((SAML2TrustedSP)spConfig, assertion));
            }
            catch (SAML2ConfigurationException e) {
                this.throwErrorResponseException(authnRequest, e, "Identity Provider could not process the authentication request received.");
            }
        } else {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Encryption of assertion is NOT configured.");
            }
            assertions.add(assertion);
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Assertion created: {0}", new Object[]{assertion.toString()});
        }
        String responseID = SAML2IDGenerator.generateSSOResponseID();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Generated response id {0}", new Object[]{responseID});
        }
        SAML2Response samlResponse = null;
        try {
            String resultMessage = "urn:oasis:names:tc:SAML:2.0:status:Success";
            samlResponse = SAML2ProtocolFactory.getInstance().createResponse(responseID, resultMessage, issueInstant, assertions);
        }
        catch (SAML2Exception e) {
            throw new SAML2Exception("Error occurred while creating SAML2 response", (Throwable)e);
        }
        samlResponse.setDestination(responseLocation);
        samlResponse.setInResponseTo(authnRequestId);
        samlResponse.setIssuer(idpNameID);
        this.signSAML2Response(idpConfig, (SAML2TrustedSP)spConfig, binding, samlResponse, authnRequest);
        return samlResponse;
    }

    private void throwErrorResponseException(SAML2AuthRequest authnRequest, SAML2ConfigurationException e, String message) throws SAML2ErrorResponseException, SAML2ConfigurationException {
        if (authnRequest == null || authnRequest.getIssuer() == null) {
            throw new IllegalStateException("SAML2 Error Response Exception cannot be thrown without authencation request or issuer");
        }
        SAML2NameID issuer = authnRequest.getIssuer();
        String issuerName = issuer.getName();
        SAML2ErrorResponseDetails details = new SAML2ErrorResponseDetails(authnRequest.getID(), issuerName, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, message);
        throw new SAML2ErrorResponseException(message, (Throwable)e, details);
    }

    private SAML2EncryptedNameID encryptAssertionNameId(SAML2TrustedSP spConfig, SAML2NameID subjectNameID) throws SAML2Exception, SAML2ConfigurationException {
        SAML2EncryptedNameID encryptedNameId = null;
        PublicKey pubKey = spConfig.getPublicKeyForEncryption();
        if (pubKey == null) {
            LOCATION.errorT("Encryption of assertion name id is configured, but there is no public key for encryption configured in the configuration for trusted service provider {0}.", new Object[]{spConfig.getName()});
            throw new SAML2ConfigurationException("Encryption of assertion name id is configured, but there is no public key for encryption configured in the configuration.");
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Found public key for encryption for service provider {0}", new Object[]{spConfig.getName()});
        }
        String encryptionAlgorithmName = null;
        EncryptionAlgorithm encryptionAlgorithm = spConfig.getEncryptionAlgorithm();
        if (encryptionAlgorithm != null) {
            encryptionAlgorithmName = encryptionAlgorithm.getName();
        }
        if (encryptionAlgorithmName == null) {
            LOCATION.errorT("Encryption of assertion name id is configured, but there is no encryption algorithm specified in the configuration for trusted service provider {0}.", new Object[]{spConfig.getName()});
            throw new SAML2ConfigurationException("Encryption of assertion name id is configured, but there is no encryption algorithm specified in the configuration.");
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Encryption algorithm found {0} for service provider {1}", new Object[]{encryptionAlgorithmName, spConfig.getName()});
        }
        encryptedNameId = subjectNameID.encrypt((Key)pubKey, encryptionAlgorithmName);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Assertion name id in assertion is encrypted with algorithm {0}", new Object[]{encryptionAlgorithm});
        }
        return encryptedNameId;
    }

    private SAML2EncryptedAssertion encryptAssertion(SAML2TrustedSP spConfig, SAML2Assertion assertion) throws SAML2Exception, SAML2ConfigurationException {
        SAML2EncryptedAssertion encryptedAssertion = null;
        PublicKey pubKey = spConfig.getPublicKeyForEncryption();
        if (pubKey == null) {
            LOCATION.errorT("Encryption of assertion is configured, but there is no public key for encryption configured in the configuration for trusted service provider {0}", new Object[]{spConfig.getName()});
            throw new SAML2ConfigurationException("Encryption of assertion is configured, but there is is no public key for encryption configured in the configuration.");
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Found public key for encryption for service provider {0}", new Object[]{spConfig.getName()});
        }
        String encryptionAlgorithmName = null;
        EncryptionAlgorithm encryptionAlgorithm = spConfig.getEncryptionAlgorithm();
        if (encryptionAlgorithm != null) {
            encryptionAlgorithmName = encryptionAlgorithm.getName();
        }
        if (encryptionAlgorithmName == null) {
            LOCATION.errorT("Encryption of assertion is configured, but there is no encryption algorithm specified in the configuration for trusted service provider {0}", new Object[]{spConfig.getName()});
            throw new SAML2ConfigurationException("Encryption of assertion is configured, but there is no encryption algorithm specified in the configuration.");
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Encryption algorithm found {0} for service provider {1}", new Object[]{encryptionAlgorithmName, spConfig.getName()});
        }
        encryptedAssertion = assertion.encrypt((Key)pubKey, encryptionAlgorithmName);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Assertion is encrypted with algorithm {0}", new Object[]{encryptionAlgorithm});
        }
        return encryptedAssertion;
    }

    private List<SAML2AttributeStatement> getAttributeStatements(SAML2TrustedSP spConfig, AssertionData assertionData) throws SAML2Exception, SAML2ConfigurationException {
        ArrayList<SAML2AttributeStatement> attributeStatements = null;
        Map<String, Collection<String>> attributes = assertionData.getAttributes();
        if (attributes != null && attributes.size() > 0) {
            boolean encryptAttributes;
            ArrayList<Object> attributeList = new ArrayList<Object>(attributes.size());
            for (String key : attributes.keySet()) {
                if (key == null) continue;
                ArrayList<String> attributeValues = null;
                SAML2Attribute attribute = SAML2DataFactory.getInstance().createSAML2Attribute(key);
                if (attributes.get(key) != null) {
                    attributeValues = new ArrayList<String>(attributes.get(key));
                }
                attribute.setAttributeValues(attributeValues);
                attributeList.add(attribute);
            }
            EncryptionOption encOpt = spConfig.getAuthnResponseElementsToEncrypt();
            boolean bl = encryptAttributes = encOpt == EncryptionOption.ATTRIBUTES || encOpt == EncryptionOption.SUBJECT_NAME_ID_AND_ATTRIBUTES;
            if (encryptAttributes) {
                PublicKey pubKey = spConfig.getPublicKeyForEncryption();
                if (pubKey == null) {
                    LOCATION.errorT("Encryption of SAML2 attributes is configured for trusted service provider {0}, but there is no public key for encryption configured in the configuration.", new Object[]{spConfig.getName()});
                    throw new SAML2ConfigurationException("Encryption of SAML2 attributes is configured, but there is is no public key for encryption configured in the configuration.");
                }
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Found public key for encryption for trusted service provider {0}", new Object[]{spConfig.getName()});
                }
                String encryptionAlgorithmName = null;
                EncryptionAlgorithm encryptionAlgorithm = spConfig.getEncryptionAlgorithm();
                if (encryptionAlgorithm != null) {
                    encryptionAlgorithmName = encryptionAlgorithm.getName();
                }
                if (encryptionAlgorithmName == null) {
                    LOCATION.errorT("Encryption of SAML2 attributes is configured for trusted service provider {0}, but there is no encryption algorithm specified in the configuration.", new Object[]{spConfig.getName()});
                    throw new SAML2ConfigurationException("Encryption of SAML2 attributes is configured, but there is no encryption algorithm specified in the configuration.");
                }
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Encryption algorithm found {0} for trusted service provider {1}", new Object[]{encryptionAlgorithmName, spConfig.getName()});
                }
                int i = 0;
                while (i < attributeList.size()) {
                    SAML2Attribute attribute = (SAML2Attribute)attributeList.get(i);
                    attributeList.set(i, attribute.encrypt((Key)pubKey, encryptionAlgorithmName));
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("SAML2 attribute {0} encrypted.", new Object[]{attribute});
                    }
                    ++i;
                }
            }
            if (attributeList.size() > 0) {
                attributeStatements = new ArrayList<SAML2AttributeStatement>(1);
                SAML2AttributeStatement newAttributeStatement = SAML2DataFactory.getInstance().createSAML2AttributeStatement(attributeList);
                attributeStatements.add(newAttributeStatement);
            }
        }
        return attributeStatements;
    }

    private String getNameIdFormat(SAML2TrustedSP spConfig, AssertionData assertionData) throws SAML2ConfigurationException {
        SAML2NameIdFormat defaultNameIdFormat;
        String nameIDFormat = assertionData.getNameIdFormat();
        if ((nameIDFormat == null || nameIDFormat.length() == 0) && (defaultNameIdFormat = spConfig.getDefaultNameIdFormat()) != null) {
            nameIDFormat = defaultNameIdFormat.getName();
        }
        if (nameIDFormat == null || nameIDFormat.length() == 0) {
            nameIDFormat = SAML2NameIdFormat.UNSPECIFIED.getName();
            LOCATION.debugT("There is no name id format specified in the assertion data or the configuration for trusted service provider {0}. Will use default value {1}.", new Object[]{spConfig.getName(), nameIDFormat});
        }
        return nameIDFormat;
    }

    private List<SAML2AuthnStatement> getAuthnStatements(SAML2LocalIdP idpConfig, AssertionData assertionData, Date authnInstant) {
        Date sessionNotOnOrAfter;
        ArrayList<SAML2AuthnStatement> statements = new ArrayList<SAML2AuthnStatement>(1);
        SAML2AuthnStatement authnStatement = SAML2DataFactory.getInstance().createSAML2AuthnStatement(authnInstant);
        String sessionIndex = assertionData.getSessionIndex();
        authnStatement.setSessionIndex(sessionIndex);
        List<String> authenticatingAuthorities = assertionData.getAuthenticatingAuthorities();
        if (authenticatingAuthorities != null) {
            authnStatement.setAuthenticatingAuthorities(authenticatingAuthorities);
        }
        if ((sessionNotOnOrAfter = assertionData.getSessionNotOnOrAfter()) == null && idpConfig != null) {
            sessionNotOnOrAfter = new Date(authnInstant.getTime() + (long)(idpConfig.getGlobalSessionLifetimeInSeconds() * 1000));
        }
        authnStatement.setSessionNotOnOrAfter(sessionNotOnOrAfter);
        String authnContext = assertionData.getAuthenticationContext();
        if (authnContext == null) {
            authnContext = "urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession";
        }
        authnStatement.setAuthnContextClassRef(authnContext);
        statements.add(authnStatement);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Authentication statement created with session index:{0}, authentication context: {1}, sessionNotOnOrAfter: {2}", new Object[]{sessionIndex, authnContext, sessionNotOnOrAfter});
        }
        return statements;
    }

    private List<SAML2SubjectConfirmation> getSubjectConfirmation(String authnRequestId, String responseLocation, Date notOnOrAfter) throws SAML2Exception {
        SAML2SubjectConfirmationData subjectConfirmationData = SAML2DataFactory.getInstance().createSAML2SubjectConfirmationData();
        subjectConfirmationData.setInResponseTo(authnRequestId);
        subjectConfirmationData.setRecipient(responseLocation);
        subjectConfirmationData.setNotOnOrAfter(notOnOrAfter);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Subject confirmation data created with InResponseTo {0}, recipient {1}, notOnOrAfter {2}", new Object[]{authnRequestId, responseLocation, notOnOrAfter});
        }
        SAML2SubjectConfirmation conf = SAML2DataFactory.getInstance().createSAML2SubjectConfirmation("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        conf.setSubjectConfirmationData(subjectConfirmationData);
        ArrayList<SAML2SubjectConfirmation> list = new ArrayList<SAML2SubjectConfirmation>(1);
        list.add(conf);
        return list;
    }

    private SAML2Response createErrorResponse(SAML2IdPConfiguration configuration, SAML2ErrorResponseDetails errorResponseDetails, SAML2AuthRequest authnRequest) throws SAML2Exception, SAML2ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration parameter is null.");
        }
        if (errorResponseDetails == null) {
            throw new IllegalArgumentException("errorResponseDetails parameter is null.");
        }
        String requestId = errorResponseDetails.getOriginalRequestId();
        if (authnRequest != null && requestId != null && !requestId.equals(authnRequest.getID())) {
            throw new SAML2ConfigurationException("The authentication request id provided in error details is not the same as the id of the authentication request.");
        }
        String issuer = errorResponseDetails.getOriginalRequestIssuer();
        String topLevelStatusCode = errorResponseDetails.getStatusCode();
        String secondLevelStatusCode = errorResponseDetails.getSecondLevelStatusCode();
        String statusMsg = errorResponseDetails.getStatusMsg();
        Date issueInstant = new Date(System.currentTimeMillis());
        String responseID = SAML2IDGenerator.generateSSOResponseID();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Generated response id {0}", new Object[]{responseID});
        }
        SAML2Response errorResponse = null;
        try {
            errorResponse = SAML2ProtocolFactory.getInstance().createResponse(responseID, topLevelStatusCode, issueInstant, null);
        }
        catch (SAML2Exception e) {
            throw new SAML2Exception("Error occurred while creating authentication error response", (Throwable)e);
        }
        SAML2LocalIdP idpConfig = IdPUtils.getLocalIdP(configuration);
        SAML2TrustedSP spConfig = IdPUtils.getTrustedSP(configuration, issuer);
        String destination = this.getResponseLocation(authnRequest, spConfig, null, SAML2Binding.HTTP_POST_BINDING);
        errorResponse.setSecondLevelStatusCode(secondLevelStatusCode);
        errorResponse.setDestination(destination);
        errorResponse.setConsent("urn:oasis:names:tc:SAML:2.0:consent:unspecified");
        errorResponse.setInResponseTo(requestId);
        errorResponse.setIssuer(SAML2DataFactory.getInstance().createSAML2NameID(idpConfig.getName()));
        errorResponse.setStatusMessage(statusMsg);
        try {
            this.signSAML2Response(idpConfig, spConfig, SAML2Binding.HTTP_POST_BINDING, errorResponse, authnRequest);
        }
        catch (SAML2ErrorResponseException e) {
            LOCATION.traceThrowableT(400, "Unable to sign the error response!", (Throwable)e);
        }
        return errorResponse;
    }

    private void signSAML2Response(SAML2LocalIdP idpConfig, SAML2TrustedSP spConfig, SAML2Binding binding, SAML2Response response, SAML2AuthRequest authnRequest) throws SAML2Exception, SAML2ConfigurationException {
        SignatureOption signatureOption = spConfig.isToSignAuthnResponses();
        boolean signResponse = this.requireSignature(signatureOption, binding);
        if (signResponse) {
            try {
                DigestAlgorithm digestAlgorithm = spConfig.getDigestAlgorithm();
                if (digestAlgorithm != null) {
                    response.setDigestAlgorithm(digestAlgorithm.getName());
                }
                if (idpConfig.isToIncludeCertInSignature()) {
                    response.sign(idpConfig.getPrivateKeyForSignature(), idpConfig.getCertificateForSignature());
                } else {
                    response.sign(idpConfig.getPrivateKeyForSignature());
                }
            }
            catch (SAML2ConfigurationException e) {
                this.throwErrorResponseException(authnRequest, e, "Could not load Identity Provider certificate for signature.");
            }
        }
    }

    private boolean requireSignature(SignatureOption signatureOption, SAML2Binding binding) {
        boolean requireSignature = false;
        boolean treatBindingAsFrontChannel = false;
        treatBindingAsFrontChannel = binding.usesFrontChannel() ? !binding.equals((Object)SAML2Binding.HTTP_ARTIFACT_BINDING) : false;
        requireSignature = treatBindingAsFrontChannel ? signatureOption.equals((Object)SignatureOption.ALWAYS) || signatureOption.equals((Object)SignatureOption.FRONT_CHANNEL_ONLY) : signatureOption.equals((Object)SignatureOption.ALWAYS);
        return requireSignature;
    }

    private String getResponseLocation(SAML2AuthRequest authnRequest, SAML2TrustedSP spConfig, String destinationUrl, SAML2Binding binding) throws SAML2ConfigurationException {
        String responseLocation = null;
        if (authnRequest != null) {
            Integer index = authnRequest.getAssertionConsumerServiceIndex();
            if (index == null) {
                String acsURL = authnRequest.getAssertionConsumerServiceURL();
                responseLocation = acsURL != null && acsURL.length() > 0 ? acsURL : (destinationUrl != null && destinationUrl.length() > 0 ? destinationUrl : IdPUtils.getACSLocation(spConfig, binding));
            } else {
                SAML2Endpoint endpoint = spConfig.getAssertionConsumerEndpoint(index.intValue());
                if (endpoint == null) {
                    throw new SAML2ConfigurationException("No endpoint with index: " + index + " specified in configuration for the trusted service provider " + spConfig.getName());
                }
                responseLocation = endpoint.getResponseLocation();
                if (responseLocation == null || responseLocation.length() == 0) {
                    responseLocation = endpoint.getLocation();
                }
            }
        } else {
            responseLocation = destinationUrl != null && destinationUrl.length() > 0 ? destinationUrl : IdPUtils.getACSLocation(spConfig, binding);
        }
        if (responseLocation == null || responseLocation.length() == 0) {
            throw new SAML2ConfigurationException("Cannot get response location neither from authentication request, nor from the configuration for the trusted service provider  " + spConfig.getName() + ". Specified destination url: " + destinationUrl);
        }
        return responseLocation;
    }

    String createSSOResponseHttpBody(SAML2Response response, String relayState) throws SAML2Exception {
        if (response == null) {
            throw new IllegalArgumentException("response parameter is null.");
        }
        String xmlResponse = response.generate();
        LOCATION.debugT("Generated SSO Response: " + xmlResponse);
        return HTTPPostBinding.generateResponseForm((String)xmlResponse, (String)relayState, (String)response.getDestination(), null);
    }
}

