/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp.sso;

import com.sap.security.saml2.cfg.enums.EncryptionOption;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2SPConfiguration;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedProvider;
import com.sap.security.saml2.commons.IdPProxyContext;
import com.sap.security.saml2.commons.SAML2CommonServicesManager;
import com.sap.security.saml2.lib.assertions.SAML2AssertionJxbImpl;
import com.sap.security.saml2.lib.attributes.AttributeValues;
import com.sap.security.saml2.lib.common.SAML2DataFactoryJxb;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2JAXBUtils;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.SAML2SignableToken;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2AttributeStatement;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2AuthnStatement;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedAssertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2ProxyRestriction;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SubjectConfirmation;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2SubjectConfirmationData;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2Response;
import com.sap.security.saml2.lib.jaxb.assertion.AssertionType;
import com.sap.security.saml2.lib.xmlsecurity.XMLEncryptionManager;
import com.sap.security.saml2.sp.sso.LoginResult;
import com.sap.security.saml2.sp.sso.ServiceProviderUtil;
import com.sap.security.saml2.sp.sso.exception.NameIdMappingFailedException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.io.StringReader;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.login.LoginException;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

class AssertionValidationService {
    private static final Location LOCATION = Location.getLocation(AssertionValidationService.class);
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"Authentication");
    private String actualRecipientUrl;
    private String refererUrl;
    private LoginResult loginResult;
    private boolean isFrontChannelRequest;
    private boolean isSAML2ResponseSignatureValid;
    private boolean shouldValidateRecipient;
    private SAML2TrustedIdP trustedIdP;
    private SAML2LocalSP localSP;
    private SAML2Response saml2Response;
    private Set<String> acceptedMethods = new HashSet<String>();

    public AssertionValidationService(SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, String actualRecipientUrl, LoginResult loginResult, boolean isFrontChannelRequest, SAML2Response saml2Response, boolean signatureValidated, boolean shouldValidateRecipient) {
        this.acceptedMethods.add("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        this.actualRecipientUrl = actualRecipientUrl;
        this.loginResult = loginResult;
        this.isFrontChannelRequest = isFrontChannelRequest;
        this.isSAML2ResponseSignatureValid = signatureValidated;
        this.shouldValidateRecipient = shouldValidateRecipient;
        this.trustedIdP = trustedIdP;
        this.localSP = localSP;
        this.saml2Response = saml2Response;
    }

    public AssertionValidationService(SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, String actualRecipientUrl, LoginResult loginResult, boolean isFrontChannelRequest, SAML2Response saml2Response, boolean signatureValidated) {
        this(localSP, trustedIdP, actualRecipientUrl, loginResult, isFrontChannelRequest, saml2Response, signatureValidated, true);
    }

    public AssertionValidationService(SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, String actualRecipientUrl, String refererUrl, LoginResult loginResult, boolean isFrontChannelRequest, SAML2Response saml2Response, boolean signatureValidated) {
        this(localSP, trustedIdP, actualRecipientUrl, loginResult, isFrontChannelRequest, saml2Response, signatureValidated);
        this.refererUrl = refererUrl;
    }

    public SAML2Assertion validateAssertion(SAML2EncryptedAssertion encAssertion) throws LoginException {
        PrivateKey privateKey = this.getPrivateKeyForEncryption();
        SAML2Assertion decryptedAssertion = null;
        try {
            decryptedAssertion = encAssertion.decrypt((Key)privateKey);
            LOCATION.debugT("SAML2Assertion successfully decrypted.");
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(400, "SAML2Assertion received could not be decrypted.", (Throwable)e);
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000031", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that cannot be decrypted.", (Object[])new Object[]{this.trustedIdP.getName()});
            this.loginResult.throwBadCredentialException("SAML2Assertion received could not be decrypted.", e);
        }
        return this.validateAssertion(decryptedAssertion, true);
    }

    public SAML2Assertion validateAssertion(SAML2Assertion assertion) throws LoginException {
        if (this.trustedIdP.getRequiredEncryptedAuthnResponseElements() == EncryptionOption.WHOLE_ASSERTION) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Service Provider has received SAML2Assertion from Identity Provider [{0}] that is not encrypted but is required to be.", new Object[]{this.trustedIdP.getName()});
            }
            this.loginResult.throwBadCredentialException("Received SAML2Assertion is not encrypted but it is required to be encrypted.");
        }
        return this.validateAssertion(assertion, false);
    }

    public SAML2Assertion validateAssertion(String assertion, SAML2SPConfiguration configuration) throws LoginException {
        SAML2Assertion saml2Assertion = null;
        boolean isEncrypted = false;
        try {
            saml2Assertion = SAML2DataFactoryJxb.getInstance().createSAML2Assertion(assertion);
        }
        catch (SAML2Exception e) {
            LOCATION.traceThrowableT(100, "Could not parse assertion.", (Throwable)e);
            saml2Assertion = this.parseEncryptedAssertion(assertion);
            isEncrypted = true;
        }
        if (saml2Assertion == null) {
            this.loginResult.throwBadCredentialException("Could not parse received SAML2 Assertion: " + assertion);
        } else if (LOCATION.beInfo()) {
            LOCATION.infoT("SAML2 Assertion for validation:\n{0}", new Object[]{saml2Assertion.getXMLRepresentation()});
        }
        String trustedIdPName = this.trustedIdP.getName();
        if (this.trustedIdP.getRequiredEncryptedAuthnResponseElements() == EncryptionOption.WHOLE_ASSERTION && !isEncrypted) {
            if (LOCATION.beWarning()) {
                LOCATION.warningT("Service Provider has received SAML2Assertion from Identity Provider [{0}] that is not encrypted but is required to be.", new Object[]{trustedIdPName});
            }
            this.loginResult.throwBadCredentialException("Received SAML2Assertion is not encrypted but it is required to be encrypted.");
        }
        this.loginResult.setIdpName(trustedIdPName);
        return this.validateAssertion(saml2Assertion, isEncrypted);
    }

    public SAML2Assertion parseEncryptedAssertion(String assertion) {
        SAML2AssertionJxbImpl saml2Assertion = null;
        try {
            LOCATION.debugT("Trying to parse encrypted assertion.");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            InputSource inputSource = new InputSource(new StringReader(assertion));
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document sourceDoc = db.parse(inputSource);
            Element encryptedDOM = sourceDoc.getDocumentElement();
            PrivateKey privateKey = this.getPrivateKeyForEncryption();
            Node decryptedDOMNode = XMLEncryptionManager.getXMLEncryptionInstance().decrypt(encryptedDOM, (Key)privateKey);
            Element decryptedDOMElement = (Element)decryptedDOMNode;
            JAXBElement decryptedAssertion = SAML2JAXBUtils.unmarshalAssertionTokenFromDOM((Element)decryptedDOMElement);
            LOCATION.debugT("Assertion successfully decrypted.");
            saml2Assertion = new SAML2AssertionJxbImpl((AssertionType)decryptedAssertion.getValue(), decryptedDOMElement);
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(100, "Could not parse assertion as encrypted assertion.", (Throwable)e);
        }
        return saml2Assertion;
    }

    private SAML2Assertion validateAssertion(SAML2Assertion assertion, boolean isAssertionEncrypted) throws LoginException {
        if (LOCATION.bePath()) {
            LOCATION.entering("validateAssertion");
        }
        this.checkVersion(assertion);
        this.checkId(assertion);
        this.checkValidity(assertion);
        this.checkSubjectConfirmations(assertion);
        this.checkAudience(assertion);
        this.checkForUnknownConditions(assertion);
        this.checkAlreadyConsumed(assertion);
        this.checkIssuer(assertion);
        this.checkSignature(assertion);
        SAML2AuthnStatement authnStatement = this.getAuthnStatement(assertion);
        String authnContext = this.getAuthnContext(authnStatement);
        SAML2NameID subjectNameID = this.getSubjectNameId(assertion, isAssertionEncrypted);
        String subjectName = subjectNameID.getName();
        String subjectNameIdFormat = subjectNameID.getFormat();
        if (subjectNameIdFormat == null || subjectNameIdFormat.length() == 0) {
            subjectNameIdFormat = SAML2NameIdFormat.UNSPECIFIED.getName();
            LOCATION.debugT("Subject NameIdFormat is not specified in the SAML2Assertion. NameIdFormat [unspecified] is used.");
        }
        String subjectNameIdSPNameQualifier = subjectNameID.getSPNameQualifier();
        String subjectNameQualifier = subjectNameID.getNameQualifier();
        this.checkAttributeEncryptionRequirements(assertion, isAssertionEncrypted);
        this.hasEncryptedAttributes(assertion);
        this.checkAffiliation(subjectNameID);
        String sessionIndex = this.getSessionIndex(authnStatement);
        String clientId = ServiceProviderUtil.composeClientContextAlias(sessionIndex, this.localSP.getName(), this.trustedIdP.getName());
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Generated Cluster-wide Client ID: {0}", new Object[]{clientId});
        }
        Date sessionNotOnOrAfter = authnStatement.getSessionNotOnOrAfter();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SessionNotOnOrAfter in SAML2Assertion: {0}", new Object[]{sessionNotOnOrAfter});
        }
        IdPProxyContext idpProxyContext = this.getIdPProxyContext(assertion, authnStatement);
        AttributeValues assertionAttributes = this.getAssertionAttributes(assertion);
        this.loginResult.setAuthenticationContext(authnContext);
        this.loginResult.setPrincipalNameId(subjectName);
        this.loginResult.setPrincipalNameIdFormat(subjectNameIdFormat);
        this.loginResult.setNameIdSPProvidedId(subjectNameID.getSPProvidedID());
        this.loginResult.setSubjectNameIdSPNameQualifier(subjectNameIdSPNameQualifier);
        this.loginResult.setSubjectNameIdNameQualifier(subjectNameQualifier);
        this.loginResult.setAssertionAttributes(assertionAttributes);
        this.loginResult.setClusterWideClientID(clientId);
        this.loginResult.setSessionIndex(sessionIndex);
        this.loginResult.setSessionNotOnOrAfter(sessionNotOnOrAfter);
        this.loginResult.setIdpProxyContext(idpProxyContext);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SAML2Assertion successfully validated: \n{0}", new Object[]{assertion.getXMLRepresentation()});
        }
        if (LOCATION.bePath()) {
            LOCATION.exiting("validateAssertion");
        }
        return assertion;
    }

    private AttributeValues getAssertionAttributes(SAML2Assertion assertion) throws LoginException, NameIdMappingFailedException {
        AttributeValues assertionAttributes = null;
        try {
            assertionAttributes = SAML2Utils.extractAttributeValues((SAML2Assertion)assertion, null);
            this.loginResult.getAuditData().setAttrValues(assertionAttributes);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("SAML2Assertion attributes received: {0}", new Object[]{assertionAttributes});
            }
        }
        catch (SAML2Exception e) {
            LOCATION.traceThrowableT(500, "Could not extract attributes from SAML2Assertion.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000030", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] but could not extract its attributes. Reason: {1}", (Object[])new Object[]{this.trustedIdP.getName(), e.getMessage()});
            this.loginResult.throwNameIDMappingFailedException("Could not extract assertion attributes. " + e.getMessage(), e);
        }
        return assertionAttributes;
    }

    private void checkValidity(SAML2Assertion assertion) throws LoginException {
        Date condNotAfter;
        Date now = Calendar.getInstance().getTime();
        long currentTime = now.getTime();
        int clockSkewToleranceInMillis = this.localSP.getClockSkewToleranceInSeconds() * 1000;
        Date condNotBefore = assertion.getConditionsNotBefore();
        if (condNotBefore != null && currentTime + (long)clockSkewToleranceInMillis < condNotBefore.getTime()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000039", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that is not yet valid. ConditionsNotBefore: [{1}], current time: [{2}].", (Object[])new Object[]{this.trustedIdP.getName(), condNotBefore, now});
            this.loginResult.throwBadCredentialException("SAML2Assertion is not yet valid.");
        }
        if ((condNotAfter = assertion.getConditionsNotOnOrAfter()) != null && currentTime - (long)clockSkewToleranceInMillis > condNotAfter.getTime()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000038", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that has expired. ConditionsNotOnOrAfter: [{1}], current time: [{2}].", (Object[])new Object[]{this.trustedIdP.getName(), condNotAfter, now});
            this.loginResult.throwBadCredentialException("SAML2Assertion has expired.");
        }
    }

    private void checkSubjectConfirmations(SAML2Assertion assertion) throws LoginException {
        boolean isSubjectDataValid = false;
        Date now = Calendar.getInstance().getTime();
        long currentTime = now.getTime();
        int clockSkewToleranceInMillis = this.localSP.getClockSkewToleranceInSeconds() * 1000;
        List subjectData = assertion.getSubjectConfirmations();
        for (SAML2SubjectConfirmation subjectConf : subjectData) {
            String recipientUrl;
            if (!this.acceptedMethods.contains(subjectConf.getMethod())) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000090", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that contains SubjectConfirmation method [{1}] which is not supported. Supported methods: {2}", (Object[])new Object[]{this.trustedIdP.getName(), subjectConf.getMethod(), this.acceptedMethods});
                continue;
            }
            SAML2SubjectConfirmationData subjectConfData = subjectConf.getSubjectConfirmationData();
            if (subjectConfData == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000095", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that does not contain SubjectConfirmationData element inside the validated SubjectConfirmation.", (Object[])new Object[]{this.trustedIdP.getName()});
                continue;
            }
            String inResponseTo = subjectConfData.getInResponseTo();
            boolean inResponseToCorresponds = false;
            if (this.saml2Response != null && !(inResponseToCorresponds = this.saml2Response.getInResponseTo() == null ? inResponseTo == null : this.saml2Response.getInResponseTo().equals(inResponseTo))) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000085", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that contains InResponseTo [{1}] not corresponding to the SAML2Response InResponseTo [{2}].", (Object[])new Object[]{this.trustedIdP.getName(), inResponseTo, this.saml2Response.getInResponseTo()});
                this.loginResult.throwBadCredentialException("SAML2Assertion InResponseTo does not correspond to the SAML2Response InResponseTo.");
            }
            Date confDataNotBefore = subjectConfData.getNotBefore();
            Date confDataNotAfter = subjectConfData.getNotOnOrAfter();
            boolean isHOK = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(subjectConf.getMethod());
            if (confDataNotBefore != null && currentTime + (long)clockSkewToleranceInMillis < confDataNotBefore.getTime()) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000058", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] whose subject confirmation is not yet valid. ConditionsNotBefore: [{1}], current time: [{2}].", (Object[])new Object[]{this.trustedIdP.getName(), confDataNotBefore, now});
                continue;
            }
            if (confDataNotAfter == null) {
                if (!isHOK) {
                    SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000037", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that does not specify SubjectConfDataNotOnOrAfter.", (Object[])new Object[]{this.trustedIdP.getName()});
                    this.loginResult.throwBadCredentialException("SAML2Assertion does not specify SubjectConfDataNotOnOrAfter.");
                }
            } else if (currentTime - (long)clockSkewToleranceInMillis > confDataNotAfter.getTime()) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000057", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] whose subject confirmation has expired. ConditionsNotOnOrAfter: [{1}], current time: [{2}].", (Object[])new Object[]{this.trustedIdP.getName(), confDataNotAfter, now});
                continue;
            }
            if ("urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConf.getMethod()) && this.isFrontChannelRequest && this.shouldValidateRecipient && !ServiceProviderUtil.checkRecipientUrl(recipientUrl = subjectConfData.getRecipient(), this.actualRecipientUrl) && (this.refererUrl == null || !ServiceProviderUtil.checkRecipientUrl(recipientUrl, this.refererUrl))) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000081", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] whose recipient URL [{1}] does not match requested URL [{2}].", (Object[])new Object[]{this.trustedIdP.getName(), recipientUrl, this.actualRecipientUrl});
                continue;
            }
            isSubjectDataValid = true;
            if (confDataNotAfter == null) break;
            this.loginResult.setSubjectConfirmationNotOnOrAfter(new Date(confDataNotAfter.getTime() + (long)clockSkewToleranceInMillis));
            break;
        }
        if (!isSubjectDataValid) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000041", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] but none of its subject confirmations is valid.", (Object[])new Object[]{this.trustedIdP.getName()});
            this.loginResult.throwBadCredentialException("None of the subject confirmations in the SAML2Assertion is valid.");
        }
    }

    private void checkSignature(SAML2Assertion assertion) throws LoginException {
        if (assertion.isSigned()) {
            try {
                SAML2CommonServicesManager.getInstance().getSignatureValidator().validateSignature((SAML2SignableToken)assertion, (SAML2LocalProvider)this.localSP, (SAML2TrustedProvider)this.trustedIdP);
            }
            catch (SAML2Exception e) {
                LOCATION.traceThrowableT(500, "Signature validation of SAML2Assertion failed.", (Throwable)e);
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000042", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that has invalid signature.", (Object[])new Object[]{this.trustedIdP.getName()});
                this.loginResult.throwBadCredentialException("Signature validation of SAML2Assertion failed.", e);
            }
            catch (SAML2ConfigurationException e) {
                LOCATION.traceThrowableT(500, "Cannot read trusted Identity Provider certificate for signature.", (Throwable)e);
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000110", (String)"Service Provider cannot read trusted Identity Provider [{0}] certificate for signature from configuration.", (Object[])new Object[]{this.trustedIdP.getName()});
                this.loginResult.throwLoginFailedException("Cannot read trusted Identity Provider certificate for signature.", e);
            }
        } else if (this.trustedIdP.isToRequireSignedAssertions() == SignatureOption.ALWAYS || this.trustedIdP.isToRequireSignedAssertions() == SignatureOption.FRONT_CHANNEL_ONLY && this.isFrontChannelRequest) {
            if (this.isSAML2ResponseSignatureValid) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Service Provider has received SAML2Assertion from Identity Provider [{0}] that is not signed but the SAML2Response has valid signature and the SAML2Assertion inherits its signature.", new Object[]{this.trustedIdP.getName()});
                }
            } else if (this.saml2Response != null && this.saml2Response.isParentSAML2TokenSignatureVerified()) {
                LOCATION.debugT("Service Provider has received SAML2Assertion from Identity Provider [{0}] that is not signed but the ArtifactResponse has valid signature and the SAML2Assertion inherits its signature.", new Object[]{this.trustedIdP.getName()});
            } else {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000043", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that is not signed.", (Object[])new Object[]{this.trustedIdP.getName()});
                this.loginResult.throwBadCredentialException("SAML2Assertion is not signed but it is required to be signed.");
            }
        }
    }

    private void checkIssuer(SAML2Assertion assertion) throws LoginException {
        SAML2NameID issuerNameId = assertion.getIssuer();
        if (issuerNameId == null || issuerNameId.getName() == null || issuerNameId.getName().length() == 0) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000044", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that does not specify an issuer.", (Object[])new Object[]{this.trustedIdP.getName()});
            this.loginResult.throwBadCredentialException("SAML2Assertion does not specify an issuer.");
        } else if (!issuerNameId.getName().equalsIgnoreCase(this.loginResult.getIdpName())) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000045", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] whose issuer [{1}] does not match the SAML2Response issuer [{2}].", (Object[])new Object[]{this.trustedIdP.getName(), issuerNameId.getName(), this.trustedIdP.getName()});
            this.loginResult.throwBadCredentialException("SAML2Assertion issuer does not match SAML2Response issuer.");
        }
    }

    private SAML2NameID getSubjectNameId(SAML2Assertion assertion, boolean wasAssertionEncrypted) throws LoginException {
        EncryptionOption encRequirement = this.trustedIdP.getRequiredEncryptedAuthnResponseElements();
        SAML2EncryptedNameID encNameId = assertion.getEncryptedSubjectNameID();
        SAML2NameID subjectNameID = null;
        if (encNameId != null) {
            PrivateKey privateKey = this.getPrivateKeyForEncryption();
            try {
                subjectNameID = encNameId.decrypt((Key)privateKey);
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Subject NameID [{0}] successfully decrypted.", new Object[]{subjectNameID});
                }
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(400, "Subject NameID in SAML2Assertion could not be decrypted.", (Throwable)e);
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000033", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] whose Subject Name ID could not be decrypted.", (Object[])new Object[]{this.trustedIdP.getName()});
                this.loginResult.throwBadCredentialException("Subject NameID in SAML2Assertion could not be decrypted.", e);
            }
        } else {
            if (encRequirement == EncryptionOption.SUBJECT_NAME_ID || encRequirement == EncryptionOption.SUBJECT_NAME_ID_AND_ATTRIBUTES) {
                if (!wasAssertionEncrypted) {
                    SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000034", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] whose Subject Name ID is not encrypted.", (Object[])new Object[]{this.trustedIdP.getName()});
                    this.loginResult.throwBadCredentialException("SAML2Assertion contains not encrypted Subject NameID.");
                } else if (LOCATION.beDebug()) {
                    LOCATION.debugT("Service Provider is configured to require encrypted Subject Name ID. The plain Subject Name ID is accepted because the whole assertion is encrypted");
                }
            }
            if ((subjectNameID = assertion.getSubjectNameID()) == null || subjectNameID.getName() == null) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000032", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that does not specify Subject Name ID.", (Object[])new Object[]{this.trustedIdP.getName()});
                this.loginResult.throwBadCredentialException("SAML2Assertion does not specify Subject NameID.");
            }
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Subject Name ID in SAML2Assertion: {0}", new Object[]{subjectNameID});
            }
        }
        return subjectNameID;
    }

    private void checkAffiliation(SAML2NameID subjectNameID) throws LoginException {
        if (SAML2NameIdFormat.PERSISTENT.getName().equalsIgnoreCase(subjectNameID.getFormat())) {
            String receivedAffiliation = subjectNameID.getSPNameQualifier();
            String myAffiliation = this.localSP.getAffiliation();
            if (receivedAffiliation != null && receivedAffiliation.length() != 0) {
                if (myAffiliation == null || myAffiliation.length() == 0) {
                    if (!receivedAffiliation.equalsIgnoreCase(this.localSP.getName())) {
                        SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000046", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] whose SPNameQualifier [{1}] does not match the Service Provider name [{2}].", (Object[])new Object[]{this.trustedIdP.getName(), receivedAffiliation, this.localSP.getName()});
                        this.loginResult.throwBadCredentialException("SPNameQualifier in SAML2Assertion does not match Service Provider name.");
                    } else if (LOCATION.beDebug()) {
                        LOCATION.debugT("SPNameQualifier received [{0}] matches Service Provider name [{1}].", new Object[]{receivedAffiliation, this.localSP.getName()});
                    }
                } else if (!receivedAffiliation.equalsIgnoreCase(myAffiliation)) {
                    SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000047", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] whose SPNameQualifier [{1}] does not match the Service Provider affiliation [{2}].", (Object[])new Object[]{this.trustedIdP.getName(), receivedAffiliation, myAffiliation});
                    this.loginResult.throwBadCredentialException("SPNameQualifier in SAML2Assertion does not match Service Provider affiliation.");
                } else if (LOCATION.beDebug()) {
                    LOCATION.debugT("SPNameQualifier [{0}] in SAML2Assertion matches Service Provider affiliation [{1}].", new Object[]{receivedAffiliation, myAffiliation});
                }
            } else if (myAffiliation != null && myAffiliation.length() != 0) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000048", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that does not specify the Service Provider affiliation as SPNameQualifier.", (Object[])new Object[]{this.trustedIdP.getName(), myAffiliation});
                this.loginResult.throwBadCredentialException("SAML2Assertion does not specify Service Provider affiliation.");
            }
        }
    }

    private boolean hasEncryptedAttributes(SAML2Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements != null) {
            for (SAML2AttributeStatement statement : attributeStatements) {
                List attrs = statement.getEncryptedAttributes();
                if (attrs == null || attrs.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private SAML2AuthnStatement getAuthnStatement(SAML2Assertion assertion) throws LoginException {
        List authnStatements = assertion.getAuthnStatement();
        if (authnStatements == null || authnStatements.size() == 0) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000049", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that does not contain any authentication statements.", (Object[])new Object[]{this.trustedIdP.getName()});
            this.loginResult.throwBadCredentialException("SAML2Assertion does not contain any authentication statements.");
        }
        SAML2AuthnStatement authnStatement = (SAML2AuthnStatement)authnStatements.get(0);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Authentication statement in SAML2Assertion: {0}", new Object[]{authnStatement});
        }
        return authnStatement;
    }

    private String getAuthnContext(SAML2AuthnStatement authnStatement) throws LoginException {
        String authnContext = authnStatement.getAuthnContextClassRef();
        if (authnContext == null || authnContext.length() == 0) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000050", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that does not specify an authentication context.", (Object[])new Object[]{this.trustedIdP.getName()});
            this.loginResult.throwBadCredentialException("SAML2Assertion does not specify authentication context.");
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Authentication context in SAML2Assertion: {0}", new Object[]{authnContext});
        }
        return authnContext;
    }

    private void checkAttributeEncryptionRequirements(SAML2Assertion assertion, boolean wasAssertionEncrypted) throws LoginException {
        EncryptionOption encRequirement = this.trustedIdP.getRequiredEncryptedAuthnResponseElements();
        if (encRequirement == EncryptionOption.ATTRIBUTES || encRequirement == EncryptionOption.SUBJECT_NAME_ID_AND_ATTRIBUTES) {
            if (!wasAssertionEncrypted) {
                List attributeStatements = assertion.getAttributeStatements();
                for (SAML2AttributeStatement statement : attributeStatements) {
                    List plainAttributes = statement.getAttributes();
                    if (plainAttributes == null || plainAttributes.isEmpty()) continue;
                    SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000051", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that contains not encrypted attributes.", (Object[])new Object[]{this.trustedIdP.getName()});
                    this.loginResult.throwBadCredentialException("SAML2Assertion attributes are not encrypted.");
                }
            } else {
                LOCATION.debugT("SAML2Assertion attributes are considered as encrypted because the whole SAML2Assertion is encrypted.");
            }
        }
    }

    private String getSessionIndex(SAML2AuthnStatement authnStatement) throws LoginException {
        String sessionIndex = authnStatement.getSessionIndex();
        if (sessionIndex == null || sessionIndex.length() == 0) {
            SimpleLogger.log((int)300, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000052", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] whose authentication statement does not specify session index.", (Object[])new Object[]{this.trustedIdP.getName()});
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("Session Index in SAML2Assertion: {0}", new Object[]{sessionIndex});
        }
        return sessionIndex;
    }

    private void checkAlreadyConsumed(SAML2Assertion assertion) throws LoginException {
        try {
            if (SAML2CommonServicesManager.getInstance().getConsumedAssertionService().isAlreadyConsumed(assertion)) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000028", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that is already consumed.", (Object[])new Object[]{this.trustedIdP.getName()});
                this.loginResult.throwBadCredentialException("SAML2Assertion received is already consumed.");
            }
        }
        catch (SAML2Exception e) {
            LOCATION.traceThrowableT(500, "Already consumed assertion check failed.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000029", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] but could not check whether it is already consumed. Reason: {1}", (Object[])new Object[]{this.trustedIdP.getName(), e.getMessage()});
            this.loginResult.throwBadCredentialException("Already consumed assertion check failed. " + e.getMessage(), e);
        }
    }

    private void checkAudience(SAML2Assertion assertion) throws LoginException {
        List audience = assertion.getConditionsAudienceRestriction();
        if (audience == null || !audience.contains(this.localSP.getName())) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000053", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] whose audience restriction [{1}] does not specify the current Service Provider [{2}].", (Object[])new Object[]{this.trustedIdP.getName(), audience, this.localSP.getName()});
            this.loginResult.throwBadCredentialException("Service Provider does not match specified audience in the SAML2Assertion.");
        }
    }

    private void checkForUnknownConditions(SAML2Assertion assertion) throws LoginException {
        List unknownConditions = assertion.getConditionsNonStandardDefined();
        if (unknownConditions != null && !unknownConditions.isEmpty()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000054", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that contains unknown condition(s).", (Object[])new Object[]{this.trustedIdP.getName()});
            this.loginResult.throwBadCredentialException("SAML2Assertion contains unknown condition(s).");
        }
    }

    private void checkVersion(SAML2Assertion assertion) throws LoginException {
        if (!"2.0".equalsIgnoreCase(assertion.getVersion())) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000055", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that has incorrect version: received version = [{1}], expected version = [{2}]", (Object[])new Object[]{this.trustedIdP.getName(), assertion.getVersion(), "2.0"});
            this.loginResult.throwBadCredentialException("SAML2Assertion has incorrent version.");
        }
    }

    private void checkId(SAML2Assertion assertion) throws LoginException {
        String id = assertion.getID();
        if (id == null || id.length() == 0) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000056", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that does not have an ID.", (Object[])new Object[]{this.trustedIdP.getName()});
            this.loginResult.throwBadCredentialException("SAML2Assertion does not have an ID.");
        }
    }

    public void setAcceptedMethods(Set<String> acceptedMethods) {
        this.acceptedMethods = acceptedMethods;
    }

    private PrivateKey getPrivateKeyForEncryption() throws LoginException {
        PrivateKey privateKey = null;
        try {
            privateKey = this.localSP.getPrivateKeyForEncryption();
            if (privateKey == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000109", (String)"Service Provider cannot read its private key for encryption from configuration.");
                this.loginResult.throwLoginFailedException("Service Provider cannot read its private key for encryption from configuration.");
            }
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Service Provider cannot read its private key for encryption from configuration.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000109", (String)"Service Provider cannot read its private key for encryption from configuration.");
            this.loginResult.throwLoginFailedException("Service Provider cannot read its private key for encryption from configuration.", e);
        }
        return privateKey;
    }

    public IdPProxyContext getIdPProxyContext(SAML2Assertion assertion, SAML2AuthnStatement authnStatement) {
        Integer proxyCount = null;
        List audienceRestriction = null;
        List authnAuthorities = null;
        SAML2ProxyRestriction proxyRestriction = assertion.getConditionsProxyRestriction();
        if (proxyRestriction != null) {
            proxyCount = proxyRestriction.getCount();
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Proxy count restriction in SAML2Assertion: {0}", new Object[]{proxyCount});
            }
            audienceRestriction = proxyRestriction.getAudience();
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Proxy audience restriction in SAML2Assertion: {0}", new Object[]{audienceRestriction});
            }
        }
        authnAuthorities = authnStatement.getAuthenticatingAuthorities();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Authenticating authorities in SAML2Assertion: {0}", new Object[]{authnAuthorities});
        }
        if (proxyCount != null || audienceRestriction != null || authnAuthorities != null) {
            return new IdPProxyContext(authnAuthorities, audienceRestriction, proxyCount);
        }
        return null;
    }
}

