/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp.sso;

import com.sap.security.saml2.cfg.enums.ResponseRequirementType;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.commons.AuthnContext;
import com.sap.security.saml2.commons.AuthnContextList;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2ProtocolFactory;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2AuthRequest;
import com.sap.security.saml2.sp.sso.AuthenticationRequirements;
import com.sap.security.saml2.sp.sso.exception.LoginFailedException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.security.auth.login.LoginException;

final class AuthnRequestFactory {
    private static final Location LOCATION = Location.getLocation(AuthnRequestFactory.class);
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"Authentication");

    AuthnRequestFactory() {
    }

    protected static SAML2AuthRequest createAuthnRequest(SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, String idpSSOUrl, String acsUrl, AuthenticationRequirements authnRequirements) throws LoginException {
        return AuthnRequestFactory.createAuthnRequest(localSP, trustedIdP, idpSSOUrl, acsUrl, authnRequirements, null);
    }

    protected static SAML2AuthRequest createAuthnRequest(SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, String idpSSOUrl, String acsUrl, AuthenticationRequirements authnRequirements, String requestId) throws LoginException {
        SAML2NameIdFormat nameIdFormat;
        SAML2AuthRequest samlRequest = null;
        try {
            Date now = Calendar.getInstance().getTime();
            if (requestId == null) {
                requestId = SAML2Utils.generateUUID();
            }
            samlRequest = SAML2ProtocolFactory.getInstance().createAuthnRequest(requestId, now);
            SAML2NameID nameID = SAML2DataFactory.getInstance().createSAML2NameID(localSP.getName());
            samlRequest.setIssuer(nameID);
            samlRequest.setDestination(idpSSOUrl);
            AuthnRequestFactory.setAuthRequestResponseBindings(trustedIdP, samlRequest, acsUrl);
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not create SAML2AuthnRequest.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000008", (String)"Service Provider could not create AuthnRequest. Reason: {0}", (Object[])new Object[]{e.getMessage()});
            throw new LoginFailedException("Service Provider could not create AuthnRequest.", e);
        }
        List contextNames = trustedIdP.getAuthenticationContextNames();
        AuthnContextList configuredAuthnContexts = new AuthnContextList();
        if (contextNames != null && !contextNames.isEmpty()) {
            for (String contextName : contextNames) {
                AuthnContext newContext = new AuthnContext(contextName);
                configuredAuthnContexts.add(newContext);
            }
        }
        if (configuredAuthnContexts.isEmpty()) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Authentication Contexts are not configured for the Service Provider application.");
            }
        } else {
            samlRequest.setRequestedAuthnContextClassRefs(configuredAuthnContexts.getNames());
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Authentication Contexts set in the SAML2AuthRequest: {0}", new Object[]{configuredAuthnContexts.getNames()});
            }
        }
        if ((nameIdFormat = trustedIdP.getDefaultNameIdFormat()) != null) {
            samlRequest.setNameIDPolicyFormat(nameIdFormat.getName());
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Name ID Format [{0}] set in authentication request.", new Object[]{nameIdFormat.getName()});
            }
        }
        if (trustedIdP.getRequestedNameIdPolicySPNameQualifier() != null) {
            samlRequest.setNameIDPolicySPNameQualifier(trustedIdP.getRequestedNameIdPolicySPNameQualifier());
        }
        if (trustedIdP.getRequestedNameIdPolicyAllowCreate() != null) {
            samlRequest.setNameIDPolicyAllowCreate(trustedIdP.getRequestedNameIdPolicyAllowCreate().booleanValue());
        }
        if (authnRequirements != null) {
            if (authnRequirements.getNameIdPolicyFormat() != null) {
                samlRequest.setNameIDPolicyFormat(authnRequirements.getNameIdPolicyFormat());
            }
            if (authnRequirements.getNameIdPolicySPNameQualifier() != null) {
                samlRequest.setNameIDPolicySPNameQualifier(authnRequirements.getNameIdPolicySPNameQualifier());
            }
            if (authnRequirements.getNameIdPolicyAllowCreate() != null) {
                samlRequest.setNameIDPolicyAllowCreate(authnRequirements.getNameIdPolicyAllowCreate().booleanValue());
            }
            if (authnRequirements.getForceAuthentication() != null) {
                samlRequest.setForceAuthn(authnRequirements.getForceAuthentication().booleanValue());
            }
            if (authnRequirements.getPassiveAuthentication() != null) {
                samlRequest.setPassive(authnRequirements.getPassiveAuthentication().booleanValue());
            }
            if (authnRequirements.getConfiguredAuthnContexts() != null) {
                if (samlRequest.getRequestedAuthnContextClassRefs() != null) {
                    samlRequest.getRequestedAuthnContextClassRefs().clear();
                }
                samlRequest.setRequestedAuthnContextClassRefs(authnRequirements.getConfiguredAuthnContexts().getNames());
            }
            if (authnRequirements.getSaml2Scoping() != null) {
                samlRequest.setScoping(authnRequirements.getSaml2Scoping());
            }
        }
        return samlRequest;
    }

    private static void setAuthRequestResponseBindings(SAML2TrustedIdP trustedIdP, SAML2AuthRequest samlRequest, String acsUrl) throws Exception {
        if (LOCATION.bePath()) {
            LOCATION.entering("setAuthRequestResponseBindings");
        }
        ResponseRequirementType responseRequirementType = trustedIdP.getResponseRequirementType();
        if (acsUrl != null) {
            SAML2Binding responseBinding = trustedIdP.getResponseRequirementBinding();
            if (responseBinding != null) {
                samlRequest.setProtocolBinding(responseBinding.getName());
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("SSO response binding set in the request: {0}", new Object[]{responseBinding.getName()});
                }
            } else {
                LOCATION.debugT("No response binding configured for the trusted Identity Provider.");
            }
            samlRequest.setAssertionConsumerServiceURL(acsUrl);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("AssertionConsumerService URL set in the authentication request: {0}", new Object[]{acsUrl});
            }
        } else {
            if (ResponseRequirementType.ASSERTION_CONSUMER_URL.equals((Object)responseRequirementType)) {
                throw new IllegalArgumentException("Assertion Consumer Service URL could not be null as in the configuration the requirement type is set to Assertion Consumer URL.");
            }
            if (ResponseRequirementType.ASSERTION_CONSUMER_INDEX.equals((Object)responseRequirementType)) {
                int acsIndex = trustedIdP.getResponseRequirementAssertionConsumerIndex();
                samlRequest.setAssertionConsumerServiceIndex(Integer.valueOf(acsIndex));
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("AssertionConsumerService Index set in the Authentication Request: [{0}]", new Object[]{acsIndex});
                }
            } else if (ResponseRequirementType.IDP_DEFAULT.equals((Object)responseRequirementType)) {
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("AssertionConsumerService response requrement type set to IDP default");
                }
            } else {
                LOCATION.debugT("No requirement type is specified so idp default setting will be used.");
            }
        }
    }
}

