/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp.sso;

import com.sap.security.saml2.cfg.SAML2CfgFactory;
import com.sap.security.saml2.cfg.enums.ResponseRequirementType;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2Config;
import com.sap.security.saml2.cfg.interfaces.SAML2GlobalConfig;
import com.sap.security.saml2.cfg.interfaces.SAML2LocalProvidersConfig;
import com.sap.security.saml2.cfg.interfaces.SAML2TrustedIdPsConfig;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatPersistentTrustedIdP;
import com.sap.security.saml2.commons.AuthnContext;
import com.sap.security.saml2.commons.AuthnContextList;
import com.sap.security.saml2.commons.AuthnContextsMapping;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Artifact;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2Response;
import com.sap.security.saml2.sp.sso.LoginResult;
import com.sap.security.saml2.sp.sso.exception.BadCredentialsException;
import com.sap.security.saml2.sp.sso.exception.LoginFailedException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;

class ConfigurationManager {
    private static final Location LOCATION = Location.getLocation(ConfigurationManager.class);
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"Authentication");
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA-1";
    private LoginResult loginResult;
    private boolean isDefaultConfiguration;
    private boolean idpSelected = false;
    private String requiredTrustedIdPName;
    private SAML2Config saml2Config;
    private SAML2LocalSP localSPConfig;
    private SAML2LocalIdP localIdPConfig;
    private SAML2TrustedIdP trustedIdPConfig;
    private Map<String, String> loginModuleOptions;
    private Boolean forceAuthn = null;
    private Boolean isPassive = null;
    private AuthnContextList authnContexts = null;

    ConfigurationManager(String localProviderName, String trustedIdPName, LoginResult loginResult) {
        this.loginModuleOptions = new HashMap<String, String>();
        this.loginResult = loginResult;
        this.requiredTrustedIdPName = trustedIdPName;
        try {
            SAML2GlobalConfig globalConfig = SAML2CfgFactory.getSAML2GlobalConfig();
            if (globalConfig == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000124", (String)"Service Provider cannot load global SAML2 configuration.");
                throw new SecurityException("Service Provider cannot load global SAML2 configuration.");
            }
            if (localProviderName == null) {
                this.isDefaultConfiguration = true;
                this.saml2Config = globalConfig.getDefaultSAML2Configuration();
                if (this.saml2Config == null) {
                    SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000126", (String)"Service Provider cannot load default SAML2 configuration.");
                    throw new SecurityException("Cannot load default SAML2 configuration.");
                }
            } else {
                this.isDefaultConfiguration = false;
                this.saml2Config = globalConfig.getSAML2Configuration(localProviderName);
                if (this.saml2Config == null) {
                    SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000125", (String)"Service Provider cannot load SAML2 configuration: [{0}].", (Object[])new Object[]{localProviderName});
                    throw new SecurityException("Cannot load SAML2 configuration: " + localProviderName);
                }
            }
        }
        catch (SAML2ConfigurationException e) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000125", (String)"Service Provider cannot load SAML2 configuration: [{0}].", (Object[])new Object[]{localProviderName});
            throw new SecurityException("Cannot load SAML2 configuration: " + localProviderName, e);
        }
    }

    ConfigurationManager(String providerName, LoginResult loginResult, Map options) {
        this.loginModuleOptions = options;
        this.loginResult = loginResult;
        this.isDefaultConfiguration = false;
        try {
            SAML2GlobalConfig globalConfig = SAML2CfgFactory.getSAML2GlobalConfig();
            if (globalConfig == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000124", (String)"Service Provider cannot load global SAML2 configuration.");
                throw new SecurityException("Service Provider cannot load global SAML2 configuration.");
            }
            this.saml2Config = globalConfig.getSAML2Configuration(providerName);
            if (this.saml2Config == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000125", (String)"Service Provider cannot load SAML2 configuration: [{0}].", (Object[])new Object[]{providerName});
                throw new SecurityException("Cannot load SAML2 configuration: " + providerName);
            }
        }
        catch (SAML2ConfigurationException e) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000125", (String)"Service Provider cannot load SAML2 configuration: [{0}].", (Object[])new Object[]{providerName});
            throw new SecurityException("Cannot load SAML2 configuration: " + providerName, e);
        }
    }

    ConfigurationManager(LoginResult loginResult, Map options) {
        this.loginModuleOptions = options;
        this.loginResult = loginResult;
        this.isDefaultConfiguration = true;
        try {
            SAML2GlobalConfig globalConfig = SAML2CfgFactory.getSAML2GlobalConfig();
            if (globalConfig == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000124", (String)"Service Provider cannot load global SAML2 configuration.");
                throw new SecurityException("Service Provider cannot load global SAML2 configuration.");
            }
            this.saml2Config = globalConfig.getDefaultSAML2Configuration();
            if (this.saml2Config == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000126", (String)"Service Provider cannot load default SAML2 configuration.");
                throw new SecurityException("Cannot load default SAML2 configuration.");
            }
        }
        catch (SAML2ConfigurationException e) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000126", (String)"Service Provider cannot load default SAML2 configuration.");
            throw new SecurityException("Cannot load default SAML2 configuration.", e);
        }
    }

    SAML2Config getSAML2Config() {
        if (this.saml2Config == null) {
            throw new IllegalStateException("SAML2 configuration is not loaded.");
        }
        return this.saml2Config;
    }

    SAML2LocalProvider getLocalProvider() {
        if (this.saml2Config == null) {
            throw new IllegalStateException("SAML2 configuration is not loaded.");
        }
        SAML2LocalProvidersConfig localConfig = this.saml2Config.getLocalProvidersConfiguration();
        return localConfig.getLocalProvider();
    }

    SAML2LocalSP getLocalSP() {
        if (this.localSPConfig == null) {
            throw new IllegalStateException("Service Provider configuration is not loaded.");
        }
        return this.localSPConfig;
    }

    SAML2TrustedIdP getTrustedIdP() {
        if (this.trustedIdPConfig == null) {
            throw new IllegalStateException("Trusted Identity Provider configuration is not loaded.");
        }
        return this.trustedIdPConfig;
    }

    SAML2LocalIdP getLocalIdP() {
        if (this.localIdPConfig == null) {
            throw new IllegalStateException("Local Identity Provider configuration is not loaded.");
        }
        return this.localIdPConfig;
    }

    boolean isLocalIdP() {
        return this.localIdPConfig != null;
    }

    boolean isDefaultSAML2Configuration() {
        return this.isDefaultConfiguration;
    }

    boolean isIdPSelected() {
        return this.idpSelected;
    }

    void loadInitialConfigurations() throws LoginException {
        this.loadConfigurations(false, null, null, null);
    }

    boolean loadConfigurations(boolean isLocalAccess, SAML2Principal principal, Object token, String loginResultIdPName) throws LoginException {
        SAML2LocalProvidersConfig configs = this.saml2Config.getLocalProvidersConfiguration();
        if (configs.isIdentityProviderEnabled()) {
            if (configs.isServiceProviderEnabled()) {
                if (isLocalAccess) {
                    this.localSPConfig = configs.getLocalSP();
                    this.localIdPConfig = configs.getLocalIdP();
                    if (LOCATION.beInfo()) {
                        LOCATION.infoT("Local IdP is enabled. Local SP is enabled. Access type is local.");
                        LOCATION.infoT("Service Provider configuration: {0}", new Object[]{this.localSPConfig});
                    }
                } else {
                    this.localSPConfig = configs.getLocalSP();
                    if (LOCATION.beInfo()) {
                        LOCATION.infoT("Local IdP is enabled. Local SP is enabled. Access type is not local.");
                        LOCATION.infoT("Service Provider configuration: {0}", new Object[]{this.localSPConfig});
                    }
                    this.selectIdP(principal, token, loginResultIdPName, true);
                    if (!this.idpSelected) {
                        this.localIdPConfig = configs.getLocalIdP();
                        if (this.localIdPConfig == null) {
                            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000128", (String)"Local Identity Provider configuration could not be loaded.");
                            this.loginResult.throwLoginFailedException("Local Identity Provider configuration cannot be loaded.");
                        } else {
                            LOCATION.infoT("Service Provider selects local Identity Provider.");
                        }
                    }
                }
            } else {
                this.localIdPConfig = configs.getLocalIdP();
                if (this.localIdPConfig == null) {
                    SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000128", (String)"Local Identity Provider configuration could not be loaded.");
                    this.loginResult.throwLoginFailedException("Local Identity Provider configuration cannot be loaded.");
                }
                LOCATION.infoT("Local IdP is enabled. Local SP is disabled.");
            }
        } else if (configs.isServiceProviderEnabled()) {
            this.localSPConfig = configs.getLocalSP();
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Local IdP is disabled. Local SP is enabled.");
                LOCATION.infoT("Service Provider configuration: {0}", new Object[]{this.localSPConfig});
            }
            this.selectIdP(principal, token, loginResultIdPName, false);
            if (!this.idpSelected) {
                this.trustedIdPConfig = this.getDefaultTrustedIdP();
                this.validateIdPConfiguration(null, null, true);
                LOCATION.infoT("Service Provider selects default trusted Identity Provider.");
            }
        } else {
            LOCATION.infoT("Local IdP is disabled. Local SP is disabled.");
            return false;
        }
        if (this.trustedIdPConfig != null) {
            this.loginResult.setIdpName(this.trustedIdPConfig.getName());
            LOCATION.infoT("Trusted Identity Provider configuration: {0}", new Object[]{this.trustedIdPConfig});
        } else {
            this.loginResult.setIdpName(this.localIdPConfig.getName());
            LOCATION.infoT("Local Identity Provider configuration: {0}", new Object[]{this.localIdPConfig});
        }
        return true;
    }

    void loadConfigurations(SAML2Principal principal) throws LoginFailedException {
        SAML2LocalProvidersConfig configs = this.saml2Config.getLocalProvidersConfiguration();
        if (configs == null) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000129", (String)"Local providers configuration could not be loaded.");
            this.loginResult.throwLoginFailedException("Local providers configuration cannot be loaded.");
        }
        this.localSPConfig = configs.getLocalSP();
        if (this.localSPConfig == null) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000121", (String)"Service Provider configuration could not be loaded.");
            this.loginResult.throwLoginFailedException("Service Provider configuration cannot be loaded.");
        }
        LOCATION.infoT("Service Provider configuration: {0}", new Object[]{this.localSPConfig});
        this.trustedIdPConfig = this.getTrustedIdP(principal.getIdPName());
        this.validateIdPConfiguration(principal.getIdPName(), "previous SAML authentication", false);
        this.loginResult.setIdpName(this.trustedIdPConfig.getName());
        LOCATION.infoT("Trusted Identity Provider configuration: {0}", new Object[]{this.trustedIdPConfig});
    }

    void loadLocalConfigurations() throws LoginFailedException {
        SAML2LocalProvidersConfig configs = this.saml2Config.getLocalProvidersConfiguration();
        if (configs == null) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000129", (String)"Local providers configuration could not be loaded.");
            this.loginResult.throwLoginFailedException("Local providers configuration cannot be loaded.");
        }
        this.localIdPConfig = configs.getLocalIdP();
        if (this.localIdPConfig == null) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000128", (String)"Local Identity Provider configuration could not be loaded.");
            this.loginResult.throwLoginFailedException("Local Identity Provider configuration could not be loaded.");
        }
        LOCATION.infoT("Local Identity Provider configuration: {0}", new Object[]{this.localIdPConfig});
        this.localSPConfig = configs.getLocalSP();
        if (this.localSPConfig == null) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000121", (String)"Service Provider configuration could not be loaded.");
            this.loginResult.throwLoginFailedException("Service Provider configuration cannot be loaded.");
        }
        LOCATION.infoT("Local Service Provider configuration: {0}", new Object[]{this.localSPConfig});
        this.loginResult.setIdpName(this.localIdPConfig.getName());
    }

    private void selectIdP(SAML2Principal principal, Object token, String loginResultIdPName, boolean isIdPEnabled) throws LoginException {
        if (principal != null) {
            boolean isLocal = false;
            try {
                isLocal = principal.isLocalProvider(this.getLocalProvider().getName());
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(500, "Failed to check Local Provider in SAML2Principal.", (Throwable)e);
            }
            if (isLocal) {
                this.localIdPConfig = this.saml2Config.getLocalProvidersConfiguration().getLocalIdP();
            } else {
                this.trustedIdPConfig = this.getTrustedIdP(principal.getIdPName());
                this.validateIdPConfiguration(principal.getIdPName(), "previous SAML authentication", false);
            }
            LOCATION.infoT("Identity Provider selected based on previous SAML2 authentication.");
        } else if (token instanceof SAML2Response) {
            this.trustedIdPConfig = this.getTrustedIdP((SAML2Response)token);
            LOCATION.infoT("Identity Provider selected based on SAML2Response received.");
        } else if (token instanceof SAML2Artifact) {
            this.trustedIdPConfig = this.getTrustedIdP((SAML2Artifact)token);
            LOCATION.infoT("Identity Provider selected based on SAML2Artifact received.");
        } else if (loginResultIdPName != null) {
            this.trustedIdPConfig = this.getTrustedIdP(loginResultIdPName);
            this.validateIdPConfiguration(loginResultIdPName, "saved state from last successful SAML2 authentication", false);
            LOCATION.infoT("Identity Provider selected based on saved state from last successful SAML2 authentication.");
        } else if (this.requiredTrustedIdPName != null) {
            this.trustedIdPConfig = this.getTrustedIdP(this.requiredTrustedIdPName);
            if (this.trustedIdPConfig == null) {
                SAML2LocalIdP local = this.saml2Config.getLocalProvidersConfiguration().getLocalIdP();
                if (local != null && local.getName().equalsIgnoreCase(this.requiredTrustedIdPName)) {
                    this.localIdPConfig = local;
                }
            } else {
                this.validateIdPConfiguration(this.requiredTrustedIdPName, "Explicitily given name", false);
            }
        }
        this.idpSelected = this.trustedIdPConfig != null || this.localIdPConfig != null;
    }

    private SAML2TrustedIdP getTrustedIdP(SAML2Response response) throws BadCredentialsException, LoginFailedException {
        LOCATION.debugT("Loading IdP configuration based on SAML2 response received.");
        SAML2NameID issuerNameId = response.getIssuer();
        if (issuerNameId == null || issuerNameId.getName() == null) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000018", (String)"Service Provider received SAML2Response that does not specify an issuer.");
            this.loginResult.throwBadCredentialException("SAML2Response does not specify an issuer.");
        }
        this.trustedIdPConfig = this.getTrustedIdP(issuerNameId.getName());
        this.validateIdPConfiguration(issuerNameId.getName(), "SAML2Response", false);
        return this.trustedIdPConfig;
    }

    private SAML2TrustedIdP getTrustedIdP(SAML2Artifact artifact) throws BadCredentialsException, LoginFailedException {
        LOCATION.debugT("Loading IdP configuration based on SAML2 artifact received.");
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            LOCATION.traceThrowableT(500, "Failed to create instance of MessageDigest: SHA-1", (Throwable)e);
            this.loginResult.throwLoginFailedException("Failed to create instance of MessageDigest: SHA-1", e);
        }
        byte[] sourceID = artifact.getSourceID();
        Collection trustedIdPs = this.saml2Config.getTrustedIdPsConfiguration().getAllTrustedIdPs();
        for (SAML2TrustedIdP trustedIdP : trustedIdPs) {
            byte[] digestedByteArr = messageDigest.digest(trustedIdP.getName().getBytes(Charset.forName("UTF-8")));
            messageDigest.reset();
            if (!Arrays.equals(sourceID, digestedByteArr)) continue;
            this.trustedIdPConfig = trustedIdP;
            this.validateIdPConfiguration(trustedIdP.getName(), "SAML2Artifact", false);
            return this.trustedIdPConfig;
        }
        SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000127", (String)"Service Provider could not select trusted Identity Provider based on SAML2Artifact received because the issuer is not among the list of its trusted providers.");
        this.loginResult.throwBadCredentialException("No trusted Identity Provider matches the source id of the artifact.");
        return this.trustedIdPConfig;
    }

    private SAML2TrustedIdP getTrustedIdP(String name) {
        SAML2TrustedIdPsConfig trustedIdPsConfig = this.saml2Config.getTrustedIdPsConfiguration();
        SAML2TrustedIdP trustedIdP = trustedIdPsConfig.getTrustedIdP(name);
        if (trustedIdP != null) {
            return trustedIdP;
        }
        SAML2TrustedIdP defaultIdP = this.getDefaultTrustedIdP();
        if (defaultIdP != null && defaultIdP.getName().equalsIgnoreCase(name)) {
            return defaultIdP;
        }
        return null;
    }

    private SAML2TrustedIdP getDefaultTrustedIdP() {
        SAML2TrustedIdPsConfig trustedIdPsConfig = this.saml2Config.getTrustedIdPsConfiguration();
        SAML2TrustedIdP trustedIdP = trustedIdPsConfig.getDefaultTrustedIdP();
        return trustedIdP;
    }

    private void validateIdPConfiguration(String idpName, String cause, boolean isDefault) throws LoginFailedException {
        if (this.trustedIdPConfig == null) {
            if (isDefault) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000119", (String)"Service Provider could not load default trusted Identity Provider configuration.");
                this.loginResult.throwLoginFailedException("Default trusted IdP configuration cannot be loaded.");
            } else {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000118", (String)"Service Provider could not load trusted Identity Provider configuration [{0}] based on {1}.", (Object[])new Object[]{idpName, cause});
                this.loginResult.throwLoginFailedException("Trusted IdP configuration cannot be loaded: " + idpName);
            }
        }
        if (!this.trustedIdPConfig.isEnabled()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000120", (String)"Service Provider could not use trusted Identity Provider [{0}] because it is disabled.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
            if (LOCATION.beInfo()) {
                LOCATION.infoT("Trusted Identity Provider configuration: {0}", new Object[]{this.trustedIdPConfig});
            }
            this.loginResult.throwLoginFailedException("Trusted IdP configuration is disabled: " + this.trustedIdPConfig.getName());
        }
    }

    SAML2NameIdFormat getNameIDFormat() {
        SAML2NameIdFormat nameIdFormat = null;
        nameIdFormat = this.trustedIdPConfig.getDefaultNameIdFormat();
        return nameIdFormat;
    }

    boolean getAllowCreate() throws LoginException {
        try {
            SAML2NameIdFormatPersistentTrustedIdP persistentNameIdFormat = this.trustedIdPConfig.getNameIdFormatPersistent();
            if (persistentNameIdFormat != null) {
                return persistentNameIdFormat.isAllowCreate();
            }
        }
        catch (Exception e) {
            this.loginResult.throwLoginFailedException("Error getting Allow Create as a HTTP request parameter.", e);
        }
        return false;
    }

    boolean getForceAuthentication() throws LoginException {
        if (this.forceAuthn == null) {
            String forceAuthnValue = null;
            this.forceAuthn = Boolean.parseBoolean(forceAuthnValue);
        }
        return this.forceAuthn;
    }

    boolean isPassive() throws LoginException {
        if (this.isPassive == null) {
            String isPassiveValue = null;
            this.isPassive = Boolean.parseBoolean(isPassiveValue);
        }
        return this.isPassive;
    }

    AuthnContextList getAuthenticationContexts() throws LoginException {
        if (this.authnContexts == null) {
            try {
                String authnContextsValue = null;
                SAML2LocalProvider localProvider = this.saml2Config.getLocalProvidersConfiguration().getLocalProvider();
                if (authnContextsValue != null) {
                    List<String> names = AuthnContextsMapping.parseAuthnContextString(localProvider, authnContextsValue);
                    this.authnContexts = new AuthnContextList();
                    for (String name : names) {
                        SAML2CfgAuthenticationContext c = localProvider.getAuthenticationContextByName(name);
                        AuthnContext ac = new AuthnContext(c.getName(), c.getAlias(), c.isInteractive(), c.isHTTPS(), c.isHTTP(), c.isCustom());
                        this.authnContexts.add(ac);
                    }
                } else {
                    List contextNames;
                    this.authnContexts = new AuthnContextList();
                    if (!this.isLocalIdP() && (contextNames = this.trustedIdPConfig.getAuthenticationContextNames()) != null && !contextNames.isEmpty()) {
                        for (String contextName : contextNames) {
                            SAML2CfgAuthenticationContext context = localProvider.getAuthenticationContextByName(contextName);
                            AuthnContext newContext = new AuthnContext(context.getName(), context.getAlias(), context.isInteractive(), context.isHTTPS(), context.isHTTP(), context.isCustom());
                            this.authnContexts.add(newContext);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.loginResult.throwLoginFailedException("Error getting Authentication Contexts as HTTP request parameter.", e);
            }
        }
        return this.authnContexts;
    }

    int getACSIndex() throws LoginException {
        int acsIndex = -1;
        if (acsIndex == -1) {
            acsIndex = this.trustedIdPConfig.getResponseRequirementAssertionConsumerIndex();
        }
        return acsIndex;
    }

    ResponseRequirementType getACSResponseRequirement() throws LoginException {
        ResponseRequirementType responseRequirementType = null;
        if (responseRequirementType == null) {
            responseRequirementType = this.trustedIdPConfig.getResponseRequirementType();
        }
        return responseRequirementType;
    }

    String getACSUrl() throws LoginException {
        String acsUrl = null;
        if (acsUrl == null) {
            acsUrl = this.trustedIdPConfig.getResponseRequirementAssertionConsumerURL();
        }
        return acsUrl;
    }

    SAML2Binding getResponseBinding() throws LoginException {
        SAML2Binding responseBinding = null;
        if (responseBinding == null) {
            responseBinding = this.trustedIdPConfig.getResponseRequirementBinding();
        }
        return responseBinding;
    }

    boolean isSAML2FunctionalityEnabled() {
        SAML2LocalProvidersConfig localProviders = this.saml2Config.getLocalProvidersConfiguration();
        return localProviders.isSAML2FunctionalityEnabled();
    }

    Certificate getCertificateForSignature() throws LoginException {
        Certificate certificate = null;
        try {
            certificate = this.localSPConfig.getCertificateForSignature();
            if (certificate == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000115", (String)"Service Provider cannot read its certificate for signature from configuration.");
                this.loginResult.throwLoginFailedException("Could not read Service Provider certificate for signature.");
            }
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Could not read Service Provider certificate for signature.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000115", (String)"Service Provider cannot read its certificate for signature from configuration.");
            this.loginResult.throwLoginFailedException("Could not read Service Provider certificate for signature.", e);
        }
        return certificate;
    }

    Certificate getTrustedIdPCertificateForSignature() throws LoginException {
        Certificate certificate = null;
        try {
            certificate = this.trustedIdPConfig.getCertificateForSignature();
            if (certificate == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000113", (String)"Service Provider cannot read trusted Identity Provider [{0}] certificate for signature from configuration.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
                this.loginResult.throwLoginFailedException("Could not read trusted Identity Provider certificate for signature.");
            }
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Could not read trusted Identity Provider certificate for signature.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000113", (String)"Service Provider cannot read trusted Identity Provider [{0}] certificate for signature from configuration.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
            this.loginResult.throwLoginFailedException("Could not read trusted Identity Provider certificate for signature.", e);
        }
        return certificate;
    }

    PublicKey getTrustedIdPPublicKeyForEncryption() throws LoginException {
        PublicKey publicKey = null;
        try {
            publicKey = this.trustedIdPConfig.getPublicKeyForEncryption();
            if (publicKey == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000114", (String)"Service Provider cannot read trusted Identity Provider [{0}] public key for encryption from configuration.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
                this.loginResult.throwLoginFailedException("Could not read trusted Identity Provider public key for encryption.");
            }
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Could not read trusted Identity Provider public key for encryption.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000114", (String)"Service Provider cannot read trusted Identity Provider [{0}] public key for encryption from configuration.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
            this.loginResult.throwLoginFailedException("Could not read trusted Identity Provider public key for encryption.", e);
        }
        return publicKey;
    }

    PrivateKey getPrivateKeyForEncryption() throws LoginException {
        PrivateKey privateKey = null;
        try {
            privateKey = this.localSPConfig.getPrivateKeyForEncryption();
            if (privateKey == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000109", (String)"Service Provider cannot read its private key for encryption from configuration.");
                this.loginResult.throwLoginFailedException("Service Provider cannot read its private key for encryption from configuration.");
            }
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Service Provider cannot read its private key for encryption from configuration.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000109", (String)"Service Provider cannot read its private key for encryption from configuration.");
            this.loginResult.throwLoginFailedException("Service Provider cannot read its private key for encryption from configuration.", e);
        }
        return privateKey;
    }

    PrivateKey getPrivateKeyForSignature() throws LoginException {
        PrivateKey privateKey = null;
        try {
            privateKey = this.localSPConfig.getPrivateKeyForSignature();
            if (privateKey == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000108", (String)"Service Provider cannot read its private key for signature from configuration.");
                this.loginResult.throwLoginFailedException("Service Provider cannot read its private key for signature from configuration.");
            }
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Service Provider cannot read its private key for signature from configuration.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000108", (String)"Service Provider cannot read its private key for signature from configuration.");
            this.loginResult.throwLoginFailedException("Service Provider cannot read its private key for signature from configuration.", e);
        }
        return privateKey;
    }

    SAML2Endpoint getSSOEndpoint() throws LoginException {
        SAML2Endpoint endpoint = null;
        SAML2Binding binding = this.getBindingFromURLParameter();
        if (binding != null) {
            List endpoints;
            if (LOCATION.beDebug()) {
                LOCATION.debugT("SSO Binding specified by URL parameter: [{0}]", new Object[]{binding.getName()});
            }
            if ((endpoints = this.trustedIdPConfig.getSingleSignOnEndpoints(binding)) != null && endpoints.size() != 0) {
                endpoint = (SAML2Endpoint)endpoints.get(0);
            } else {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000130", (String)"Service Provider has no SSO endpoints configured by binding [{0}] for trusted Identity Provider [{1}].", (Object[])new Object[]{binding.getName(), this.trustedIdPConfig.getName()});
                this.loginResult.throwLoginFailedException("Service Provider has no SSO endpoints configured by binding [" + binding.getName() + "] for trusted Identity Provider [" + this.trustedIdPConfig.getName() + "].");
            }
        } else {
            endpoint = this.trustedIdPConfig.getDefaultSingleSignOnEndpoint();
            if (endpoint == null) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000117", (String)"Service Provider cannot read default Signle Sign-On endpoint for trusted Identity Provider [{0}] from configuration.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
                this.loginResult.throwLoginFailedException("Default SSO endpoint is not configured for trusted IdP: " + this.trustedIdPConfig.getName());
            }
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SSO Endpoint for trusted Identity Provider [{0}]: \n{1}", new Object[]{this.trustedIdPConfig.getName(), endpoint});
        }
        return endpoint;
    }

    /*
     * Enabled aggressive block sorting
     */
    SAML2Endpoint getSLOEndpoint() throws LoginFailedException {
        SAML2Endpoint endpoint;
        block6: {
            endpoint = null;
            SAML2Binding binding = this.getBindingFromURLParameter();
            if (binding != null) {
                List endpoints;
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("SLO Binding specified by URL parameter: [{0}]", new Object[]{binding.getName()});
                }
                if ((endpoints = this.trustedIdPConfig.getSingleLogoutEndpoints(binding)) != null && endpoints.size() != 0) {
                    endpoint = (SAML2Endpoint)endpoints.get(0);
                    break block6;
                } else {
                    SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000131", (String)"Service Provider has no SLO endpoints configured by binding [{0}] for trusted Identity Provider [{1}] and only local session will be logged out.", (Object[])new Object[]{binding.getName(), this.trustedIdPConfig.getName()});
                    return null;
                }
            }
            endpoint = this.trustedIdPConfig.getDefaultSingleLogoutEndpoint();
            if (endpoint == null) {
                SimpleLogger.log((int)300, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000003", (String)"Service Provider has no default SLO endpoint configured for trusted Identity Provider [{0}] and only local session will be logged out.", (Object[])new Object[]{this.trustedIdPConfig.getName()});
                return null;
            }
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SLO Endpoint for trusted Identity Provider [{0}]: \n{1}", new Object[]{this.trustedIdPConfig.getName(), endpoint});
        }
        return endpoint;
    }

    SAML2Binding getBindingFromURLParameter() throws LoginFailedException {
        SAML2Binding binding = null;
        return binding;
    }
}

