/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp.sso;

import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2SPConfiguration;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ProtocolFactory;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutResponse;
import java.util.Date;
import java.util.List;

final class LogoutResponseFactory {
    LogoutResponseFactory() {
    }

    static SAML2LogoutResponse createLogoutResponse(SAML2LocalSP localSP, String idpSLOLocation, String inResponseTo, String statusCode, String secondLevelStatusCode, String statusMessage) throws SAML2Exception {
        SAML2LogoutResponse logoutResponse = SAML2ProtocolFactory.getInstance().createLogoutResponse(SAML2Utils.generateUUID(), statusCode, new Date());
        logoutResponse.setSecondLevelStatusCode(secondLevelStatusCode);
        SAML2NameID nameID = SAML2DataFactory.getInstance().createSAML2NameID(localSP.getName());
        logoutResponse.setIssuer(nameID);
        logoutResponse.setInResponseTo(inResponseTo);
        logoutResponse.setDestination(idpSLOLocation);
        logoutResponse.setStatusMessage(statusMessage);
        return logoutResponse;
    }

    static SAML2LogoutResponse createLogoutResponse(SAML2SPConfiguration cfg, String trustedIdPName, SAML2Binding binding, String inResponseTo, String statusCode, String secondLevelStatusCode, String statusMessage) throws SAML2Exception, SAML2ConfigurationException {
        SAML2LocalSP localSP = cfg.getLocalSP();
        SAML2TrustedIdP trustedIdP = cfg.getTrustedIdP(trustedIdPName);
        SAML2Endpoint idpSLOEndpoint = LogoutResponseFactory.getSLOEndpoint(trustedIdP, binding);
        String idpSLOLocation = idpSLOEndpoint.getResponseLocation();
        if (!(idpSLOLocation != null && idpSLOLocation.length() >= 1 || (idpSLOLocation = idpSLOEndpoint.getLocation()) != null && idpSLOLocation.length() >= 1)) {
            throw new SAML2ConfigurationException("Configured SLO endpoint for IdP: " + trustedIdP.getName() + " does not contain ResponseLocation or Location");
        }
        return LogoutResponseFactory.createLogoutResponse(localSP, idpSLOLocation, inResponseTo, statusCode, secondLevelStatusCode, statusMessage);
    }

    private static SAML2Endpoint getSLOEndpoint(SAML2TrustedIdP trustedIdP, SAML2Binding binding) throws SAML2ConfigurationException {
        List sloEndpoints = trustedIdP.getSingleLogoutEndpoints(binding);
        if (sloEndpoints == null || sloEndpoints.size() < 1) {
            throw new SAML2ConfigurationException("SLO request message could not be created, because there are not any SLO endpoints configured for binding: " + binding);
        }
        SAML2Endpoint idpSLOEndpoint = (SAML2Endpoint)sloEndpoints.get(0);
        for (SAML2Endpoint endpoint : sloEndpoints) {
            if (endpoint == null || !endpoint.isDefault()) continue;
            idpSLOEndpoint = endpoint;
            break;
        }
        return idpSLOEndpoint;
    }
}

