/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp.sso;

import com.sap.security.saml2.cfg.enums.EncryptionOption;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedProvider;
import com.sap.security.saml2.commons.CommonSAML2Utils;
import com.sap.security.saml2.commons.SAML2CommonServicesManager;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.exceptions.SAML2AlreadyConsumedException;
import com.sap.security.saml2.lib.interfaces.SAML2SignableToken;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedAssertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2Response;
import com.sap.security.saml2.sp.sso.AssertionValidationService;
import com.sap.security.saml2.sp.sso.LoginResult;
import com.sap.security.saml2.sp.sso.ServiceProviderUtil;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.util.Date;
import java.util.List;
import javax.security.auth.login.LoginException;

class ResponseValidationService {
    private static final Location LOCATION = Location.getLocation(ResponseValidationService.class);
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"Authentication");
    private SAML2Response saml2Response;
    private String actualRecipientUrl;
    private String refererUrl;
    private LoginResult loginResult;
    private boolean isFrontChannelRequest;
    private SAML2TrustedIdP trustedIdP;
    private SAML2LocalSP localSP;
    private String requestId;
    private boolean signatureValidated;

    ResponseValidationService(SAML2Response saml2Response, SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, String actualRecipientUrl, LoginResult loginResult, boolean isFrontChannelRequest, String requestId) {
        this.saml2Response = saml2Response;
        this.actualRecipientUrl = actualRecipientUrl;
        this.loginResult = loginResult;
        this.isFrontChannelRequest = isFrontChannelRequest;
        this.signatureValidated = false;
        this.trustedIdP = trustedIdP;
        this.localSP = localSP;
        this.requestId = requestId;
    }

    ResponseValidationService(SAML2Response saml2Response, SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, String actualRecipientUrl, String refererUrl, LoginResult loginResult, boolean isFrontChannelRequest, String requestId) {
        this(saml2Response, localSP, trustedIdP, actualRecipientUrl, loginResult, isFrontChannelRequest, requestId);
        this.refererUrl = refererUrl;
    }

    SAML2Assertion validateResponse() throws LoginException {
        if (LOCATION.bePath()) {
            LOCATION.entering("validateResponse");
        }
        this.checkVersion();
        this.checkIssueInstant();
        this.checkInResponseTo();
        this.checkIssuer();
        this.checkStatusCode();
        this.checkSignature();
        SAML2Assertion assertion = this.validateAssertions();
        LOCATION.debugT("SAML2Response successfully validated.");
        try {
            SAML2CommonServicesManager.getInstance().getConsumedAssertionService().consume(assertion, this.loginResult.getSubjectConfirmationNotOnOrAfter());
        }
        catch (SAML2AlreadyConsumedException e) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000028", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that is already consumed.", (Object[])new Object[]{this.trustedIdP.getName()});
            this.loginResult.throwLoginFailedException("SAML2Assertion received in the SAML2Response is already consumed.", e);
        }
        catch (SAML2Exception e) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000029", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] but could not check whether it is already consumed. Reason: {1}", (Object[])new Object[]{this.trustedIdP.getName(), e.getMessage()});
            this.loginResult.throwLoginFailedException("Already consumed assertion check failed.", e);
        }
        if (LOCATION.bePath()) {
            LOCATION.exiting("validateResponse");
        }
        return assertion;
    }

    private void checkInResponseTo() throws LoginException {
        if (this.saml2Response.getInResponseTo() != null) {
            if (!this.localSP.isSPInitiatedSSOEnabled()) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000137", (String)"Service Provider could not perform authentication because SP-Initiated SSO has been disabled in the configuration.");
                this.loginResult.throwLoginFailedException("Service Provider could not perform authentication because SP-Initiated SSO has been disabled in the configuration.");
            }
        } else if (!this.localSP.isIdPInitiatedSSOEnabled()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000138", (String)"Service Provider could not perform authentication because IdP-Initiated SSO has been disabled in the configuration.");
            this.loginResult.throwLoginFailedException("Service Provider could not perform authentication because IdP-Initiated SSO has been disabled in the configuration.");
        }
        if (this.requestId != null) {
            this.checkInResponseTo(this.requestId);
        } else {
            SimpleLogger.trace((int)300, (Location)LOCATION, (String)"Original Request Id is not provided, so InResponseTo will not be checked. ");
        }
    }

    private void checkStatusCode() throws LoginException {
        String topLevelCode = this.saml2Response.getTopLevelStatusCode();
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equalsIgnoreCase(topLevelCode)) {
            String statusMessage = this.saml2Response.getStatusMessage();
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000025", (String)"Service Provider has received SAML2Response from Identity Provider [{0}] that contains an error status code [{1}]. Status message: [{2}]", (Object[])new Object[]{this.trustedIdP.getName(), topLevelCode, statusMessage});
            this.loginResult.throwBadCredentialException("Error SAML2Response received. Details: " + statusMessage);
        }
    }

    private void checkIssuer() throws LoginException {
        SAML2NameID issuerNameId = this.saml2Response.getIssuer();
        if (issuerNameId == null || issuerNameId.getName() == null || issuerNameId.getName().length() == 0) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000018", (String)"Service Provider received SAML2Response that does not specify an issuer.");
            this.loginResult.throwBadCredentialException("SAML2Response received that does not specify an issuer.");
        } else if (!this.trustedIdP.getName().equalsIgnoreCase(issuerNameId.getName())) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000020", (String)"Service Provider has received SAML2Response from Identity Provider [{0}] but the current SAML2 context is for Identity Provider [{1}].", (Object[])new Object[]{issuerNameId.getName(), this.trustedIdP.getName()});
            this.loginResult.throwBadCredentialException("SAML2Response received from different Identity Provider than the one in the current SAML2 context.");
        }
    }

    private void checkIssueInstant() throws LoginException {
        try {
            Date issueInstant = this.saml2Response.getIssueInstant();
            CommonSAML2Utils.checkIssueInstant(issueInstant, (SAML2LocalProvider)this.localSP);
        }
        catch (SAML2Exception e) {
            LOCATION.traceThrowableT(500, "SAML2Response issue instant is not valid.", (Throwable)e);
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000023", (String)"Service Provider has received SAML2Response from Identity Provider [{0}] whose issue instant [{1}] is not valid. Detailed message: {2}", (Object[])new Object[]{this.trustedIdP.getName(), this.saml2Response.getIssueInstant(), e.getMessage()});
            this.loginResult.throwBadCredentialException("SAML2Response issue instant is not valid: " + e.getLocalizedMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkInResponseTo(String requestId) throws LoginException {
        try {
            String inResponseTo = this.saml2Response.getInResponseTo();
            if (requestId != null && requestId.length() > 0) {
                if (!requestId.equals(inResponseTo)) throw new SAML2Exception("InResponseTo [" + inResponseTo + "] does not correspond to the AuthnRequest ID [" + (requestId != null ? requestId : "") + "]");
                if (!LOCATION.beDebug()) return;
                LOCATION.debugT("SAML2Response contains InResponseTo [{0}] that corresponds to the AuthnRequest ID.", new Object[]{inResponseTo});
                return;
            } else {
                if (inResponseTo == null) return;
                LOCATION.debugT("Solicited SAML2Response received (with InResponseTo: {0}), but there is not original request Id to check against.", new Object[]{inResponseTo});
            }
            return;
        }
        catch (SAML2Exception e) {
            LOCATION.traceThrowableT(500, "SAML2Response InResponseTo validation failed.", (Throwable)e);
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000082", (String)"Service Provider has received SAML2Response from Identity Provider [{0}] whose InResponseTo check failed. Reason: {1}", (Object[])new Object[]{this.trustedIdP.getName(), e.getMessage()});
            this.loginResult.throwBadCredentialException(e.getMessage(), e);
        }
    }

    private void checkVersion() throws LoginException {
        if (!"2.0".equalsIgnoreCase(this.saml2Response.getVersion())) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000022", (String)"Service Provider has received SAML2Response from Identity Provider [{0}] that has incorrect version: received version = [{1}], expected version = [{2}]", (Object[])new Object[]{this.trustedIdP.getName(), this.saml2Response.getVersion(), "2.0"});
            this.loginResult.throwBadCredentialException("SAML2Response has incorrent version.");
        }
    }

    private void checkSignature() throws LoginException {
        if (this.saml2Response.isSigned()) {
            LOCATION.debugT("SAML2Response received is signed.");
            String recipientUrl = this.saml2Response.getDestination();
            if (!(ServiceProviderUtil.checkRecipientUrl(recipientUrl, this.actualRecipientUrl) || this.refererUrl != null && ServiceProviderUtil.checkRecipientUrl(recipientUrl, this.refererUrl))) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000021", (String)"Service Provider has received SAML2Response from Identity Provider [{0}] whose destination [{1}] does not match requested URL [{2}].", (Object[])new Object[]{this.trustedIdP.getName(), recipientUrl, this.actualRecipientUrl});
                this.loginResult.throwBadCredentialException("SAML2Response destination does not match requested Service Provider URL.");
            }
            try {
                SAML2CommonServicesManager.getInstance().getSignatureValidator().validateSignature((SAML2SignableToken)this.saml2Response, (SAML2LocalProvider)this.localSP, (SAML2TrustedProvider)this.trustedIdP);
                LOCATION.debugT("SAML2Response signature validated successfully.");
            }
            catch (Exception e) {
                LOCATION.traceThrowableT(500, "SAML2Response signature verification failed.", (Throwable)e);
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000016", (String)"Service Provider has received SAML2Response from Identity Provider [{0}] that has invalid signature.", (Object[])new Object[]{this.trustedIdP.getName()});
                this.loginResult.throwBadCredentialException("SAML2Response signature verification failed.", e);
            }
            this.signatureValidated = true;
        } else if (this.trustedIdP.isToRequireSignedAuthnResponses() == SignatureOption.ALWAYS || this.trustedIdP.isToRequireSignedAuthnResponses() == SignatureOption.FRONT_CHANNEL_ONLY && this.isFrontChannelRequest) {
            if (this.saml2Response.isParentSAML2TokenSignatureVerified()) {
                LOCATION.debugT("Service Provider has received SAML2Response from Identity Provider [{0}] that is not signed but the ArtifactResponse has valid signature and the SAML2Response inherits its signature.", new Object[]{this.trustedIdP.getName()});
            } else {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000015", (String)"Service Provider received SAML2Response that is not signed from Identity Provider [{0}].", (Object[])new Object[]{this.trustedIdP.getName()});
                this.loginResult.throwBadCredentialException("Received SAML2Response is not signed but it is required to be signed.");
            }
        }
    }

    private SAML2Assertion validateAssertions() throws LoginException {
        AssertionValidationService avs = new AssertionValidationService(this.localSP, this.trustedIdP, this.actualRecipientUrl, this.refererUrl, this.loginResult, this.isFrontChannelRequest, this.saml2Response, this.signatureValidated);
        LoginException loginException = null;
        List encAssertions = this.saml2Response.getEncryptedAssertions();
        List plainAssertions = this.saml2Response.getAssertions();
        if ((encAssertions == null || encAssertions.isEmpty()) && (plainAssertions == null || plainAssertions.isEmpty())) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000024", (String)"Service Provider has received SAML2Response from Identity Provider [{0}] that contains no SAML2Assertions.", (Object[])new Object[]{this.trustedIdP.getName()});
            this.loginResult.throwBadCredentialException("SAML2Response contains no assertions.");
        } else if (LOCATION.beDebug()) {
            LOCATION.debugT("SAML2Response contains {0} plain and {1} encrypted SAML2 assertion(s).", new Object[]{plainAssertions.size(), encAssertions.size()});
        }
        if (encAssertions != null && !encAssertions.isEmpty()) {
            LOCATION.debugT("Encrypted assertions received in SAML2Response.");
            for (SAML2EncryptedAssertion encAssertion : encAssertions) {
                try {
                    return avs.validateAssertion(encAssertion);
                }
                catch (LoginException e) {
                    loginException = e;
                    LOCATION.traceThrowableT(400, "SAML2Assertion validation failed.", (Throwable)e);
                }
            }
        } else if (this.trustedIdP.getRequiredEncryptedAuthnResponseElements() == EncryptionOption.WHOLE_ASSERTION) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.000040", (String)"Service Provider has received SAML2Assertion from Identity Provider [{0}] that is not encrypted.", (Object[])new Object[]{this.trustedIdP.getName()});
            this.loginResult.throwBadCredentialException("Received SAML2Assertion is not encrypted but it is required to be encrypted.");
        }
        if (plainAssertions != null && !plainAssertions.isEmpty()) {
            for (SAML2Assertion assertion : plainAssertions) {
                try {
                    return avs.validateAssertion(assertion);
                }
                catch (LoginException e) {
                    loginException = e;
                    LOCATION.traceThrowableT(400, "SAML2Assertion validation failed.", (Throwable)e);
                }
            }
        }
        throw loginException;
    }
}

