/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp.sso;

import com.sap.security.saml2.cfg.enums.DigestAlgorithm;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2SPConfiguration;
import com.sap.security.saml2.cfg.interfaces.read.SAML2Endpoint;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.commons.AuthnContext;
import com.sap.security.saml2.commons.SAML2CommonServicesManager;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.saml2.lib.bindings.HTTPPostBinding;
import com.sap.security.saml2.lib.bindings.HTTPRedirectBindingDeflate;
import com.sap.security.saml2.lib.bindings.RedirectPayloadDeflateImpl;
import com.sap.security.saml2.lib.common.SAML2DataFactory;
import com.sap.security.saml2.lib.common.SAML2ErrorResponseDetails;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ProtocolFactory;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.security.saml2.lib.common.exceptions.SAML2ErrorResponseException;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Artifact;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2Assertion;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.bindings.RedirectPayloadDeflate;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2AuthRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutResponse;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ProtocolToken;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2Response;
import com.sap.security.saml2.sp.sso.AssertionValidationService;
import com.sap.security.saml2.sp.sso.AuthenticationRequirements;
import com.sap.security.saml2.sp.sso.AuthnRequestFactory;
import com.sap.security.saml2.sp.sso.ConfigurationManager;
import com.sap.security.saml2.sp.sso.LoginResult;
import com.sap.security.saml2.sp.sso.LogoutRequestData;
import com.sap.security.saml2.sp.sso.LogoutRequestFactory;
import com.sap.security.saml2.sp.sso.LogoutResponseFactory;
import com.sap.security.saml2.sp.sso.ResponseValidationService;
import com.sap.security.saml2.sp.sso.SAML2PrincipalWrapper;
import com.sap.security.saml2.sp.sso.SLOInfo;
import com.sap.security.saml2.sp.sso.SLOMessageValidationService;
import com.sap.security.saml2.sp.sso.SLORequestInfo;
import com.sap.security.saml2.sp.sso.Utils;
import com.sap.security.saml2.sp.sso.ValidationResult;
import com.sap.security.saml2.sp.sso.exception.BadCredentialsException;
import com.sap.security.saml2.sp.sso.exception.LoginFailedException;
import com.sap.tc.logging.Location;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;

public class SAML2Authentication {
    private static final Location LOCATION = Location.getLocation(SAML2Authentication.class);
    private static final SAML2Authentication INSTANCE = new SAML2Authentication();

    private SAML2Authentication() {
    }

    public static SAML2Authentication getInstance() {
        return INSTANCE;
    }

    public String generateMetadata(String baseURL, Certificate signingCert) {
        return null;
    }

    public String createSSORequestUrl(String trustedIdPName, String relayState, String assertionConsumerServiceUrl) throws LoginException {
        String idpSSOLocation;
        LoginResult loginResult = new LoginResult();
        ConfigurationManager configManager = new ConfigurationManager(null, trustedIdPName, loginResult);
        configManager.loadInitialConfigurations();
        SAML2LocalSP localSP = configManager.getLocalSP();
        SAML2TrustedIdP trustedIdP = configManager.getTrustedIdP();
        SAML2Endpoint idpSSOEndpoint = trustedIdP.getDefaultSingleSignOnEndpoint();
        if (idpSSOEndpoint == null) {
            loginResult.throwLoginFailedException("Default SSO endpoint is not configured for trusted IdP: " + trustedIdPName);
        }
        if ((idpSSOLocation = idpSSOEndpoint.getLocation()) == null || idpSSOLocation.length() < 1) {
            loginResult.throwLoginFailedException("Empty location is configured in SSO endpoint for IdP: " + trustedIdPName);
        }
        SAML2AuthRequest authnRequest = AuthnRequestFactory.createAuthnRequest(localSP, trustedIdP, idpSSOLocation, assertionConsumerServiceUrl, null);
        String result = null;
        try {
            RedirectPayloadDeflateImpl redirectPayload = new RedirectPayloadDeflateImpl((SAML2ProtocolToken)authnRequest, relayState);
            if (trustedIdP.isToSignAuthnRequests() != SignatureOption.NEVER) {
                PrivateKey privateKey = null;
                try {
                    privateKey = localSP.getPrivateKeyForSignature();
                    if (privateKey == null) {
                        loginResult.throwLoginFailedException("Service Provider cannot read its private key for signature from configuration.");
                    }
                }
                catch (SAML2ConfigurationException e) {
                    loginResult.throwLoginFailedException("Service Provider cannot read its private key for signature from configuration.", e);
                }
                redirectPayload.sign(privateKey);
            }
            result = HTTPRedirectBindingDeflate.generateRedirectLocationURL((String)idpSSOLocation, (RedirectPayloadDeflate)redirectPayload);
        }
        catch (SAML2Exception e) {
            loginResult.throwLoginFailedException("Could not prepare SAML2 redirect binding for SAML2 AuthnRequest", e);
        }
        return result;
    }

    public String createSSORequestUrl(SAML2SPConfiguration configuration, String trustedIdPName, String relayState, String assertionConsumerServiceUrl) throws LoginException {
        return this.createSSORequestUrl(configuration, trustedIdPName, relayState, assertionConsumerServiceUrl, null);
    }

    public String createSSORequestUrl(SAML2SPConfiguration configuration, String trustedIdPName, String relayState, String assertionConsumerServiceUrl, AuthenticationRequirements authnRequirements) throws LoginException {
        return this.createSSORequestUrl(configuration, trustedIdPName, relayState, assertionConsumerServiceUrl, authnRequirements, null);
    }

    public String createSSORequestUrl(SAML2SPConfiguration configuration, String trustedIdPName, String relayState, String assertionConsumerServiceUrl, AuthenticationRequirements authnRequirements, String requestId) throws LoginException {
        String idpSSOLocation;
        SAML2Endpoint idpSSOEndpoint;
        LoginResult loginResult = new LoginResult();
        SAML2LocalSP localSP = configuration.getLocalSP();
        SAML2TrustedIdP trustedIdP = configuration.getTrustedIdP(trustedIdPName);
        if (trustedIdP == null) {
            loginResult.throwLoginFailedException("There is no configuration for trusted Identity Provider with name:" + trustedIdPName);
        }
        if ((idpSSOEndpoint = trustedIdP.getDefaultSingleSignOnEndpoint()) == null) {
            loginResult.throwLoginFailedException("Default SSO endpoint is not configured for trusted IdP: " + trustedIdPName);
        }
        if ((idpSSOLocation = idpSSOEndpoint.getLocation()) == null || idpSSOLocation.length() < 1) {
            loginResult.throwLoginFailedException("Empty location is configured in SSO endpoint for IdP: " + trustedIdPName);
        }
        SAML2AuthRequest authnRequest = AuthnRequestFactory.createAuthnRequest(localSP, trustedIdP, idpSSOLocation, assertionConsumerServiceUrl, authnRequirements, requestId);
        String result = null;
        try {
            RedirectPayloadDeflateImpl redirectPayload = new RedirectPayloadDeflateImpl((SAML2ProtocolToken)authnRequest, relayState);
            if (trustedIdP.isToSignAuthnRequests() != SignatureOption.NEVER) {
                DigestAlgorithm digestAlgorithm;
                PrivateKey privateKey = null;
                try {
                    privateKey = localSP.getPrivateKeyForSignature();
                    if (privateKey == null) {
                        loginResult.throwLoginFailedException("Service Provider cannot read its private key for signature from configuration.");
                    }
                }
                catch (SAML2ConfigurationException e) {
                    loginResult.throwLoginFailedException("Service Provider cannot read its private key for signature from configuration.", e);
                }
                if ((digestAlgorithm = trustedIdP.getDigestAlgorithm()) != null) {
                    redirectPayload.setDigestAlgorithm(digestAlgorithm.getName());
                }
                redirectPayload.sign(privateKey);
            }
            result = HTTPRedirectBindingDeflate.generateRedirectLocationURL((String)idpSSOLocation, (RedirectPayloadDeflate)redirectPayload);
        }
        catch (SAML2Exception e) {
            loginResult.throwLoginFailedException("Could not prepare SAML2 redirect binding for SAML2 AuthnRequest", e);
        }
        return result;
    }

    public String createSSORequestHttpBody(SAML2SPConfiguration configuration, String trustedIdPName, String relayState, String assertionConsumerServiceUrl) throws LoginException {
        return this.createSSORequestHttpBody(configuration, trustedIdPName, relayState, assertionConsumerServiceUrl, null);
    }

    public String createSSORequestHttpBody(SAML2SPConfiguration configuration, String trustedIdPName, String relayState, String assertionConsumerServiceUrl, AuthenticationRequirements authnRequirements) throws LoginException {
        return this.createSSORequestHttpBody(configuration, trustedIdPName, relayState, assertionConsumerServiceUrl, authnRequirements, null);
    }

    public String createSSORequestHttpBody(SAML2SPConfiguration configuration, String trustedIdPName, String relayState, String assertionConsumerServiceUrl, AuthenticationRequirements authnRequirements, String requestId) throws LoginException {
        String idpSSOLocation;
        SAML2Endpoint idpSSOEndpoint;
        LoginResult loginResult = new LoginResult();
        SAML2LocalSP localSP = configuration.getLocalSP();
        SAML2TrustedIdP trustedIdP = configuration.getTrustedIdP(trustedIdPName);
        if (trustedIdP == null) {
            loginResult.throwLoginFailedException("There is no configuration for trusted Identity Provider with name:" + trustedIdPName);
        }
        if ((idpSSOEndpoint = trustedIdP.getDefaultSingleSignOnEndpoint()) == null) {
            loginResult.throwLoginFailedException("Default SSO endpoint is not configured for trusted IdP: " + trustedIdPName);
        }
        if ((idpSSOLocation = idpSSOEndpoint.getLocation()) == null || idpSSOLocation.length() < 1) {
            loginResult.throwLoginFailedException("Empty location is configured in SSO endpoint for IdP: " + trustedIdPName);
        }
        SAML2AuthRequest authnRequest = AuthnRequestFactory.createAuthnRequest(localSP, trustedIdP, idpSSOLocation, assertionConsumerServiceUrl, authnRequirements, requestId);
        String result = null;
        try {
            if (trustedIdP.isToSignAuthnRequests() != SignatureOption.NEVER) {
                PrivateKey privateKey = null;
                try {
                    DigestAlgorithm digestAlgorithm;
                    privateKey = localSP.getPrivateKeyForSignature();
                    if (privateKey == null) {
                        loginResult.throwLoginFailedException("Service Provider cannot read its private key for signature from configuration.");
                    }
                    if ((digestAlgorithm = trustedIdP.getDigestAlgorithm()) != null) {
                        authnRequest.setDigestAlgorithm(digestAlgorithm.getName());
                    }
                    if (localSP.isToIncludeCertInSignature()) {
                        authnRequest.sign(privateKey, localSP.getCertificateForSignature());
                    } else {
                        authnRequest.sign(privateKey);
                    }
                }
                catch (SAML2ConfigurationException e) {
                    loginResult.throwLoginFailedException("Service Provider cannot read its private key for signature from configuration.", e);
                }
            }
            String xmlRequest = authnRequest.generate();
            result = HTTPPostBinding.generateRequestForm((String)xmlRequest, (String)relayState, (String)idpSSOLocation, null, (boolean)true);
        }
        catch (SAML2Exception e) {
            loginResult.throwLoginFailedException("Could not prepare SAML2 post binding for SAML2 AuthnRequest", e);
        }
        return result;
    }

    public Principal validateResponse(String saml2ResponseXML, String relayState, String recipientUrl) throws LoginException {
        LoginResult loginResult = new LoginResult();
        SAML2Response saml2Response = null;
        try {
            saml2Response = SAML2ProtocolFactory.getInstance().createResponse(saml2ResponseXML);
            saml2Response.parse();
        }
        catch (SAML2Exception e) {
            loginResult.throwLoginFailedException("Could not parse the given SAML2 Response XML", e);
        }
        ConfigurationManager configManager = new ConfigurationManager(loginResult, new HashMap());
        configManager.loadConfigurations(false, null, saml2Response, null);
        SAML2LocalSP localSP = configManager.getLocalSP();
        SAML2TrustedIdP trustedIdP = configManager.getTrustedIdP();
        ResponseValidationService responseValidationService = new ResponseValidationService(saml2Response, localSP, trustedIdP, recipientUrl, loginResult, true, relayState);
        SAML2Assertion assertion = responseValidationService.validateResponse();
        loginResult.setLocalUser(assertion.getSubjectNameID().getName());
        String spName = localSP.getName();
        AuthnContext newContext = Utils.getAuthenticationContext(localSP, trustedIdP, loginResult);
        SAML2Principal saml2Principal = Utils.createSAML2Principal(null, newContext, loginResult, spName);
        return saml2Principal;
    }

    public SAML2Principal validateResponse(SAML2SPConfiguration configuration, String saml2ResponseXML, String originalRequestId, String recipientUrl) throws LoginException {
        SAML2Response saml2Response = this.parseSAML2Response(saml2ResponseXML);
        SAML2Principal saml2Principal = this.validateResponse(configuration, saml2Response, originalRequestId, recipientUrl);
        return saml2Principal;
    }

    public SAML2Response parseSAML2Response(String saml2ResponseXML) throws LoginFailedException {
        if (LOCATION.beInfo()) {
            LOCATION.infoT("SAML2 Response for parse:\n{0}", new Object[]{saml2ResponseXML});
        }
        SAML2Response saml2Response = null;
        try {
            saml2Response = SAML2ProtocolFactory.getInstance().createResponse(saml2ResponseXML);
            saml2Response.parse();
        }
        catch (SAML2Exception e) {
            new LoginResult().throwLoginFailedException("Could not parse the given SAML2 Response XML", e);
        }
        return saml2Response;
    }

    public SAML2Principal validateResponse(SAML2SPConfiguration configuration, SAML2Response saml2Response, String originalRequestId, String recipientUrl) throws LoginException {
        return this.validateResponse(configuration, saml2Response, originalRequestId, recipientUrl, null);
    }

    public SAML2Principal validateResponse(SAML2SPConfiguration configuration, SAML2Response saml2Response, String originalRequestId, String recipientUrl, String refererUrl) throws LoginException {
        SAML2PrincipalWrapper saml2PrincipalWrapper = this.validateResponseAssertion(configuration, saml2Response, originalRequestId, recipientUrl, refererUrl);
        if (saml2PrincipalWrapper != null) {
            return saml2PrincipalWrapper.getSaml2Principal();
        }
        return null;
    }

    public SAML2PrincipalWrapper validateResponseAssertion(SAML2SPConfiguration configuration, SAML2Response saml2Response, String originalRequestId, String recipientUrl) throws LoginException {
        return this.validateResponseAssertion(configuration, saml2Response, originalRequestId, recipientUrl, null);
    }

    public SAML2PrincipalWrapper validateResponseAssertion(SAML2SPConfiguration configuration, SAML2Response saml2Response, String originalRequestId, String recipientUrl, String refererUrl) throws LoginException {
        String trustedIdPName = null;
        LoginResult loginResult = new LoginResult();
        SAML2LocalSP localSP = configuration.getLocalSP();
        trustedIdPName = this.getTrustedIdPName(saml2Response, loginResult);
        loginResult.setIdpName(trustedIdPName);
        SAML2TrustedIdP trustedIdP = configuration.getTrustedIdP(trustedIdPName);
        if (trustedIdP == null) {
            loginResult.throwBadCredentialException("The issuer of the received SAML2Response is not a trusted Identity Provider. There is no configuration for IdP '" + trustedIdPName + "'");
        }
        ResponseValidationService responseValidationService = new ResponseValidationService(saml2Response, localSP, trustedIdP, recipientUrl, refererUrl, loginResult, true, originalRequestId);
        SAML2Assertion assertion = responseValidationService.validateResponse();
        loginResult.setLocalUser(assertion.getSubjectNameID().getName());
        String spName = localSP.getName();
        AuthnContext newContext = Utils.getAuthenticationContext(localSP, trustedIdP, loginResult);
        SAML2Principal saml2Principal = Utils.createSAML2Principal(null, newContext, loginResult, spName);
        try {
            saml2Principal.setSaml2IdpCert(configuration.getTrustedIdP(trustedIdPName).getCertificateForSignature());
        }
        catch (SAML2ConfigurationException exception) {
            LoginException loginException = new LoginException("Failed to retrieve IDP certificate from configuration.");
            loginException.initCause(exception);
            throw loginException;
        }
        return new SAML2PrincipalWrapper(saml2Principal, assertion.getXMLRepresentationForPrinciplePropagation());
    }

    public SAML2Principal validateArtifact(SAML2SPConfiguration configuration, String saml2Artifact, String originalRequestId, String recipientUrl) throws SAML2Exception, LoginException {
        return this.validateArtifact(configuration, saml2Artifact, originalRequestId, recipientUrl, null, null);
    }

    public SAML2Principal validateArtifact(SAML2SPConfiguration configuration, String saml2Artifact, String originalRequestId, String recipientUrl, String userName, char[] password) throws SAML2Exception, LoginException {
        if (LOCATION.beInfo()) {
            LOCATION.infoT("SAML2 artifact for resolving:{0}", new Object[]{saml2Artifact});
        }
        SAML2Artifact artifact = SAML2DataFactory.getInstance().createSAML2Artifact(saml2Artifact);
        SAML2ProtocolToken token = SAML2CommonServicesManager.getInstance().getArtifactServiceInstance().resolveArtifact(configuration, artifact, userName, password);
        if (token instanceof SAML2Response) {
            SAML2Response saml2Response = (SAML2Response)token;
            SAML2Principal saml2Principal = this.validateResponse(configuration, saml2Response, originalRequestId, recipientUrl);
            return saml2Principal;
        }
        throw new SAML2Exception("The resolved SAML2 message from artifact: " + saml2Artifact + " is not SAML2 (authentication) Response. Resolved message: " + token);
    }

    public String createSLORequestUrl(SAML2SPConfiguration configuration, SAML2Principal principal, String relayState) throws SAML2Exception, SAML2ConfigurationException {
        SAML2LogoutRequest logoutRequest;
        String trustedIdPName = principal.getIdPName();
        if (trustedIdPName == null || trustedIdPName.length() < 1) {
            throw new SAML2Exception("SLO request message could not be created, because SAML2Principal does not contain trusted Identity Provider name.");
        }
        SAML2LocalSP localSP = configuration.getLocalSP();
        SAML2TrustedIdP trustedIdP = configuration.getTrustedIdP(trustedIdPName);
        if (trustedIdP == null) {
            throw new SAML2ConfigurationException("There is no configuration for trusted Identity Provider with name:" + trustedIdPName);
        }
        SAML2Endpoint idpSLOEndpoint = this.getSLOEndpoint(trustedIdP, SAML2Binding.HTTP_REDIRECT_BINDING);
        String idpSLOLocation = idpSLOEndpoint.getLocation();
        if (idpSLOLocation == null || idpSLOLocation.length() < 1) {
            throw new SAML2ConfigurationException("Empty location is configured in SLO endpoint for IdP: " + trustedIdP.getName());
        }
        try {
            logoutRequest = LogoutRequestFactory.createLogoutRequest(localSP, trustedIdP, principal, idpSLOLocation, null);
        }
        catch (LoginException e) {
            throw new SAML2Exception("Could not create SAML2 LogoutRequest.", (Throwable)e);
        }
        RedirectPayloadDeflate redirectPayload = SAML2DataFactory.getInstance().createRedirectPayloadDeflate((SAML2ProtocolToken)logoutRequest, relayState);
        this.signSLORedirectPayload(localSP, trustedIdP, redirectPayload);
        String redirectUrl = HTTPRedirectBindingDeflate.generateRedirectLocationURL((String)idpSLOLocation, (RedirectPayloadDeflate)redirectPayload);
        return redirectUrl;
    }

    private SAML2Endpoint getSLOEndpoint(SAML2TrustedIdP trustedIdP, SAML2Binding binding) throws SAML2ConfigurationException {
        List sloEndpoints = trustedIdP.getSingleLogoutEndpoints(binding);
        if (sloEndpoints == null || sloEndpoints.size() < 1) {
            throw new SAML2ConfigurationException("SLO request message could not be created, because there are not any SLO endpoints configured for binding: " + binding);
        }
        SAML2Endpoint idpSLOEndpoint = (SAML2Endpoint)sloEndpoints.get(0);
        for (SAML2Endpoint endpoint : sloEndpoints) {
            if (endpoint == null || !endpoint.isDefault()) continue;
            idpSLOEndpoint = endpoint;
            break;
        }
        return idpSLOEndpoint;
    }

    public String createSLORequestHttpBody(SAML2SPConfiguration configuration, SAML2Principal principal, String relayState) throws SAML2Exception, SAML2ConfigurationException {
        SAML2LogoutRequest logoutRequest;
        String trustedIdPName = principal.getIdPName();
        if (trustedIdPName == null || trustedIdPName.length() < 1) {
            throw new SAML2Exception("SLO request message could not be created, because SAML2Principal does not contain trusted Identity Provider name.");
        }
        SAML2LocalSP localSP = configuration.getLocalSP();
        SAML2TrustedIdP trustedIdP = configuration.getTrustedIdP(trustedIdPName);
        if (trustedIdP == null) {
            throw new SAML2ConfigurationException("There is no configuration for trusted Identity Provider with name:" + trustedIdPName);
        }
        SAML2Endpoint idpSLOEndpoint = this.getSLOEndpoint(trustedIdP, SAML2Binding.HTTP_REDIRECT_BINDING);
        if (idpSLOEndpoint == null) {
            throw new SAML2ConfigurationException("SLO endpoint is not configured for IdP: " + trustedIdP.getName());
        }
        String idpSLOLocation = idpSLOEndpoint.getLocation();
        if (idpSLOLocation == null || idpSLOLocation.length() < 1) {
            throw new SAML2ConfigurationException("Empty location is configured in SLO endpoint for IdP: " + trustedIdP.getName());
        }
        try {
            logoutRequest = LogoutRequestFactory.createLogoutRequest(localSP, trustedIdP, principal, idpSLOLocation, null);
        }
        catch (LoginException e) {
            throw new SAML2Exception("Could not create SAML2 LogoutRequest.", (Throwable)e);
        }
        this.signSLOMessage(localSP, trustedIdP, (SAML2ProtocolToken)logoutRequest);
        String xmlRequest = logoutRequest.generate();
        return HTTPPostBinding.generateRequestForm((String)xmlRequest, (String)relayState, (String)idpSLOLocation, null);
    }

    public String createSLORequestHttpBody(SAML2SPConfiguration configuration, LogoutRequestData data, String relayState) throws SAML2Exception, SAML2ConfigurationException {
        SAML2LogoutRequest logoutRequest;
        if (configuration == null) {
            throw new IllegalArgumentException("Parameter SAML2SPConfiguration is null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("Parameter LogoutRequestData is null.");
        }
        String trustedIdPName = data.getIdPName();
        if (trustedIdPName == null || trustedIdPName.length() < 1) {
            throw new SAML2Exception("SLO request message could not be created, because SAML2Principal does not contain trusted Identity Provider name.");
        }
        SAML2LocalSP localSP = configuration.getLocalSP();
        SAML2TrustedIdP trustedIdP = configuration.getTrustedIdP(trustedIdPName);
        if (trustedIdP == null) {
            throw new SAML2ConfigurationException("There is no configuration for trusted Identity Provider with name:" + trustedIdPName);
        }
        SAML2Endpoint idpSLOEndpoint = this.getSLOEndpoint(trustedIdP, SAML2Binding.HTTP_REDIRECT_BINDING);
        if (idpSLOEndpoint == null) {
            throw new SAML2ConfigurationException("SLO endpoint is not configured for IdP: " + trustedIdP.getName());
        }
        String idpSLOLocation = idpSLOEndpoint.getLocation();
        if (idpSLOLocation == null || idpSLOLocation.length() < 1) {
            throw new SAML2ConfigurationException("Empty location is configured in SLO endpoint for IdP: " + trustedIdP.getName());
        }
        try {
            logoutRequest = LogoutRequestFactory.createLogoutRequest(localSP, trustedIdP, data, idpSLOLocation, null);
        }
        catch (LoginException e) {
            throw new SAML2Exception("Could not create SAML2 LogoutRequest.", (Throwable)e);
        }
        this.signSLOMessage(localSP, trustedIdP, (SAML2ProtocolToken)logoutRequest);
        String xmlRequest = logoutRequest.generate();
        return HTTPPostBinding.generateRequestForm((String)xmlRequest, (String)relayState, (String)idpSLOLocation, null);
    }

    public String createSLOResponseUrl(SAML2SPConfiguration configuration, SLORequestInfo sloRequestInfo) throws SAML2Exception, SAML2ConfigurationException {
        String trustedIdPName = sloRequestInfo.getIssuer();
        if (trustedIdPName == null || trustedIdPName.length() < 1) {
            throw new SAML2Exception("SLO response message could not be created, because sloRequestInfo does not contain issuer name.");
        }
        String statusCode = "urn:oasis:names:tc:SAML:2.0:status:Success";
        SAML2LogoutResponse logoutResponse = LogoutResponseFactory.createLogoutResponse(configuration, trustedIdPName, SAML2Binding.HTTP_REDIRECT_BINDING, sloRequestInfo.getId(), statusCode, null, null);
        RedirectPayloadDeflate redirectPayload = SAML2DataFactory.getInstance().createRedirectPayloadDeflate((SAML2ProtocolToken)logoutResponse, sloRequestInfo.getRelayState());
        SAML2TrustedIdP trustedIdP = configuration.getTrustedIdP(trustedIdPName);
        if (trustedIdP == null) {
            throw new SAML2ConfigurationException("There is no configuration for trusted Identity Provider with name:" + trustedIdPName);
        }
        this.signSLORedirectPayload(configuration.getLocalSP(), trustedIdP, redirectPayload);
        String redirectUrl = HTTPRedirectBindingDeflate.generateRedirectLocationURL((String)logoutResponse.getDestination(), (RedirectPayloadDeflate)redirectPayload);
        return redirectUrl;
    }

    public String createSLOErrorResponseUrl(SAML2SPConfiguration configuration, SAML2ErrorResponseDetails errorDetails, String relayState) throws SAML2Exception, SAML2ConfigurationException {
        String trustedIdPName = errorDetails.getOriginalRequestIssuer();
        if (trustedIdPName == null || trustedIdPName.length() < 1) {
            throw new SAML2Exception("SLO error response message could not be created, because errorDetails does not contain issuer name of the original request.");
        }
        SAML2LogoutResponse logoutResponse = LogoutResponseFactory.createLogoutResponse(configuration, trustedIdPName, SAML2Binding.HTTP_REDIRECT_BINDING, errorDetails.getOriginalRequestId(), errorDetails.getStatusCode(), errorDetails.getSecondLevelStatusCode(), errorDetails.getStatusMsg());
        RedirectPayloadDeflate redirectPayload = SAML2DataFactory.getInstance().createRedirectPayloadDeflate((SAML2ProtocolToken)logoutResponse, relayState);
        SAML2TrustedIdP trustedIdP = configuration.getTrustedIdP(trustedIdPName);
        if (trustedIdP == null) {
            throw new SAML2ConfigurationException("There is no configuration for trusted Identity Provider with name:" + trustedIdPName);
        }
        this.signSLORedirectPayload(configuration.getLocalSP(), trustedIdP, redirectPayload);
        String redirectUrl = HTTPRedirectBindingDeflate.generateRedirectLocationURL((String)logoutResponse.getDestination(), (RedirectPayloadDeflate)redirectPayload);
        return redirectUrl;
    }

    public String createSLOResponseHttpBody(SAML2SPConfiguration configuration, SLORequestInfo sloRequestInfo) throws SAML2Exception, SAML2ConfigurationException {
        String trustedIdPName = sloRequestInfo.getIssuer();
        if (trustedIdPName == null || trustedIdPName.length() < 1) {
            throw new SAML2Exception("SLO request message could not be created, because sloRequestInfo does not contain issuer name.");
        }
        String statusCode = "urn:oasis:names:tc:SAML:2.0:status:Success";
        SAML2LogoutResponse logoutResponse = LogoutResponseFactory.createLogoutResponse(configuration, trustedIdPName, SAML2Binding.HTTP_POST_BINDING, sloRequestInfo.getId(), statusCode, null, null);
        SAML2TrustedIdP trustedIdP = configuration.getTrustedIdP(trustedIdPName);
        if (trustedIdP == null) {
            throw new SAML2ConfigurationException("There is no configuration for trusted Identity Provider with name:" + trustedIdPName);
        }
        this.signSLOMessage(configuration.getLocalSP(), trustedIdP, (SAML2ProtocolToken)logoutResponse);
        String xmlResponse = logoutResponse.generate();
        return HTTPPostBinding.generateResponseForm((String)xmlResponse, (String)sloRequestInfo.getRelayState(), (String)logoutResponse.getDestination(), null);
    }

    public String createSLOErrorResponseHttpBody(SAML2SPConfiguration configuration, SAML2ErrorResponseDetails errorDetails, String relayState) throws SAML2Exception, SAML2ConfigurationException {
        String trustedIdPName = errorDetails.getOriginalRequestIssuer();
        if (trustedIdPName == null || trustedIdPName.length() < 1) {
            throw new SAML2Exception("SLO error response message could not be created, because errorDetails does not contain issuer name of the original request.");
        }
        SAML2LogoutResponse logoutResponse = LogoutResponseFactory.createLogoutResponse(configuration, trustedIdPName, SAML2Binding.HTTP_POST_BINDING, errorDetails.getOriginalRequestId(), errorDetails.getStatusCode(), errorDetails.getSecondLevelStatusCode(), errorDetails.getStatusMsg());
        SAML2TrustedIdP trustedIdP = configuration.getTrustedIdP(trustedIdPName);
        if (trustedIdP == null) {
            throw new SAML2ConfigurationException("There is no configuration for trusted Identity Provider with name:" + trustedIdPName);
        }
        this.signSLOMessage(configuration.getLocalSP(), trustedIdP, (SAML2ProtocolToken)logoutResponse);
        String xmlResponse = logoutResponse.generate();
        return HTTPPostBinding.generateResponseForm((String)xmlResponse, (String)relayState, (String)logoutResponse.getDestination(), null);
    }

    public SLOInfo validateSLOMessageUrl(SAML2SPConfiguration configuration, String url) throws SAML2Exception, SAML2ErrorResponseException {
        int questionMarkIndex;
        if (LOCATION.beInfo()) {
            LOCATION.infoT("URL for SLO message validation: {0}", new Object[]{url});
        }
        if ((questionMarkIndex = url.indexOf(63)) == -1) {
            throw new SAML2Exception("Given url: " + url + " does not contain SAML2 SLO message for validation.");
        }
        String queryString = url.substring(questionMarkIndex + 1);
        RedirectPayloadDeflate redirectPayload = HTTPRedirectBindingDeflate.extractRedirectPayload((String)queryString);
        if (redirectPayload == null) {
            throw new SAML2Exception("Given url: " + url + " does not contain SAML2 SLO message for validation.");
        }
        SLOInfo result = SLOMessageValidationService.getInstance().validateSLOPayload(redirectPayload, configuration);
        String relayState = redirectPayload.getRelayState();
        result.setRelayState(relayState);
        return result;
    }

    public SLOInfo validateSLOMessageHttpBody(SAML2SPConfiguration configuration, Map<String, String> saml2PostParameters) throws SAML2Exception, SAML2ErrorResponseException {
        SLOInfo result;
        if (LOCATION.beInfo()) {
            LOCATION.infoT("SAML2 POST parameters for SLO message validation:\n{0}", new Object[]{saml2PostParameters});
        }
        if (saml2PostParameters == null || saml2PostParameters.size() < 1) {
            throw new SAML2Exception("There is not SAML2 SLO message to validate. SAML2 POST parameters map is empty");
        }
        String logoutRequestBase64 = saml2PostParameters.get("SAMLRequest");
        String logoutResponseBase64 = saml2PostParameters.get("SAMLResponse");
        if (logoutRequestBase64 != null) {
            String logoutRequestXML = SAML2Utils.decodeBase64AsString((String)logoutRequestBase64);
            result = SLOMessageValidationService.getInstance().validateSLORequest(logoutRequestXML, configuration);
        } else if (logoutResponseBase64 != null) {
            String logoutResponseXML = SAML2Utils.decodeBase64AsString((String)logoutResponseBase64);
            result = SLOMessageValidationService.getInstance().validateSLOResponse(logoutResponseXML, configuration);
        } else {
            throw new SAML2Exception("Neither SAML2 logout request, nor logout response is found in the given POST parameters");
        }
        result.setRelayState(saml2PostParameters.get("RelayState"));
        return result;
    }

    private String getTrustedIdPName(SAML2Response response, LoginResult loginResult) throws BadCredentialsException, LoginFailedException {
        String trustedIdPName = null;
        SAML2NameID issuerNameId = response.getIssuer();
        if (issuerNameId == null || issuerNameId.getName() == null || issuerNameId.getName().isEmpty()) {
            loginResult.throwBadCredentialException("SAML2Response does not specify an issuer.");
        }
        trustedIdPName = issuerNameId.getName();
        return trustedIdPName;
    }

    private void signSLORedirectPayload(SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, RedirectPayloadDeflate redirectPayload) throws SAML2Exception, SAML2ConfigurationException {
        SignatureOption signSLOMessages = trustedIdP.isToSignSingleLogoutMessages();
        if (signSLOMessages == SignatureOption.ALWAYS || signSLOMessages == SignatureOption.FRONT_CHANNEL_ONLY) {
            PrivateKey privateKey = localSP.getPrivateKeyForSignature();
            DigestAlgorithm digestAlgorithm = trustedIdP.getDigestAlgorithm();
            if (digestAlgorithm != null) {
                redirectPayload.setDigestAlgorithm(digestAlgorithm.getName());
            }
            redirectPayload.sign(privateKey);
        }
    }

    private void signSLOMessage(SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, SAML2ProtocolToken logoutMessage) throws SAML2Exception, SAML2ConfigurationException {
        SignatureOption signSLOMessages = trustedIdP.isToSignSingleLogoutMessages();
        if (signSLOMessages == SignatureOption.ALWAYS || signSLOMessages == SignatureOption.FRONT_CHANNEL_ONLY) {
            PrivateKey privateKey = localSP.getPrivateKeyForSignature();
            DigestAlgorithm digestAlgorithm = trustedIdP.getDigestAlgorithm();
            if (digestAlgorithm != null) {
                logoutMessage.setDigestAlgorithm(digestAlgorithm.getName());
            }
            if (localSP.isToIncludeCertInSignature()) {
                logoutMessage.sign(privateKey, localSP.getCertificateForSignature());
            } else {
                logoutMessage.sign(privateKey, null);
            }
        }
    }

    public SAML2Principal validateAssertion(SAML2SPConfiguration configuration, String assertion, String trustedIdPName, String recipientUrl, boolean isFrontChannelRequest) throws LoginException {
        if (LOCATION.bePath()) {
            LOCATION.entering("validateAssertion(SAML2SPConfiguration, String, String, String, boolean)", new Object[]{configuration, assertion, trustedIdPName, recipientUrl, isFrontChannelRequest});
        }
        LoginResult loginResult = new LoginResult();
        if (assertion == null || assertion.trim().length() == 0) {
            loginResult.throwBadCredentialException("The SAML2Assertion cannot be null or empty string.");
        }
        SAML2LocalSP localSP = configuration.getLocalSP();
        SAML2TrustedIdP trustedIdP = configuration.getTrustedIdP(trustedIdPName);
        if (trustedIdP == null) {
            loginResult.throwBadCredentialException("The issuer of the received SAML2Assertion is not a trusted Identity Provider. There is no configuration for IdP '" + trustedIdPName + "'");
        }
        AssertionValidationService assertionValidationService = new AssertionValidationService(localSP, trustedIdP, recipientUrl, loginResult, isFrontChannelRequest, null, false);
        SAML2Assertion saml2Assertion = assertionValidationService.validateAssertion(assertion, configuration);
        loginResult.setLocalUser(saml2Assertion.getSubjectNameID().getName());
        return this.createPrincipal(loginResult, localSP, trustedIdP);
    }

    public ValidationResult validateAssertion(SAML2SPConfiguration configuration, SAML2Assertion assertion, String trustedIdPName) throws LoginException {
        if (LOCATION.bePath()) {
            LOCATION.entering("validateAssertion(SAML2SPConfiguration, SAML2Assertion, String)", new Object[]{configuration, assertion, trustedIdPName});
        }
        LoginResult loginResult = new LoginResult();
        if (assertion == null) {
            loginResult.throwBadCredentialException("The SAML2Assertion cannot be null");
        }
        SAML2LocalSP localSP = configuration.getLocalSP();
        SAML2TrustedIdP trustedIdP = configuration.getTrustedIdP(trustedIdPName);
        if (trustedIdP == null) {
            loginResult.throwBadCredentialException("The issuer of the received SAML2Assertion is not a trusted Identity Provider. There is no configuration for IdP '" + trustedIdPName + "'");
        }
        loginResult.setIdpName(trustedIdPName);
        AssertionValidationService assertionValidationService = new AssertionValidationService(localSP, trustedIdP, null, loginResult, true, null, false, false);
        SAML2Assertion saml2Assertion = assertionValidationService.validateAssertion(assertion);
        loginResult.setLocalUser(saml2Assertion.getSubjectNameID().getName());
        SAML2Principal principal = this.createPrincipal(loginResult, localSP, trustedIdP);
        return new ValidationResult(principal, loginResult.getSubjectConfirmationNotOnOrAfter());
    }

    private SAML2Principal createPrincipal(LoginResult loginResult, SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP) {
        AuthnContext newContext = Utils.getAuthenticationContext(localSP, trustedIdP, loginResult);
        return Utils.createSAML2Principal(null, newContext, loginResult, localSP.getName());
    }
}

