/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp.sso;

import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SignatureOption;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2SPConfiguration;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalProvider;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedProvider;
import com.sap.security.saml2.commons.CommonSAML2Utils;
import com.sap.security.saml2.commons.SAML2CommonServicesManager;
import com.sap.security.saml2.lib.common.SAML2ErrorResponseDetails;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ProtocolFactory;
import com.sap.security.saml2.lib.common.exceptions.SAML2ErrorResponseException;
import com.sap.security.saml2.lib.common.exceptions.SAML2ValidationFailedException;
import com.sap.security.saml2.lib.interfaces.SAML2SignableToken;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2EncryptedNameID;
import com.sap.security.saml2.lib.interfaces.assertions.SAML2NameID;
import com.sap.security.saml2.lib.interfaces.bindings.RedirectPayloadDeflate;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutRequest;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2LogoutResponse;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2ProtocolToken;
import com.sap.security.saml2.lib.interfaces.protocols.SAML2RequestBase;
import com.sap.security.saml2.sp.sso.SLOInfo;
import com.sap.security.saml2.sp.sso.SLORequestInfo;
import com.sap.security.saml2.sp.sso.SLOResponseInfo;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.SimpleLogger;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Date;
import java.util.List;

final class SLOMessageValidationService {
    private static final Location LOCATION = Location.getLocation(SLOMessageValidationService.class);
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"Authentication");
    private static final SLOMessageValidationService INSTANCE = new SLOMessageValidationService();

    private SLOMessageValidationService() {
    }

    static SLOMessageValidationService getInstance() {
        return INSTANCE;
    }

    SLOInfo validateSLOPayload(RedirectPayloadDeflate redirectPayload, SAML2SPConfiguration cfg) throws SAML2Exception, SAML2ErrorResponseException {
        SLOInfo result;
        Object payload = redirectPayload.getSAMLPayload();
        if (!(payload instanceof SAML2LogoutRequest) && !(payload instanceof SAML2LogoutResponse)) {
            throw new SAML2Exception("Received SAML2 message is neither LogoutRequest nor LogoutResponse. Parsed token: " + payload);
        }
        SAML2ProtocolToken protocolToken = (SAML2ProtocolToken)payload;
        SAML2LocalSP localSP = cfg.getLocalSP();
        SAML2TrustedIdP trustedIdP = this.obtainTrustedIdP(cfg, protocolToken);
        this.validateMessageSignature(redirectPayload, protocolToken, localSP, trustedIdP);
        if (protocolToken instanceof SAML2LogoutRequest) {
            SAML2LogoutRequest logoutRequest = (SAML2LogoutRequest)protocolToken;
            result = this.validate(logoutRequest, localSP, trustedIdP, SAML2Binding.HTTP_REDIRECT_BINDING);
        } else if (protocolToken instanceof SAML2LogoutResponse) {
            SAML2LogoutResponse logoutResponse = (SAML2LogoutResponse)protocolToken;
            result = this.validate(logoutResponse, localSP, trustedIdP, SAML2Binding.HTTP_REDIRECT_BINDING);
        } else {
            throw new SAML2Exception("Received SAML2 message is neither LogoutRequest nor LogoutResponse. Parsed token: " + payload);
        }
        return result;
    }

    SLORequestInfo validateSLORequest(String logoutRequestXML, SAML2SPConfiguration cfg) throws SAML2Exception, SAML2ErrorResponseException {
        SAML2LogoutRequest logoutRequest = SAML2ProtocolFactory.getInstance().createLogoutRequest(logoutRequestXML);
        logoutRequest.parse();
        SAML2LocalSP localSP = cfg.getLocalSP();
        SAML2TrustedIdP trustedIdP = this.obtainTrustedIdP(cfg, (SAML2ProtocolToken)logoutRequest);
        this.validateSLOMessageSignature((SAML2ProtocolToken)logoutRequest, localSP, trustedIdP, SAML2Binding.HTTP_POST_BINDING);
        SLORequestInfo result = this.validate(logoutRequest, localSP, trustedIdP, SAML2Binding.HTTP_POST_BINDING);
        return result;
    }

    SLOResponseInfo validateSLOResponse(String logoutResponseXML, SAML2SPConfiguration cfg) throws SAML2Exception {
        SAML2LogoutResponse logoutResponse = SAML2ProtocolFactory.getInstance().createLogoutResponse(logoutResponseXML);
        logoutResponse.parse();
        SAML2LocalSP localSP = cfg.getLocalSP();
        SAML2TrustedIdP trustedIdP = this.obtainTrustedIdP(cfg, (SAML2ProtocolToken)logoutResponse);
        this.validateSLOMessageSignature((SAML2ProtocolToken)logoutResponse, localSP, trustedIdP, SAML2Binding.HTTP_POST_BINDING);
        SLOResponseInfo result = this.validate(logoutResponse, localSP, trustedIdP, SAML2Binding.HTTP_POST_BINDING);
        return result;
    }

    private SAML2TrustedIdP obtainTrustedIdP(SAML2SPConfiguration cfg, SAML2ProtocolToken protocolToken) throws SAML2Exception {
        SAML2NameID issuer = protocolToken.getIssuer();
        if (issuer == null || issuer.getName() == null) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010005", (String)"Received SLO message that does not specify an issuer.");
            throw new SAML2ValidationFailedException("Received SLO message that does not specify an issuer.");
        }
        String idpName = issuer.getName();
        SAML2TrustedIdP trustedIdP = cfg.getTrustedIdP(idpName);
        if (trustedIdP == null) {
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010040", (String)"Trusted Identity Provider [{0}] configuration could not be loaded.", (Object[])new Object[]{idpName});
            throw new SAML2Exception("Trusted Identity Provider configuration cannot be loaded: " + idpName);
        }
        if (LOCATION.beInfo()) {
            LOCATION.infoT("Trusted Identity Provider configuration: \n{0}", new Object[]{trustedIdP});
        }
        return trustedIdP;
    }

    private SLORequestInfo validate(SAML2LogoutRequest logoutRequest, SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, SAML2Binding binding) throws SAML2ErrorResponseException {
        String idpName = trustedIdP.getName();
        if (LOCATION.beInfo()) {
            boolean isSigned = logoutRequest.isSigned() || logoutRequest.isSignedOnBindingLevel();
            String signed = isSigned ? "signed" : "not signed";
            LOCATION.infoT("Received {0} LogoutRequest from Identity Provider: {1} through binding: {2}\nSAML2 message:\n {3}", new Object[]{signed, idpName, binding.getName(), logoutRequest.getXMLRepresentation()});
        }
        this.checkIssueInstant(logoutRequest, localSP, idpName);
        SAML2NameID nameId = this.obtainNameId(localSP, trustedIdP, logoutRequest);
        List sessionIndexes = logoutRequest.getSessionIndex();
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SessionIndex received in LogoutRequest: {0}", new Object[]{sessionIndexes});
        }
        if (sessionIndexes == null || sessionIndexes.isEmpty()) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010007", (String)"Service Provider SLO endpoint received LogoutRequest from Identity Provider [{0}] that does not specify any sessions to be logged out.", (Object[])new Object[]{trustedIdP.getName()});
            SAML2ErrorResponseDetails details = new SAML2ErrorResponseDetails(logoutRequest.getID(), idpName, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported", "LogoutRequest does not specify session indexes.");
            throw new SAML2ErrorResponseException(details.getStatusMsg(), details);
        }
        SLORequestInfo result = new SLORequestInfo(logoutRequest.getID(), idpName, nameId, sessionIndexes, logoutRequest);
        return result;
    }

    private SLOResponseInfo validate(SAML2LogoutResponse logoutResponse, SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, SAML2Binding binding) throws SAML2Exception {
        String idpName = trustedIdP.getName();
        if (LOCATION.beInfo()) {
            boolean isSigned = logoutResponse.isSigned() || logoutResponse.isSignedOnBindingLevel();
            String signed = isSigned ? "signed" : "not signed";
            LOCATION.infoT("Received {0} LogoutResponse from Identity Provider: {1} through binding: {2}\nSAML2 message:\n {3}", new Object[]{signed, idpName, binding.getName(), logoutResponse.getXMLRepresentation()});
        }
        SLOResponseInfo result = new SLOResponseInfo(logoutResponse.getID(), idpName, logoutResponse.getInResponseTo(), logoutResponse.getTopLevelStatusCode(), logoutResponse);
        result.setSecondaryStatusCode(logoutResponse.getSecondLevelStatusCode());
        result.setStatusMessage(logoutResponse.getStatusMessage());
        return result;
    }

    private void checkIssueInstant(SAML2LogoutRequest logoutRequest, SAML2LocalSP spConfig, String idpName) throws SAML2ErrorResponseException {
        Date issueInstant = logoutRequest.getIssueInstant();
        try {
            CommonSAML2Utils.checkIssueInstant(issueInstant, (SAML2LocalProvider)spConfig);
        }
        catch (SAML2Exception e) {
            LOCATION.traceThrowableT(400, "LogoutRequest issue instant is not valid.", (Throwable)e);
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010012", (String)"Service Provider SLO endpoint received LogoutRequest from Identity Provider [{0}] whose issue instant [{1}] is not valid. Detailed message: {2}", (Object[])new Object[]{idpName, issueInstant, e.getMessage()});
            SAML2ErrorResponseDetails details = new SAML2ErrorResponseDetails(logoutRequest.getID(), idpName, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "LogoutRequest issue instant is not valid.");
            throw new SAML2ErrorResponseException(details.getStatusMsg(), details);
        }
    }

    private void validateMessageSignature(RedirectPayloadDeflate redirectPayload, SAML2ProtocolToken protocolToken, SAML2LocalSP spConfiguration, SAML2TrustedIdP trustedIdP) throws SAML2ErrorResponseException, SAML2ValidationFailedException {
        if (redirectPayload.isSigned()) {
            try {
                SAML2CommonServicesManager.getInstance().getSignatureValidator().validateSignature((SAML2SignableToken)redirectPayload, (SAML2LocalProvider)spConfiguration, (SAML2TrustedProvider)trustedIdP);
            }
            catch (SAML2ConfigurationException e) {
                LOCATION.traceThrowableT(500, "Service Provider cannot read trusted Identity Provider [" + trustedIdP.getName() + "] certificate for signature from configuration.", (Throwable)e);
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010023", (String)"Service Provider cannot read trusted Identity Provider [{0}] certificate for signature from configuration.", (Object[])new Object[]{trustedIdP.getName()});
                if (protocolToken instanceof SAML2RequestBase) {
                    throw new SAML2ErrorResponseException("Trusted Identity Provider [" + trustedIdP.getName() + "] certificate for signature not found", (Throwable)e, new SAML2ErrorResponseDetails(protocolToken.getID(), trustedIdP.getName(), "urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Service Provider configuration error occurred."));
                }
                throw new SAML2ValidationFailedException("Trusted Identity Provider [" + trustedIdP.getName() + "] certificate for signature not found", (Throwable)e);
            }
            catch (SAML2Exception e) {
                LOCATION.traceThrowableT(400, "RedirectPayload signature is invalid.", (Throwable)e);
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010024", (String)"Service Provider SLO endpoint received RedirectPayload from Identity Provider [{0}] whose signature is invalid.", (Object[])new Object[]{trustedIdP.getName()});
                if (protocolToken instanceof SAML2RequestBase) {
                    throw new SAML2ErrorResponseException("RedirectPayload signature is invalid.", (Throwable)e, new SAML2ErrorResponseDetails(protocolToken.getID(), trustedIdP.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "RedirectPayload signature is invalid."));
                }
                throw new SAML2ValidationFailedException("RedirectPayload signature is invalid.", (Throwable)e);
            }
        } else if (trustedIdP.isToRequireSignedSingleLogoutMessages() == SignatureOption.ALWAYS || trustedIdP.isToRequireSignedSingleLogoutMessages() == SignatureOption.FRONT_CHANNEL_ONLY) {
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010003", (String)"Service Provider SLO endpoint received RedirectPayload from Identity Provider [{0}] that is not signed.", (Object[])new Object[]{trustedIdP.getName()});
            if (protocolToken instanceof SAML2RequestBase) {
                throw new SAML2ErrorResponseException("RedirectPayload is not signed.", new SAML2ErrorResponseDetails(protocolToken.getID(), trustedIdP.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "RedirectPayload is not signed."));
            }
            throw new SAML2ValidationFailedException("RedirectPayload is not signed.");
        }
    }

    private void validateSLOMessageSignature(SAML2ProtocolToken protocolToken, SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, SAML2Binding binding) throws SAML2ErrorResponseException, SAML2ValidationFailedException {
        String idpName = trustedIdP.getName();
        if (protocolToken.isSigned()) {
            try {
                SAML2CommonServicesManager.getInstance().getSignatureValidator().validateSignature((SAML2SignableToken)protocolToken, (SAML2LocalProvider)localSP, (SAML2TrustedProvider)trustedIdP);
            }
            catch (SAML2ConfigurationException e) {
                LOCATION.traceThrowableT(500, "Service Provider cannot read trusted Identity Provider [" + idpName + "] certificate for signature from configuration.", (Throwable)e);
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010023", (String)"Service Provider cannot read trusted Identity Provider [{0}] certificate for signature from configuration.", (Object[])new Object[]{idpName});
                if (protocolToken instanceof SAML2RequestBase) {
                    throw new SAML2ErrorResponseException("Could not validate SLO message signature due to missing certificate.", (Throwable)e, new SAML2ErrorResponseDetails(protocolToken.getID(), idpName, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Service Provider configuration error occurred."));
                }
                throw new SAML2ValidationFailedException("Could not validate SLO message signature due to missing certificate.", (Throwable)e);
            }
            catch (SAML2Exception e) {
                LOCATION.traceThrowableT(400, "SLO message signature is invalid.", (Throwable)e);
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010025", (String)"Service Provider SLO endpoint received SLO message from Identity Provider [{0}] whose signature is invalid.", (Object[])new Object[]{idpName});
                if (protocolToken instanceof SAML2RequestBase) {
                    throw new SAML2ErrorResponseException("SLO message signature is invalid.", new SAML2ErrorResponseDetails(protocolToken.getID(), idpName, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "SLO message signature is invalid."));
                }
                throw new SAML2ValidationFailedException("SLO message signature is invalid.", (Throwable)e);
            }
        } else if (trustedIdP.isToRequireSignedSingleLogoutMessages() == SignatureOption.ALWAYS || trustedIdP.isToRequireSignedSingleLogoutMessages() == SignatureOption.FRONT_CHANNEL_ONLY && SAML2Binding.HTTP_POST_BINDING == binding) {
            if (protocolToken.isParentSAML2TokenSignatureVerified()) {
                LOCATION.debugT("Service Provider SLO endpoint received LogoutRequest from Identity Provider [{0}] that is not signed but the ArtifactResponse has valid signature and the LogoutRequest inherits its signature.", new Object[]{idpName});
            } else {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010006", (String)"Service Provider SLO endpoint received SLO message from Identity Provider [{0}] that is not signed.", (Object[])new Object[]{idpName});
                if (protocolToken instanceof SAML2RequestBase) {
                    throw new SAML2ErrorResponseException("SLO message is not signed.", new SAML2ErrorResponseDetails(protocolToken.getID(), idpName, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "SLO message is not signed."));
                }
                throw new SAML2ValidationFailedException("SLO message is not signed.");
            }
        }
    }

    private SAML2NameID obtainNameId(SAML2LocalSP spConfig, SAML2TrustedIdP idpConfig, SAML2LogoutRequest logoutRequest) throws SAML2ErrorResponseException {
        SAML2EncryptedNameID encNameId = logoutRequest.getEncryptedNameID();
        if (encNameId == null) {
            if (idpConfig.isToRequireEncryptedSingleLogoutSubject()) {
                SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010008", (String)"Service Provider SLO endpoint received LogoutRequest from Identity Provider [{0}] that contains not encrypted Name ID.", (Object[])new Object[]{idpConfig.getName()});
                throw new SAML2ErrorResponseException("LogoutRequest does not contain encrypted Name ID.", new SAML2ErrorResponseDetails(logoutRequest.getID(), idpConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "LogoutRequest does not contain encrypted Name ID."));
            }
            return logoutRequest.getNameID();
        }
        PrivateKey privateKey = this.getPrivateKeyForEncryption(spConfig, logoutRequest.getID(), idpConfig.getName());
        try {
            SAML2NameID plainNameId = encNameId.decrypt((Key)privateKey);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Encrypted Name ID in LogoutRequest successfully decrypted: {0}", new Object[]{plainNameId});
            }
            return plainNameId;
        }
        catch (SAML2Exception e) {
            LOCATION.traceThrowableT(400, "Could not decrypt Name ID received in LogoutRequest.", (Throwable)e);
            SimpleLogger.log((int)400, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010014", (String)"Service Provider SLO endpoint could not decrypt encrypted Name ID received in LogoutRequest from Identity Provider [{0}]. Reason: {1}", (Object[])new Object[]{idpConfig.getName(), e.getMessage()});
            throw new SAML2ErrorResponseException("Could not decrypt encrypted Name ID received in LogoutRequest.", new SAML2ErrorResponseDetails(logoutRequest.getID(), idpConfig.getName(), "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "Could not decrypt encrypted Name ID received in LogoutRequest."));
        }
    }

    private PrivateKey getPrivateKeyForEncryption(SAML2LocalSP spConfig, String requestId, String idpName) throws SAML2ErrorResponseException {
        PrivateKey privateKey = null;
        try {
            privateKey = spConfig.getPrivateKeyForEncryption();
            if (privateKey == null) {
                SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010015", (String)"Service Provider cannot read its private key for encryption from configuration.");
                throw new SAML2ErrorResponseException("Could not decrypt NameId due to configuration error (missing private key for decryption).", new SAML2ErrorResponseDetails(requestId, idpName, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Service Provider configuration error occurred."));
            }
        }
        catch (SAML2ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Service Provider cannot read its private key for encryption from configuration.", (Throwable)e);
            SimpleLogger.log((int)500, (Category)CATEGORY, (Location)LOCATION, (String)"ASJ.saml20_sp.010015", (String)"Service Provider cannot read its private key for encryption from configuration.");
            throw new SAML2ErrorResponseException("Could not decrypt NameId due to configuration error (failed during reading of the private key for decryption).", new SAML2ErrorResponseDetails(requestId, idpName, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Service Provider configuration error occurred."));
        }
        return privateKey;
    }
}

