/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp.sso;

import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2Utils;
import com.sap.tc.logging.Location;
import java.net.MalformedURLException;
import java.net.URL;

class ServiceProviderUtil {
    private static final String CLIENT_CONTEXT_ALIAS_PREFIX = "S-";
    private static final String CLIENT_CONTEXT_ALIAS_DELIMITER = "@";
    private static final Location LOCATION = Location.getLocation(ServiceProviderUtil.class);
    static final String ACS_URL = "/saml2/sp/acs";

    ServiceProviderUtil() {
    }

    static int getPortFromUrl(URL url) {
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        return port;
    }

    static boolean checkRecipientUrl(String expectedRecipientUrl, String actualRecipientUrl) {
        String requestUrl;
        block13: {
            URL urlRec;
            URL urlReq;
            block15: {
                block14: {
                    block12: {
                        if (expectedRecipientUrl == null || expectedRecipientUrl.length() == 0) {
                            LOCATION.errorT("Recipient URL [{0}] is not valid.", new Object[]{expectedRecipientUrl});
                            return false;
                        }
                        requestUrl = actualRecipientUrl;
                        if (requestUrl != null && requestUrl.length() != 0) break block12;
                        LOCATION.errorT("Request URL [{0}] is not valid.", new Object[]{requestUrl});
                        return false;
                    }
                    urlReq = new URL(requestUrl);
                    urlRec = new URL(expectedRecipientUrl);
                    if (!urlRec.getHost().equalsIgnoreCase(urlReq.getHost()) || ServiceProviderUtil.getPortFromUrl(urlRec) != ServiceProviderUtil.getPortFromUrl(urlReq)) break block13;
                    if (!urlRec.getPath().equalsIgnoreCase(urlReq.getPath())) break block14;
                    if (LOCATION.beDebug()) {
                        LOCATION.debugT("Recipient URL [{0}] matches Request URL [{1}].", new Object[]{expectedRecipientUrl, requestUrl});
                    }
                    return true;
                }
                if (!urlRec.getPath().startsWith(ACS_URL)) break block15;
                if (LOCATION.beDebug()) {
                    LOCATION.debugT("Recipient URL [{0}] matches ACS endpoint URL [{1}].", new Object[]{urlRec.getPath(), ACS_URL});
                }
                return true;
            }
            if (LOCATION.beWarning()) {
                LOCATION.debugT("Recipient URL [{0}] does not match Request URL [{1}] or ACS endpoint URL [{2}].", new Object[]{urlRec.getPath(), urlReq.getPath(), ACS_URL});
            }
            return false;
        }
        try {
            if (LOCATION.beWarning()) {
                LOCATION.debugT("Recipient URL [{0}] does not match Request URL [{1}].", new Object[]{expectedRecipientUrl, requestUrl});
            }
            return false;
        }
        catch (MalformedURLException e) {
            LOCATION.traceThrowableT(500, "Cannot verify recipient host.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Cannot get request URL.", (Throwable)e);
            return false;
        }
    }

    public static String composeClientContextAlias(String sessionIndex, String spName, String idpName) {
        byte[] sha1Bytes;
        if (sessionIndex == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(spName);
        sb.append(CLIENT_CONTEXT_ALIAS_DELIMITER);
        sb.append(idpName);
        sb.append(CLIENT_CONTEXT_ALIAS_DELIMITER);
        sb.append(sessionIndex);
        String rawAlias = sb.toString();
        try {
            sha1Bytes = SAML2Utils.calculateSha1Hash((String)rawAlias);
        }
        catch (SAML2Exception sAML2Exception) {
            return CLIENT_CONTEXT_ALIAS_PREFIX + rawAlias;
        }
        String alias = CLIENT_CONTEXT_ALIAS_PREFIX + SAML2Utils.byteArrayToHEXString((byte[])sha1Bytes);
        return alias;
    }
}

