/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.sp.sso;

import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgAuthenticationContext;
import com.sap.security.saml2.cfg.interfaces.read.SAML2LocalSP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.commons.Attribute;
import com.sap.security.saml2.commons.AuthnContext;
import com.sap.security.saml2.commons.SAML2Principal;
import com.sap.security.saml2.lib.attributes.AttributeValuePair;
import com.sap.security.saml2.lib.attributes.AttributeValues;
import com.sap.security.saml2.sp.sso.LoginResult;
import com.sap.tc.logging.Location;
import java.util.HashSet;
import java.util.Set;

class Utils {
    private static final Location LOCATION = Location.getLocation(Utils.class);

    Utils() {
    }

    public static SAML2Principal createSAML2Principal(SAML2Principal saml2Principal, AuthnContext newContext, LoginResult loginResult, String spName) {
        SAML2Principal newPrincipal = null;
        if (saml2Principal != null) {
            newPrincipal = new SAML2Principal(saml2Principal, loginResult.getSessionIndex(), newContext);
        } else {
            Set<Attribute> attributes = Utils.convertAttributes(loginResult.getAssertionAttributes());
            newPrincipal = new SAML2Principal(loginResult.getLocalUser(), loginResult.getIdpName(), spName, loginResult.getPrincipalNameId(), loginResult.getPrincipalNameIdFormat(), loginResult.getNameIdSPProvidedId(), loginResult.getSubjectNameIdSPNameQualifier(), loginResult.getSubjectNameIdNameQualifier(), loginResult.getSessionIndex(), newContext, loginResult.getIdpProxyContext(), false, attributes);
        }
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SAML2Principal successfully created: {0}", new Object[]{newPrincipal});
        }
        return newPrincipal;
    }

    private static Set<Attribute> convertAttributes(AttributeValues assertionAttributes) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        for (String attributeName : assertionAttributes.keySet()) {
            AttributeValuePair assertionAttribute = assertionAttributes.get(attributeName);
            if (assertionAttribute == null) continue;
            Attribute attr = new Attribute(null, assertionAttribute.getName(), assertionAttribute.getValuesAsStrings());
            attributes.add(attr);
        }
        return attributes;
    }

    public static AuthnContext getAuthenticationContext(SAML2LocalSP localSP, SAML2TrustedIdP trustedIdP, LoginResult loginResult) {
        AuthnContext authnContext;
        String authnContextName = loginResult.getAuthenticationContext();
        SAML2CfgAuthenticationContext ac = localSP.getAuthenticationContextByName(authnContextName);
        if (ac == null) {
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Service Provider has received SAML2Assertion from Identity Provider [{0}] that contains authentication context [{1}] which could not be found in the configuration.", new Object[]{trustedIdP.getName(), authnContextName});
            }
            authnContext = new AuthnContext(authnContextName, authnContextName, false, false, false, true);
        } else {
            authnContext = new AuthnContext(ac.getName(), ac.getAlias(), ac.isInteractive(), ac.isHTTPS(), ac.isHTTP(), ac.isCustom());
        }
        return authnContext;
    }
}

