/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client;

import com.sap.cloud.runtime.kotyo.persistence.client.PersistencePropertiesProvider;
import com.sap.cloud.runtime.kotyo.persistence.client.config.PersistencePropertiesProviderImpl;
import com.sap.cloud.runtime.kotyo.persistence.client.datasource.DataSourceFactory;
import com.sap.cloud.runtime.kotyo.persistence.client.datasource.managed.ManagedDataSourceFactory;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceDataSourceFactory
implements ObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceDataSourceFactory.class);
    private static final String SUPPORTED_RESOURCE_REFERENCE_TYPE = "javax.sql.DataSource";
    private static final String RESOURCE_REF_NAME = "ResourceRefName";
    private PersistencePropertiesProvider propertiesProvider = new PersistencePropertiesProviderImpl();

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws NamingException {
        if (obj == null || !(obj instanceof Reference)) {
            throw new NameNotFoundException("Object [" + obj + "] is not instance of [" + Reference.class.getName() + "]");
        }
        Reference ref = (Reference)obj;
        if (SUPPORTED_RESOURCE_REFERENCE_TYPE.equals(ref.getClassName())) {
            String dsName = this.getDsName(ref, name);
            Properties persistenceProperties = this.propertiesProvider.getProperties(dsName);
            if (persistenceProperties == null) {
                throw new NameNotFoundException("Failed to get persistence properties for the given lookup name [" + dsName + "].");
            }
            DataSourceFactory factory = this.setUpFactory(dsName, ref);
            DataSource dataSource = factory.createDataSource(dsName, persistenceProperties);
            if (dataSource == null) {
                throw new NameNotFoundException("Cannot find correct persistence properties for the given lookup name [" + dsName + "].");
            }
            return dataSource;
        }
        throw new NameNotFoundException("Object reference class name [" + ref.getClassName() + "] is not supported type [" + SUPPORTED_RESOURCE_REFERENCE_TYPE + "]");
    }

    protected DataSourceFactory setUpFactory(String dsName, Reference ref) throws NamingException {
        return new DSFactoryFactory(dsName, ref).createFactory();
    }

    private String getDsName(Reference ref, Name name) {
        RefAddr resRefName = ref.get(RESOURCE_REF_NAME);
        if (resRefName != null) {
            return (String)resRefName.getContent();
        }
        return name.toString();
    }

    static class DSFactoryFactory {
        private final String dsName;
        private final Reference ref;

        DSFactoryFactory(String dsName, Reference ref) {
            this.dsName = dsName;
            this.ref = ref;
        }

        DataSourceFactory createFactory() throws NamingException {
            TransactionManager transactionManager = this.getTransactionManager();
            if (transactionManager != null) {
                return new ManagedDataSourceFactory(transactionManager);
            }
            logger.debug("No TransactionManager available for data source '{}', creating unmanaged datasource", (Object)this.dsName);
            return new DataSourceFactory();
        }

        private TransactionManager getTransactionManager() throws NamingException {
            RefAddr transactionalAttr = this.ref.get("transactionType");
            if (transactionalAttr != null && transactionalAttr.getContent().equals("non-transactional")) {
                logger.debug("Reference defines transactionType as non-transactional for data source '{}'", (Object)this.dsName);
                return null;
            }
            return this.lookupTransactionManager();
        }

        private TransactionManager lookupTransactionManager() throws NamingException {
            TransactionManager transactionManager = null;
            InitialContext ctx = new InitialContext();
            Object lookup = ctx.lookup("java:comp/UserTransaction");
            if (lookup instanceof TransactionManager) {
                logger.debug("JNDI lookup for 'java:comp/UserTransaction' returned TransactionManager instance");
                transactionManager = (TransactionManager)lookup;
            } else {
                logger.debug("JNDI lookup for 'java:comp/UserTransaction' did not return a TransactionManager instance");
            }
            return transactionManager;
        }
    }
}

