/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.config;

import com.sap.cloud.runtime.kotyo.persistence.client.config.KotyoImplClassLoaderBridge;
import com.sap.cloud.runtime.kotyo.persistence.client.config.PersistencePropertiesProviderImpl;
import com.sap.core.connectivity.apiext.internal.api.client.ConnectivityClient;
import com.sap.core.connectivity.apiext.internal.api.client.ConnectivityClientFactory;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DomainDBClientProvider {
    private static final Logger log = LoggerFactory.getLogger(PersistencePropertiesProviderImpl.class);
    private ConnectivityClient domainDBClient;

    DomainDBClientProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectivityClient getDomainDBClient() {
        if (this.domainDBClient != null) {
            return this.domainDBClient;
        }
        DomainDBClientProvider domainDBClientProvider = this;
        synchronized (domainDBClientProvider) {
            ConnectivityClientFactory domainDBClientFactory;
            if (this.domainDBClient == null && (domainDBClientFactory = this.getDomainDBClientFactory()) != null) {
                this.domainDBClient = domainDBClientFactory.createDomainDBClient();
            }
        }
        return this.domainDBClient;
    }

    private ConnectivityClientFactory getDomainDBClientFactory() {
        ClassLoader implClassLoader;
        try {
            implClassLoader = KotyoImplClassLoaderBridge.getImplClassLoader();
        }
        catch (IllegalStateException e) {
            log.debug("Failed to get ClassLoader for implementation libraries", (Throwable)e);
            return null;
        }
        ServiceLoader<ConnectivityClientFactory> dbClientFactoryLoader = ServiceLoader.load(ConnectivityClientFactory.class, implClassLoader);
        Iterator<ConnectivityClientFactory> iterator = dbClientFactoryLoader.iterator();
        if (iterator.hasNext()) {
            ConnectivityClientFactory factory = iterator.next();
            log.debug("Got ConnectivityClientFactory implementation {}, {}", factory.getClass(), (Object)factory);
            return factory;
        }
        throw new IllegalStateException("Could not obtain an instance of ConnectivityClientFactory");
    }
}

