/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.config;

import com.sap.cloud.runtime.kotyo.persistence.json.ConfigResponseReader;
import com.sap.core.connectivity.apiext.internal.api.client.BasicOperation;
import com.sap.core.connectivity.apiext.internal.api.client.ConnectivityClient;
import java.io.IOException;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DomainDBConfigurationProvider {
    private static final Logger log = LoggerFactory.getLogger(DomainDBConfigurationProvider.class);
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String REQUEST_PROPERTY_ACCEPT = "Accept";
    private static final String REQUEST_METHOD_GET = "GET";
    private static final String REQUEST_PROPERTY_CONTENT_TYPE = "Content-Type";
    private static final int REQUEST_CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final int REQUEST_READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(60L);
    private final ConnectivityClient domainDBClient;

    DomainDBConfigurationProvider(ConnectivityClient domainDBClient) {
        this.domainDBClient = domainDBClient;
    }

    Properties getProperties(String url) throws IOException {
        if (this.domainDBClient == null) {
            return null;
        }
        String rawConfigJson = (String)this.domainDBClient.execute(url, (ConnectivityClient.Operation)new BasicOperation<String>(){

            protected void prepare(HttpURLConnection connection) throws IOException {
                connection.setRequestProperty(DomainDBConfigurationProvider.REQUEST_PROPERTY_CONTENT_TYPE, DomainDBConfigurationProvider.JSON_CONTENT_TYPE);
                connection.setRequestProperty(DomainDBConfigurationProvider.REQUEST_PROPERTY_ACCEPT, DomainDBConfigurationProvider.JSON_CONTENT_TYPE);
                connection.setRequestMethod(DomainDBConfigurationProvider.REQUEST_METHOD_GET);
                connection.setConnectTimeout(REQUEST_CONNECT_TIMEOUT);
                connection.setReadTimeout(REQUEST_READ_TIMEOUT);
            }

            protected String executeImpl(HttpURLConnection connection) throws IOException {
                int responseCode = connection.getResponseCode();
                log.debug("Response from DB: " + responseCode);
                if (responseCode == 200) {
                    return this.readResponse(connection);
                }
                if (responseCode == 404) {
                    return null;
                }
                throw new IllegalStateException("Unexpected response from DomainDB: " + responseCode);
            }
        });
        return rawConfigJson == null ? null : this.convertToProperties(rawConfigJson);
    }

    private Properties convertToProperties(String input) throws IOException {
        log.debug("Got {}", (Object)input);
        ConfigResponseReader crr = new ConfigResponseReader();
        return crr.load(new StringReader(input));
    }
}

