/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.config;

import com.sap.cloud.runtime.kotyo.persistence.client.PersistencePropertiesProvider;
import com.sap.cloud.runtime.kotyo.persistence.client.config.DomainDBClientProvider;
import com.sap.cloud.runtime.kotyo.persistence.client.config.DomainDBConfigurationProvider;
import com.sap.cloud.runtime.kotyo.persistence.client.config.SpacePropertiesUtil;
import com.sap.core.connectivity.apiext.internal.api.client.ConnectivityClient;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DomainDBPropertiesProviderImpl
implements PersistencePropertiesProvider {
    private static final Logger logger = LoggerFactory.getLogger(DomainDBPropertiesProviderImpl.class);
    private final DomainDBClientProvider clientProvider;

    DomainDBPropertiesProviderImpl() {
        this(new DomainDBClientProvider());
    }

    DomainDBPropertiesProviderImpl(DomainDBClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Override
    public Properties getProperties(String name) {
        ConnectivityClient domainDBClient = this.clientProvider.getDomainDBClient();
        if (domainDBClient == null) {
            return null;
        }
        DomainDBConfigurationProvider configProvider = new DomainDBConfigurationProvider(domainDBClient);
        String[] urls = this.getURLFallbackSequence(name);
        try {
            for (String url : urls) {
                logger.debug("Trying to retrieve configuration from {}", (Object)url);
                Properties properties = configProvider.getProperties(url);
                if (properties == null) continue;
                return properties;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get configuration data from the DomainDB", e);
        }
        return null;
    }

    private String[] getURLFallbackSequence(String name) {
        String configurationPrefix = "/rest/configuration/account/%s/application/%s";
        String componentPath = "/--%s--com.sap.core.persistence/";
        String noComponentPath = "/com.sap.core.persistence/";
        String namedPath = "named/%s.properties";
        String unnamedPath = "persistence.properties";
        String account = SpacePropertiesUtil.getAccount();
        String application = SpacePropertiesUtil.getApplication();
        String component = SpacePropertiesUtil.getComponent();
        return new String[]{String.format("/rest/configuration/account/%s/application/%s/--%s--com.sap.core.persistence/named/%s.properties", account, application, component, name), String.format("/rest/configuration/account/%s/application/%s/--%s--com.sap.core.persistence/persistence.properties", account, application, component), String.format("/rest/configuration/account/%s/application/%s/com.sap.core.persistence/named/%s.properties", account, application, name), String.format("/rest/configuration/account/%s/application/%s/com.sap.core.persistence/persistence.properties", account, application)};
    }
}

