/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.config;

import com.sap.cloud.runtime.kotyo.persistence.client.config.LocalConfigurationLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalConfigurationHandler {
    private static final Logger logger = LoggerFactory.getLogger(LocalConfigurationHandler.class);
    private static final String DEFAULT_DSNAME = "default";
    private static final String COM_SAP_PERSISTENCE_JDBC_DSNAME = "com.sap.cloud.persistence.dsname";
    private static final String[] validPropertyPrefixes = new String[]{"javax.persistence.jdbc.", "com.sap.cloud.persistence.", "eclipselink.target-database", "com.sap.persistence.jdbc"};
    private Map<String, Properties> connectionPropertiesPerDsNameMap = null;
    private boolean namedModeActive = false;
    private final LocalConfigurationLoader configurationLoader;

    LocalConfigurationHandler() {
        this(new LocalConfigurationLoader());
    }

    LocalConfigurationHandler(LocalConfigurationLoader localConfigurationLoader) {
        this.configurationLoader = localConfigurationLoader;
    }

    boolean isNamedModeActive() {
        return this.namedModeActive;
    }

    Properties getPropertiesForDsName(String dsName) {
        if (this.connectionPropertiesPerDsNameMap == null) {
            this.connectionPropertiesPerDsNameMap = this.initialiseConnectionProperties();
        }
        return this.connectionPropertiesPerDsNameMap.get(this.namedModeActive ? dsName : DEFAULT_DSNAME);
    }

    private Map<String, Properties> initialiseConnectionProperties() {
        Properties prefixedProperties = this.configurationLoader.readLocalConfigurationFile();
        if (prefixedProperties != null) {
            Map<String, Properties> mapPerPrefix = this.initMapPerPrefix(prefixedProperties);
            return this.convertToMapPerDsName(mapPerPrefix);
        }
        return Collections.emptyMap();
    }

    private Map<String, Properties> initMapPerPrefix(Properties prefixedProperties) {
        HashMap<String, Properties> mapPerPrefix = new HashMap<String, Properties>();
        block0: for (String key : prefixedProperties.stringPropertyNames()) {
            for (String validPropertyName : validPropertyPrefixes) {
                int propNameStartIndex = key.indexOf(validPropertyName);
                if (propNameStartIndex < 0) continue;
                String prefix = key.substring(0, propNameStartIndex);
                Properties propsPerPrefix = mapPerPrefix.get(prefix);
                if (propsPerPrefix == null) {
                    propsPerPrefix = new Properties();
                    mapPerPrefix.put(prefix, propsPerPrefix);
                }
                String keyWithoutPrefix = key.substring(prefix.length());
                String value = prefixedProperties.getProperty(key);
                propsPerPrefix.put(keyWithoutPrefix, value);
                continue block0;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initialized connection properties per prefix:");
            this.logPrintableMap(mapPerPrefix);
        }
        return mapPerPrefix;
    }

    private Map<String, Properties> convertToMapPerDsName(Map<String, Properties> map) {
        HashMap<String, Properties> mapPerDsName = new HashMap<String, Properties>();
        for (Properties props : map.values()) {
            if (props.containsKey(COM_SAP_PERSISTENCE_JDBC_DSNAME)) {
                String dsName = (String)props.get(COM_SAP_PERSISTENCE_JDBC_DSNAME);
                if (!mapPerDsName.containsKey(dsName)) {
                    mapPerDsName.put((String)props.get(COM_SAP_PERSISTENCE_JDBC_DSNAME), props);
                    if (!this.namedModeActive) {
                        logger.debug("Found multiple named connection, enabling named mode");
                    }
                    this.namedModeActive = true;
                    continue;
                }
                logger.error("Incorrect connection.properties configuration. There are two data source configurations with ds name [" + dsName + "]. If not fixed, one of these configurations will be used at random.");
                continue;
            }
            if (!mapPerDsName.containsKey(DEFAULT_DSNAME)) {
                mapPerDsName.put(DEFAULT_DSNAME, props);
                continue;
            }
            logger.error("Incorrect connection.properties configuration. There are two data source configurations without ds name. If not fixed, one of these configurations will be used at random.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initialized connection properties per DS name:");
            this.logPrintableMap(mapPerDsName);
        }
        return mapPerDsName;
    }

    private void logPrintableMap(Map<String, Properties> map) {
        for (String key : map.keySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Properties with key '").append(key).append("': {");
            Properties props = map.get(key);
            boolean first = true;
            for (String name : props.stringPropertyNames()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                String value = name.contains("password") ? "***" : props.getProperty(name);
                sb.append('\"').append(name).append("\"=\"").append(value).append('\"');
            }
            sb.append("}");
            logger.debug(sb.toString());
        }
    }
}

