/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.config;

import com.sap.cloud.runtime.kotyo.persistence.client.config.DomainDBPropertiesProviderImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalConfigurationLoader {
    private static final Logger logger = LoggerFactory.getLogger(DomainDBPropertiesProviderImpl.class);
    private static final String CONFIG_HOME = "path.to.runtime.installation.folder";
    private static final String connectionPropertiesPath = "config_master/connection_data/connection.properties";
    private static final String persistencePropertiesPath = "config_master/com.sap.core.persistence/persistence.properties";

    LocalConfigurationLoader() {
    }

    Properties readLocalConfigurationFile() {
        String configHome = System.getProperty(CONFIG_HOME);
        File localPersistenceConfiguration = new File(configHome, connectionPropertiesPath);
        logger.debug("Looking for local configuration under " + localPersistenceConfiguration);
        if (localPersistenceConfiguration.isFile()) {
            return this.loadProperties(localPersistenceConfiguration);
        }
        localPersistenceConfiguration = new File(configHome, persistencePropertiesPath);
        logger.debug("Looking for local configuration under " + localPersistenceConfiguration);
        if (localPersistenceConfiguration.isFile()) {
            return this.loadProperties(localPersistenceConfiguration);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties(File localPersistenceConfiguration) {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(localPersistenceConfiguration);){
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read local connection.properties file", e);
        }
    }
}

