/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.config;

import com.sap.cloud.runtime.kotyo.persistence.client.PersistencePropertiesProvider;
import com.sap.cloud.runtime.kotyo.persistence.client.config.DomainDBPropertiesProviderImpl;
import com.sap.cloud.runtime.kotyo.persistence.client.config.LocalConfigurationHandler;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistencePropertiesProviderImpl
implements PersistencePropertiesProvider {
    private static final Logger logger = LoggerFactory.getLogger(PersistencePropertiesProviderImpl.class);

    @Override
    public Properties getProperties(String name) {
        Properties p = null;
        try {
            DomainDBPropertiesProviderImpl directRetrieval = new DomainDBPropertiesProviderImpl();
            p = directRetrieval.getProperties(name);
        }
        catch (Exception e) {
            logger.error("Direct DomainDB lookup failed", (Throwable)e);
        }
        if (p == null) {
            LocalConfigurationHandler localConfig = new LocalConfigurationHandler();
            p = localConfig.getPropertiesForDsName(name);
        }
        if (p != null) {
            this.debugLogProperties(p);
        }
        return p;
    }

    private void debugLogProperties(Properties result) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Properties temp = new Properties();
        temp.putAll((Map<?, ?>)result);
        if (temp.get("javax.persistence.jdbc.password") != null) {
            temp.put("javax.persistence.jdbc.password", "***");
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> entry : temp.entrySet()) {
            sb.append(",\"");
            sb.append(entry.getKey());
            sb.append("\":\"");
            sb.append(entry.getValue());
            sb.append("\"");
        }
        sb.append("}");
        logger.debug("Persistence properties extracted from response are: {" + sb.toString().substring(1));
    }
}

