/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpacePropertiesUtil {
    private static final Logger log = LoggerFactory.getLogger(SpacePropertiesUtil.class);
    private static final String COMPONENT = "component";
    private static final String APPLICATION = "jpApp";
    private static final String ACCOUNT = "jpSpace";
    private static final String SPACE_PROPERTIES = "space.properties";
    private static Properties spaceProperties = SpacePropertiesUtil.readPropertiesFile();

    SpacePropertiesUtil() {
    }

    static String getAccount() {
        return spaceProperties.getProperty(ACCOUNT);
    }

    static String getApplication() {
        return spaceProperties.getProperty(APPLICATION);
    }

    static String getComponent() {
        return spaceProperties.getProperty(COMPONENT);
    }

    private static Properties readPropertiesFile() {
        File f = new File(SPACE_PROPERTIES);
        Properties p = new Properties();
        if (f.isFile()) {
            try (FileInputStream inStream = new FileInputStream(f);){
                p.load(inStream);
            }
            catch (IOException e) {
                log.error("Failed to read properties from file " + f.getAbsolutePath(), (Throwable)e);
            }
        }
        return p;
    }
}

