/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.datasource;

import com.sap.cloud.runtime.kotyo.persistence.client.datasource.PropertiesWrapper;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUtil.class);
    private final String name;
    private final PropertiesWrapper properties;

    public ConfigurationUtil(String name, Properties persistenceProperties) {
        this.name = name;
        this.properties = new PropertiesWrapper(persistenceProperties);
        String normalizedName = this.normalize(name);
        if (this.properties.getBoolean("com.sap.persistence.dedicated.database", false)) {
            for (String key : Arrays.asList("com.sap.persistence.jdbc.connection.pool.enabled", "com.sap.persistence.jdbc.connection.pool.max_active", "com.sap.persistence.jdbc.connection.pool.max_wait_millis", "com.sap.persistence.jdbc.connection.pool.min_evictable_idle_time_millis", "com.sap.persistence.jdbc.connection.pool.min_idle", "com.sap.persistence.jdbc.statement.pool.enabled", "com.sap.persistence.jdbc.statement.pool.max_total")) {
                String specializedKey = key.replace("pool.", "pool." + normalizedName + ".");
                String property = System.getProperty(specializedKey);
                if (property == null) {
                    property = System.getProperty(key);
                }
                if (property == null) continue;
                persistenceProperties.put(key, property);
            }
        }
    }

    private String normalize(String name) {
        String s = name.replaceAll("/", ".");
        while (s.startsWith(".")) {
            s = s.substring(1);
        }
        while (s.endsWith(".")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String getName() {
        return this.name;
    }

    boolean isConnectionPoolEnabled() {
        return this.properties.getBoolean("com.sap.persistence.jdbc.connection.pool.enabled", true);
    }

    boolean isStatementPoolEnabled() {
        return this.properties.getBoolean("com.sap.persistence.jdbc.statement.pool.enabled", true);
    }

    GenericObjectPoolConfig getPoolConfiguration() {
        Integer minIdle;
        Long minEvictableIdleTimeMillis;
        Long maxWait;
        GenericObjectPoolConfig connPoolConfig = new GenericObjectPoolConfig();
        connPoolConfig.setMaxIdle(-1);
        connPoolConfig.setMaxWaitMillis(60000L);
        connPoolConfig.setMinEvictableIdleTimeMillis(600000L);
        connPoolConfig.setTimeBetweenEvictionRunsMillis(connPoolConfig.getMinEvictableIdleTimeMillis() / 4L);
        connPoolConfig.setNumTestsPerEvictionRun(connPoolConfig.getMaxTotal());
        Integer maxActive = this.properties.getInt("com.sap.persistence.jdbc.connection.pool.max_active");
        if (maxActive != null) {
            if (maxActive > 0) {
                connPoolConfig.setMaxTotal(maxActive.intValue());
                connPoolConfig.setNumTestsPerEvictionRun(maxActive.intValue());
            } else if (logger.isInfoEnabled()) {
                logger.info("The property com.sap.persistence.jdbc.connection.pool.max_active must be a positive integer");
            }
        }
        if ((maxWait = this.properties.getLong("com.sap.persistence.jdbc.connection.pool.max_wait_millis")) != null) {
            connPoolConfig.setMaxWaitMillis(maxWait.longValue());
        }
        if ((minEvictableIdleTimeMillis = this.properties.getLong("com.sap.persistence.jdbc.connection.pool.min_evictable_idle_time_millis")) != null) {
            connPoolConfig.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis.longValue());
            if (minEvictableIdleTimeMillis > 0L) {
                connPoolConfig.setTimeBetweenEvictionRunsMillis(Math.max(minEvictableIdleTimeMillis / 4L, 60000L));
            }
        }
        if ((minIdle = this.properties.getInt("com.sap.persistence.jdbc.connection.pool.min_idle")) != null) {
            connPoolConfig.setMinIdle(minIdle.intValue());
        }
        this.logConnectionPoolConfiguration(connPoolConfig);
        connPoolConfig.setJmxNamePrefix(this.name);
        connPoolConfig.setJmxEnabled(false);
        return connPoolConfig;
    }

    private void logConnectionPoolConfiguration(GenericObjectPoolConfig connPoolConfig) {
        if (logger.isDebugEnabled()) {
            logger.debug("JDBC connection pool configuration: maxActive = " + connPoolConfig.getMaxTotal() + ", maxWait = " + connPoolConfig.getMaxWaitMillis() + ",  minEvictableIdleTimeMillis =" + connPoolConfig.getMinEvictableIdleTimeMillis() + ", minIdle = " + connPoolConfig.getMinIdle());
        }
    }

    public int getStatementPoolDefaultSize() {
        Integer connectionPoolMaxActive = this.properties.getInt("com.sap.persistence.jdbc.connection.pool.max_active");
        if (connectionPoolMaxActive == null) {
            connectionPoolMaxActive = 8;
        }
        return connectionPoolMaxActive * 32;
    }
}

