/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceConnectionFactory
implements ConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceConnectionFactory.class);
    private final DataSource source;
    private static boolean retryEnabled = Boolean.valueOf(System.getProperty("com.sap.persistence.jdbc.connection.retry", "true"));
    private static int maxAttempts = 3;
    private static int retryDelay = 2000;

    public static void setRetryEnabled(boolean retryEnabled) {
        DataSourceConnectionFactory.retryEnabled = retryEnabled;
    }

    public static boolean isRetryEnabled() {
        return retryEnabled;
    }

    public DataSourceConnectionFactory(DataSource source) {
        this.source = source;
    }

    public Connection createConnection() throws SQLException {
        long t0 = System.currentTimeMillis();
        boolean debugEnabled = LOGGER.isDebugEnabled();
        if (debugEnabled) {
            LOGGER.debug("Opening new connection to database");
        }
        try {
            int attempt = retryEnabled ? maxAttempts : 1;
            while (true) {
                --attempt;
                try {
                    Connection connection = this.source.getConnection();
                    return connection;
                }
                catch (SQLException e) {
                    if (attempt <= 0) {
                        LOGGER.error("Failed to get connection from datasource", (Throwable)e);
                        throw e;
                    }
                    LOGGER.warn("Failed to get connection from datasource, will retry", (Throwable)e);
                    try {
                        Thread.sleep(retryDelay);
                    }
                    catch (InterruptedException e2) {
                        Thread.interrupted();
                        throw new SQLException("Failed to get connection, got interrupted");
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            if (debugEnabled) {
                t0 = System.currentTimeMillis() - t0;
                LOGGER.debug("Opened new connection to database in " + t0 + "ms");
            }
        }
    }
}

