/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.datasource;

import com.sap.cloud.runtime.kotyo.persistence.client.datasource.ConfigurationUtil;
import com.sap.cloud.runtime.kotyo.persistence.client.datasource.DataSourceConnectionFactory;
import com.sap.cloud.runtime.kotyo.persistence.client.datasource.DriverDataSource;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.PoolableConnectionFactoryAdapter;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.TraceableGenericObjectPool;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.TraceableDataSource;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceFactory.class);

    public DataSource createDataSource(String name, Properties persistenceProperties) {
        DriverDataSource driverDataSource = this.setupDriverDataSource(persistenceProperties);
        if (driverDataSource == null) {
            return null;
        }
        ConfigurationUtil configurationUtil = new ConfigurationUtil(name, persistenceProperties);
        return this.setupDataSource(configurationUtil, driverDataSource);
    }

    protected DriverDataSource setupDriverDataSource(Properties persistenceProperties) {
        if (persistenceProperties == null) {
            logger.error("Retrieved persistence properties are null!");
            return null;
        }
        if (persistenceProperties.isEmpty()) {
            logger.error("Retrieved persistence properties are empty!");
            return null;
        }
        String driver = persistenceProperties.getProperty("javax.persistence.jdbc.driver");
        if (driver == null) {
            logger.error("Retrieved persistence properties does not contain [javax.persistence.jdbc.driver]!");
            return null;
        }
        String url = persistenceProperties.getProperty("javax.persistence.jdbc.url");
        if (url == null) {
            logger.error("Retrieved persistence properties does not contain [javax.persistence.jdbc.url]!");
            return null;
        }
        String user = persistenceProperties.getProperty("javax.persistence.jdbc.user");
        if (user == null) {
            logger.error("Retrieved persistence properties does not contain [javax.persistence.jdbc.user]!");
            return null;
        }
        String password = persistenceProperties.getProperty("javax.persistence.jdbc.password");
        if (password == null) {
            logger.error("Retrieved persistence properties does not contain [javax.persistence.jdbc.password]!");
            return null;
        }
        String usePhantomReferences = (String)persistenceProperties.get("com.sap.persistence.jdbc.connection.closeHandlesByPhantomReference");
        if (usePhantomReferences == null) {
            usePhantomReferences = System.getProperty("com.sap.persistence.jdbc.connection.closeHandlesByPhantomReference");
        }
        return new DriverDataSource(driver, url, user, password, usePhantomReferences);
    }

    public DataSource setupDataSource(ConfigurationUtil configurationUtil, DataSource driverDataSource) {
        if (configurationUtil.isConnectionPoolEnabled()) {
            TraceableDataSource traceableDataSource = new TraceableDataSource(driverDataSource);
            DataSourceConnectionFactory connectionFactory = new DataSourceConnectionFactory(traceableDataSource);
            PoolableConnectionFactoryAdapter pcf = new PoolableConnectionFactoryAdapter(connectionFactory);
            this.configurePoolableConnectionFactory(pcf, configurationUtil);
            return this.createPoolingDataSource(configurationUtil, pcf);
        }
        return driverDataSource;
    }

    protected DataSource createPoolingDataSource(ConfigurationUtil configurationUtil, PoolableConnectionFactory pcf) {
        GenericObjectPoolConfig poolConfiguration = configurationUtil.getPoolConfiguration();
        TraceableGenericObjectPool connectionPool = new TraceableGenericObjectPool((PooledObjectFactory<PoolableConnection>)pcf, poolConfiguration, configurationUtil.getName());
        pcf.setPool((ObjectPool)connectionPool);
        return new PoolingDataSource((ObjectPool)connectionPool);
    }

    protected void configurePoolableConnectionFactory(PoolableConnectionFactory pcf, ConfigurationUtil configurationUtil) {
        boolean statementPoolEnabled = configurationUtil.isStatementPoolEnabled();
        pcf.setPoolStatements(statementPoolEnabled);
        pcf.setMaxOpenPrepatedStatements(configurationUtil.getStatementPoolDefaultSize());
        pcf.setDefaultReadOnly(Boolean.valueOf(false));
        pcf.setDefaultAutoCommit(Boolean.valueOf(true));
        pcf.setDefaultTransactionIsolation(2);
    }
}

