/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.datasource;

import com.sap.cloud.runtime.kotyo.persistence.client.datasource.DataSourceFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.catalina.loader.WebappClassLoaderBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverDataSource
implements DataSource {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceFactory.class);
    private static final String SSL_TRUST_ALL_CERTS = "SSL_TRUST_ALL_CERTS";
    private static final Pattern SSL_TRUST_ALL_CERTS_PATTERN = Pattern.compile("SSL_TRUST_ALL_CERTS\\=(true|false)");
    private String driverName;
    private String url;
    private String user;
    private String password;
    private Properties connectionProperties;
    private Driver driver = null;
    private PrintWriter logWriter;
    private int loginTimeout;
    private static final int HANA_ERROR_SSL_NOSSLSUPPORT_ID = -11414;
    private static final int HANA_ERROR_INTERNAL_ERROR_ID = -813;

    DriverDataSource(String driverName, String url, String user, String password, String usePhantomReferences) {
        this.driverName = driverName;
        this.url = url;
        this.user = user;
        this.password = password;
        this.initializeProperties(usePhantomReferences);
    }

    private void initializeProperties(String usePhantomReferences) {
        this.connectionProperties = new Properties();
        if (this.url.startsWith("jdbc:sybase:")) {
            Matcher matcher = SSL_TRUST_ALL_CERTS_PATTERN.matcher(this.url);
            if (matcher.find()) {
                this.connectionProperties.put(SSL_TRUST_ALL_CERTS, matcher.group(1));
            }
        } else if (this.url.startsWith("jdbc:sap:")) {
            this.preparePropertiesForHANA(usePhantomReferences);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.connectionProperties);
        props.put("user", username);
        if (password != null) {
            props.put("password", password);
        }
        return this.getDriver().connect(this.url, props);
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    private Driver getDriver() throws SQLException {
        if (this.driver == null) {
            Class<?> driverClass = null;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader instanceof WebappClassLoaderBase) {
                try {
                    driverClass = contextClassLoader.loadClass(this.driverName);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (driverClass == null) {
                try {
                    driverClass = Class.forName(this.driverName);
                }
                catch (ClassNotFoundException e) {
                    throw new SQLException("Failed to load driver class " + this.driverName, e);
                }
            }
            try {
                this.driver = (Driver)driverClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new SQLException(e);
            }
        }
        return this.driver;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private void preparePropertiesForHANA(String usePhantomReferences) {
        boolean tryEncryption;
        this.connectionProperties.put("communicationtimeout", Integer.toString(900000));
        if (usePhantomReferences != null) {
            this.connectionProperties.put("closeHandlesByPhantomReference", usePhantomReferences);
        }
        if (!(tryEncryption = Boolean.valueOf(System.getProperty("com.sap.persistence.jdbc.connection.useEncryption", "true")).booleanValue())) {
            logger.info("JDBC Encryption explicitly disabled via system property.");
        }
        if (tryEncryption) {
            this.connectionProperties.put("encrypt", "true");
            this.connectionProperties.put("validateCertificate", "false");
            try {
                Connection connection = this.getConnection();
                connection.close();
            }
            catch (SQLException ex) {
                boolean fallbackAllowed = Boolean.valueOf(System.getProperty("com.sap.persistence.jdbc.connection.enableFallbackToUnencrypted", "true"));
                if (fallbackAllowed) {
                    if (ex.getErrorCode() == -813) {
                        Throwable t = ex;
                        do {
                            if (!((t = t.getCause()) instanceof SQLException) || ((SQLException)t).getErrorCode() != -11414) continue;
                            logger.warn("Server does not support SSL, using unencrypted JDBC connection");
                            logger.debug("Server returned exception", (Throwable)ex);
                            this.connectionProperties.remove("encrypt");
                            this.connectionProperties.remove("validateCertificate");
                            return;
                        } while (t != null);
                    }
                    logger.error("Failed to open SSL test connection, encrypted communication with server failed", (Throwable)ex);
                }
                logger.error("Failed to open test connection", (Throwable)ex);
            }
        }
    }
}

