/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.datasource;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertiesWrapper {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesWrapper.class);
    private final Properties properties;

    public PropertiesWrapper(Properties properties) {
        this.properties = properties;
    }

    public Integer getInt(String key) {
        String property = this.properties.getProperty(key);
        if (property != null) {
            try {
                return Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                logger.error("Failed to parse value '" + property + "' for key '" + key + "' as integer");
            }
        }
        return null;
    }

    public Long getLong(String key) {
        String property = this.properties.getProperty(key);
        if (property != null) {
            try {
                return Long.parseLong(property);
            }
            catch (NumberFormatException e) {
                logger.error("Failed to parse value '" + property + "' for key '" + key + "' as long");
            }
        }
        return null;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String property = this.properties.getProperty(key);
        if (property != null) {
            return Boolean.parseBoolean(property);
        }
        return defaultValue;
    }
}

