/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.datasource.managed;

import com.sap.cloud.runtime.kotyo.persistence.client.datasource.ConfigurationUtil;
import com.sap.cloud.runtime.kotyo.persistence.client.datasource.DataSourceConnectionFactory;
import com.sap.cloud.runtime.kotyo.persistence.client.datasource.DataSourceFactory;
import com.sap.cloud.runtime.kotyo.persistence.client.datasource.PooledDataSource;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.managed.PoolableManagedConnectionFactoryAdapter;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.TraceableDataSource;
import java.util.Objects;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.managed.LocalXAConnectionFactory;
import org.apache.commons.dbcp2.managed.XAConnectionFactory;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.managed.local.ManagedDataSource;

public class ManagedDataSourceFactory
extends DataSourceFactory {
    private final TransactionManager transactionManager;

    public ManagedDataSourceFactory(TransactionManager transactionManager) {
        Objects.requireNonNull(transactionManager);
        this.transactionManager = transactionManager;
    }

    @Override
    public DataSource setupDataSource(ConfigurationUtil configurationUtil, DataSource driverDataSource) {
        TraceableDataSource traceableDataSource = new TraceableDataSource(driverDataSource);
        DataSourceConnectionFactory connectionFactory = new DataSourceConnectionFactory(traceableDataSource);
        LocalXAConnectionFactory xaConnectionFactory = new LocalXAConnectionFactory(this.transactionManager, (ConnectionFactory)connectionFactory);
        PoolableManagedConnectionFactoryAdapter pcf = new PoolableManagedConnectionFactoryAdapter((XAConnectionFactory)xaConnectionFactory);
        this.configurePoolableConnectionFactory((PoolableConnectionFactory)pcf, configurationUtil);
        DataSource poolingDataSource = this.createPoolingDataSource(configurationUtil, (PoolableConnectionFactory)pcf);
        PooledDataSource pooledDataSource = new PooledDataSource(poolingDataSource, driverDataSource);
        TransactionSynchronizationRegistry txSyncRegistry = (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class);
        return new ManagedDataSource((DataSource)pooledDataSource, this.transactionManager, txSyncRegistry);
    }
}

