/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.persistence.client.pool;

import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.IPoolLogger;
import com.sap.cloud.runtime.kotyo.persistence.client.pool.trace.PoolLogger;
import com.sap.cloud.runtime.kotyo.persistence.client.trace.TraceableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp2.DelegatingPreparedStatement;
import org.apache.commons.dbcp2.PStmtKey;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

public class GenericKeyedObjectPoolAdapter
extends GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement> {
    private static final IPoolLogger log = PoolLogger.getPoolLogger();

    public GenericKeyedObjectPoolAdapter(KeyedPooledObjectFactory<PStmtKey, DelegatingPreparedStatement> factory, GenericKeyedObjectPoolConfig config) {
        super(factory, config);
    }

    public DelegatingPreparedStatement borrowObject(PStmtKey key) throws Exception {
        DelegatingPreparedStatement obj = (DelegatingPreparedStatement)super.borrowObject((Object)key);
        if (log.isDebugEnabled()) {
            String info = "Borrowing '" + obj + "' for key '" + key + "'";
            log.debug(info);
        }
        return obj;
    }

    public void returnObject(PStmtKey key, DelegatingPreparedStatement obj) {
        Statement delegate;
        if (log.isDebugEnabled()) {
            String info = "Returning '" + obj + "' for key '" + key + "'";
            log.debug(info);
        }
        if (obj != null && (delegate = obj.getInnermostDelegate()) instanceof TraceableStatement) {
            TraceableStatement stmt = (TraceableStatement)delegate;
            if (stmt.isBroken()) {
                try {
                    super.invalidateObject((Object)key, (Object)obj);
                }
                catch (Exception e) {
                    log.debug("Failed to invalidate statement", e);
                }
                super.clear();
                return;
            }
            try {
                stmt.reset();
            }
            catch (SQLException e) {
                log.debug("Failed to reset statement", e);
                super.clear((Object)key);
                return;
            }
        }
        super.returnObject((Object)key, (Object)obj);
    }

    public void clear() {
        super.clear();
        if (log.isDebugEnabled()) {
            String info = "Clearing the statement pool ";
            log.debug(info);
        }
    }
}

